/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetcomposer;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import com.twitter.sdk.android.core.Result;
import com.twitter.sdk.android.core.Twitter;
import com.twitter.sdk.android.core.TwitterApiClient;
import com.twitter.sdk.android.core.TwitterAuthToken;
import com.twitter.sdk.android.core.TwitterCore;
import com.twitter.sdk.android.core.TwitterException;
import com.twitter.sdk.android.core.TwitterSession;
import com.twitter.sdk.android.core.models.Media;
import com.twitter.sdk.android.core.models.Tweet;
import com.twitter.sdk.android.tweetcomposer.FileUtils;
import java.io.File;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import retrofit2.Callback;

public class TweetUploadService
extends IntentService {
    public static final String UPLOAD_SUCCESS = "com.twitter.sdk.android.tweetcomposer.UPLOAD_SUCCESS";
    public static final String UPLOAD_FAILURE = "com.twitter.sdk.android.tweetcomposer.UPLOAD_FAILURE";
    public static final String TWEET_COMPOSE_CANCEL = "com.twitter.sdk.android.tweetcomposer.TWEET_COMPOSE_CANCEL";
    public static final String EXTRA_TWEET_ID = "EXTRA_TWEET_ID";
    public static final String EXTRA_RETRY_INTENT = "EXTRA_RETRY_INTENT";
    static final String TAG = "TweetUploadService";
    static final String EXTRA_USER_TOKEN = "EXTRA_USER_TOKEN";
    static final String EXTRA_TWEET_TEXT = "EXTRA_TWEET_TEXT";
    static final String EXTRA_IMAGE_URI = "EXTRA_IMAGE_URI";
    private static final int PLACEHOLDER_ID = -1;
    private static final String PLACEHOLDER_SCREEN_NAME = "";
    DependencyProvider dependencyProvider;
    Intent intent;

    public TweetUploadService() {
        this(new DependencyProvider());
    }

    TweetUploadService(DependencyProvider dependencyProvider) {
        super(TAG);
        this.dependencyProvider = dependencyProvider;
    }

    protected void onHandleIntent(Intent intent) {
        TwitterAuthToken token = (TwitterAuthToken)intent.getParcelableExtra(EXTRA_USER_TOKEN);
        this.intent = intent;
        TwitterSession twitterSession = new TwitterSession(token, -1L, PLACEHOLDER_SCREEN_NAME);
        String tweetText = intent.getStringExtra(EXTRA_TWEET_TEXT);
        Uri imageUri = (Uri)intent.getParcelableExtra(EXTRA_IMAGE_URI);
        this.uploadTweet(twitterSession, tweetText, imageUri);
    }

    void uploadTweet(final TwitterSession session, final String text, Uri imageUri) {
        if (imageUri != null) {
            this.uploadMedia(session, imageUri, new com.twitter.sdk.android.core.Callback<Media>(){

                public void success(Result<Media> result) {
                    TweetUploadService.this.uploadTweetWithMedia(session, text, ((Media)result.data).mediaIdString);
                }

                public void failure(TwitterException exception) {
                    TweetUploadService.this.fail(exception);
                }
            });
        } else {
            this.uploadTweetWithMedia(session, text, null);
        }
    }

    void uploadTweetWithMedia(TwitterSession session, String text, String mediaId) {
        TwitterApiClient client = this.dependencyProvider.getTwitterApiClient(session);
        client.getStatusesService().update(text, null, null, null, null, null, null, Boolean.valueOf(true), mediaId).enqueue((Callback)new com.twitter.sdk.android.core.Callback<Tweet>(){

            public void success(Result<Tweet> result) {
                TweetUploadService.this.sendSuccessBroadcast(((Tweet)result.data).getId());
                TweetUploadService.this.stopSelf();
            }

            public void failure(TwitterException exception) {
                TweetUploadService.this.fail(exception);
            }
        });
    }

    void uploadMedia(TwitterSession session, Uri imageUri, com.twitter.sdk.android.core.Callback<Media> callback) {
        TwitterApiClient client = this.dependencyProvider.getTwitterApiClient(session);
        String path = FileUtils.getPath((Context)this, imageUri);
        if (path == null) {
            this.fail(new TwitterException("Uri file path resolved to null"));
            return;
        }
        File file = new File(path);
        String mimeType = FileUtils.getMimeType(file);
        RequestBody media = RequestBody.create((MediaType)MediaType.parse((String)mimeType), (File)file);
        client.getMediaService().upload(media, null, null).enqueue(callback);
    }

    void fail(TwitterException e) {
        this.sendFailureBroadcast(this.intent);
        Twitter.getLogger().e(TAG, "Post Tweet failed", (Throwable)e);
        this.stopSelf();
    }

    void sendSuccessBroadcast(long tweetId) {
        Intent intent = new Intent(UPLOAD_SUCCESS);
        intent.putExtra(EXTRA_TWEET_ID, tweetId);
        intent.setPackage(this.getApplicationContext().getPackageName());
        this.sendBroadcast(intent);
    }

    void sendFailureBroadcast(Intent original) {
        Intent intent = new Intent(UPLOAD_FAILURE);
        intent.putExtra(EXTRA_RETRY_INTENT, (Parcelable)original);
        intent.setPackage(this.getApplicationContext().getPackageName());
        this.sendBroadcast(intent);
    }

    static class DependencyProvider {
        DependencyProvider() {
        }

        TwitterApiClient getTwitterApiClient(TwitterSession session) {
            return TwitterCore.getInstance().getApiClient(session);
        }
    }
}

