/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetcomposer;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Parcelable;
import android.text.TextUtils;
import com.twitter.sdk.android.core.GuestSessionProvider;
import com.twitter.sdk.android.core.SessionManager;
import com.twitter.sdk.android.core.Twitter;
import com.twitter.sdk.android.core.TwitterCore;
import com.twitter.sdk.android.core.TwitterSession;
import com.twitter.sdk.android.core.internal.network.UrlUtils;
import com.twitter.sdk.android.core.internal.scribe.DefaultScribeClient;
import com.twitter.sdk.android.core.internal.scribe.ScribeConfig;
import com.twitter.sdk.android.tweetcomposer.ScribeClient;
import com.twitter.sdk.android.tweetcomposer.ScribeClientImpl;
import java.net.URL;
import java.util.List;

public class TweetComposer {
    @SuppressLint(value={"StaticFieldLeak"})
    static volatile TweetComposer instance;
    private static final String MIME_TYPE_PLAIN_TEXT = "text/plain";
    private static final String MIME_TYPE_JPEG = "image/jpeg";
    private static final String TWITTER_PACKAGE_NAME = "com.twitter.android";
    private static final String WEB_INTENT = "https://twitter.com/intent/tweet?text=%s&url=%s";
    private static final String KIT_SCRIBE_NAME = "TweetComposer";
    SessionManager<TwitterSession> sessionManager;
    GuestSessionProvider guestSessionProvider;
    Context context;
    ScribeClient scribeClient = new ScribeClientImpl(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TweetComposer getInstance() {
        if (instance != null) return instance;
        Class<TweetComposer> clazz = TweetComposer.class;
        synchronized (TweetComposer.class) {
            if (instance != null) return instance;
            instance = new TweetComposer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    TweetComposer() {
        this.sessionManager = TwitterCore.getInstance().getSessionManager();
        this.guestSessionProvider = TwitterCore.getInstance().getGuestSessionProvider();
        this.context = Twitter.getInstance().getContext(this.getIdentifier());
        this.setUpScribeClient();
    }

    public String getVersion() {
        return "3.1.1.9";
    }

    private void setUpScribeClient() {
        ScribeConfig config = DefaultScribeClient.getScribeConfig((String)KIT_SCRIBE_NAME, (String)this.getVersion());
        this.scribeClient = new ScribeClientImpl(new DefaultScribeClient(this.context, this.sessionManager, this.guestSessionProvider, Twitter.getInstance().getIdManager(), config));
    }

    public String getIdentifier() {
        return "com.twitter.sdk.android:tweet-composer";
    }

    ScribeClient getScribeClient() {
        return this.scribeClient;
    }

    public static class Builder {
        private final Context context;
        private String text;
        private URL url;
        private Uri imageUri;

        public Builder(Context context) {
            if (context == null) {
                throw new IllegalArgumentException("Context must not be null.");
            }
            this.context = context;
        }

        public Builder text(String text) {
            if (text == null) {
                throw new IllegalArgumentException("text must not be null.");
            }
            if (this.text != null) {
                throw new IllegalStateException("text already set.");
            }
            this.text = text;
            return this;
        }

        public Builder url(URL url) {
            if (url == null) {
                throw new IllegalArgumentException("url must not be null.");
            }
            if (this.url != null) {
                throw new IllegalStateException("url already set.");
            }
            this.url = url;
            return this;
        }

        public Builder image(Uri imageUri) {
            if (imageUri == null) {
                throw new IllegalArgumentException("imageUri must not be null.");
            }
            if (this.imageUri != null) {
                throw new IllegalStateException("imageUri already set.");
            }
            this.imageUri = imageUri;
            return this;
        }

        public Intent createIntent() {
            Intent intent = this.createTwitterIntent();
            if (intent == null) {
                intent = this.createWebIntent();
            }
            return intent;
        }

        Intent createTwitterIntent() {
            Intent intent = new Intent("android.intent.action.SEND");
            StringBuilder builder = new StringBuilder();
            if (!TextUtils.isEmpty((CharSequence)this.text)) {
                builder.append(this.text);
            }
            if (this.url != null) {
                if (builder.length() > 0) {
                    builder.append(' ');
                }
                builder.append(this.url.toString());
            }
            intent.putExtra("android.intent.extra.TEXT", builder.toString());
            intent.setType(TweetComposer.MIME_TYPE_PLAIN_TEXT);
            if (this.imageUri != null) {
                intent.putExtra("android.intent.extra.STREAM", (Parcelable)this.imageUri);
                intent.setType(TweetComposer.MIME_TYPE_JPEG);
            }
            PackageManager packManager = this.context.getPackageManager();
            List resolvedInfoList = packManager.queryIntentActivities(intent, 65536);
            for (ResolveInfo resolveInfo : resolvedInfoList) {
                if (!resolveInfo.activityInfo.packageName.startsWith(TweetComposer.TWITTER_PACKAGE_NAME)) continue;
                intent.setClassName(resolveInfo.activityInfo.packageName, resolveInfo.activityInfo.name);
                return intent;
            }
            return null;
        }

        Intent createWebIntent() {
            String url = this.url == null ? "" : this.url.toString();
            String tweetUrl = String.format(TweetComposer.WEB_INTENT, UrlUtils.urlEncode((String)this.text), UrlUtils.urlEncode((String)url));
            return new Intent("android.intent.action.VIEW", Uri.parse((String)tweetUrl));
        }

        public void show() {
            Intent intent = this.createIntent();
            this.context.startActivity(intent);
        }
    }
}

