/**
 * Autogenerated by Thrift
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 */
package parquet.format;


import java.util.Map;
import java.util.HashMap;
import org.apache.thrift.TEnum;

/**
 * Encodings supported by Parquet.  Not all encodings are valid for all types.  These
 * enums are also used to specify the encoding of definition and repetition levels.
 * See the accompanying doc for the details of the more complicated encodings.
 */
public enum Encoding implements TEnum {
  /**
   * Default encoding.
   * BOOLEAN - 1 bit per value. 0 is false; 1 is true.
   * INT32 - 4 bytes per value.  Stored as little-endian.
   * INT64 - 8 bytes per value.  Stored as little-endian.
   * FLOAT - 4 bytes per value.  IEEE. Stored as little-endian.
   * DOUBLE - 8 bytes per value.  IEEE. Stored as little-endian.
   * BYTE_ARRAY - 4 byte length stored as little endian, followed by bytes.
   * FIXED_LEN_BYTE_ARRAY - Just the bytes.
   */
  PLAIN(0),
  /**
   * Group VarInt encoding for INT32/INT64.
   */
  GROUP_VAR_INT(1),
  /**
   * Dictionary encoding. The values in the dictionary are encoded in the
   * plain type.
   */
  PLAIN_DICTIONARY(2),
  /**
   * Group packed run length encoding. Usable for definition/reptition levels
   * encoding
   */
  RLE(3),
  /**
   * Bit packed encoding.  This can only be used if the data has a known max
   * width.  Usable for definition/repetition levels encoding.  *
   */
  BIT_PACKED(4);

  private final int value;

  private Encoding(int value) {
    this.value = value;
  }

  /**
   * Get the integer value of this enum value, as defined in the Thrift IDL.
   */
  public int getValue() {
    return value;
  }

  /**
   * Find a the enum type by its integer value, as defined in the Thrift IDL.
   * @return null if the value is not found.
   */
  public static Encoding findByValue(int value) { 
    switch (value) {
      case 0:
        return PLAIN;
      case 1:
        return GROUP_VAR_INT;
      case 2:
        return PLAIN_DICTIONARY;
      case 3:
        return RLE;
      case 4:
        return BIT_PACKED;
      default:
        return null;
    }
  }
}
