/*
 * Decompiled with CFR 0.152.
 */
package parquet.schema;

import java.util.Arrays;
import java.util.List;
import parquet.column.ColumnReader;
import parquet.io.InvalidRecordException;
import parquet.io.api.Binary;
import parquet.io.api.PrimitiveConverter;
import parquet.io.api.RecordConsumer;
import parquet.schema.GroupType;
import parquet.schema.IncompatibleSchemaModificationException;
import parquet.schema.OriginalType;
import parquet.schema.Type;
import parquet.schema.TypeConverter;
import parquet.schema.TypeVisitor;

public final class PrimitiveType
extends Type {
    private final PrimitiveTypeName primitive;

    public PrimitiveType(Type.Repetition repetition, PrimitiveTypeName primitive, String name) {
        this(repetition, primitive, name, null);
    }

    public PrimitiveType(Type.Repetition repetition, PrimitiveTypeName primitive, String name, OriginalType originalType) {
        super(name, repetition, originalType);
        this.primitive = primitive;
    }

    public PrimitiveTypeName getPrimitiveTypeName() {
        return this.primitive;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void writeToStringBuilder(StringBuilder sb, String indent) {
        sb.append(indent).append(this.getRepetition().name().toLowerCase()).append(" ").append(this.primitive.name().toLowerCase()).append(" ").append(this.getName());
        if (this.getOriginalType() != null) {
            sb.append(" (").append((Object)this.getOriginalType()).append(")");
        }
    }

    @Override
    protected boolean typeEquals(Type other) {
        if (other.isPrimitive()) {
            PrimitiveType primitiveType = other.asPrimitiveType();
            return this.getRepetition() == primitiveType.getRepetition() && this.getPrimitiveTypeName().equals((Object)primitiveType.getPrimitiveTypeName()) && this.getName().equals(primitiveType.getName());
        }
        return false;
    }

    @Override
    protected int typeHashCode() {
        int hash = 17;
        hash += 31 * this.getRepetition().hashCode();
        hash += 31 * this.getPrimitiveTypeName().hashCode();
        return hash += 31 * this.getName().hashCode();
    }

    @Override
    public int getMaxRepetitionLevel(String[] path, int i) {
        if (path.length != i) {
            throw new InvalidRecordException("Arrived at primitive node, path invalid");
        }
        return this.isRepetition(Type.Repetition.REPEATED) ? 1 : 0;
    }

    @Override
    public int getMaxDefinitionLevel(String[] path, int i) {
        if (path.length != i) {
            throw new InvalidRecordException("Arrived at primitive node, path invalid");
        }
        return this.isRepetition(Type.Repetition.REQUIRED) ? 0 : 1;
    }

    @Override
    public Type getType(String[] path, int i) {
        if (path.length != i) {
            throw new InvalidRecordException("Arrived at primitive node at index " + i + " , path invalid: " + Arrays.toString(path));
        }
        return this;
    }

    @Override
    protected List<String[]> getPaths(int depth) {
        return Arrays.asList(new String[][]{new String[depth]});
    }

    @Override
    void checkContains(Type subType) {
        super.checkContains(subType);
        if (!subType.isPrimitive()) {
            throw new InvalidRecordException(subType + " found: expected " + this);
        }
        PrimitiveType primitiveType = subType.asPrimitiveType();
        if (this.primitive != primitiveType.primitive) {
            throw new InvalidRecordException(subType + " found: expected " + this);
        }
    }

    @Override
    public <T> T convert(List<GroupType> path, TypeConverter<T> converter) {
        return converter.convertPrimitiveType(path, this);
    }

    @Override
    protected boolean containsPath(String[] path, int depth) {
        return path.length == depth;
    }

    @Override
    protected Type union(Type toMerge) {
        if (!toMerge.isPrimitive() || !this.primitive.equals((Object)toMerge.asPrimitiveType().getPrimitiveTypeName())) {
            throw new IncompatibleSchemaModificationException("can not merge type " + toMerge + " into " + this);
        }
        return new PrimitiveType(toMerge.getRepetition(), this.primitive, this.getName());
    }

    public static enum PrimitiveTypeName {
        INT64("getLong", (Class)Long.TYPE){

            @Override
            public String toString(ColumnReader columnReader) {
                return String.valueOf(columnReader.getLong());
            }

            @Override
            public void addValueToRecordConsumer(RecordConsumer recordConsumer, ColumnReader columnReader) {
                recordConsumer.addLong(columnReader.getLong());
            }

            @Override
            public void addValueToPrimitiveConverter(PrimitiveConverter primitiveConverter, ColumnReader columnReader) {
                primitiveConverter.addLong(columnReader.getLong());
            }

            @Override
            public <T, E extends Exception> T convert(PrimitiveTypeNameConverter<T, E> converter) throws E {
                return converter.convertINT64(this);
            }
        }
        ,
        INT32("getInteger", (Class)Integer.TYPE){

            @Override
            public String toString(ColumnReader columnReader) {
                return String.valueOf(columnReader.getInteger());
            }

            @Override
            public void addValueToRecordConsumer(RecordConsumer recordConsumer, ColumnReader columnReader) {
                recordConsumer.addInteger(columnReader.getInteger());
            }

            @Override
            public void addValueToPrimitiveConverter(PrimitiveConverter primitiveConverter, ColumnReader columnReader) {
                primitiveConverter.addInt(columnReader.getInteger());
            }

            @Override
            public <T, E extends Exception> T convert(PrimitiveTypeNameConverter<T, E> converter) throws E {
                return converter.convertINT32(this);
            }
        }
        ,
        BOOLEAN("getBoolean", (Class)Boolean.TYPE){

            @Override
            public String toString(ColumnReader columnReader) {
                return String.valueOf(columnReader.getBoolean());
            }

            @Override
            public void addValueToRecordConsumer(RecordConsumer recordConsumer, ColumnReader columnReader) {
                recordConsumer.addBoolean(columnReader.getBoolean());
            }

            @Override
            public void addValueToPrimitiveConverter(PrimitiveConverter primitiveConverter, ColumnReader columnReader) {
                primitiveConverter.addBoolean(columnReader.getBoolean());
            }

            @Override
            public <T, E extends Exception> T convert(PrimitiveTypeNameConverter<T, E> converter) throws E {
                return converter.convertBOOLEAN(this);
            }
        }
        ,
        BINARY("getBinary", (Class)Binary.class){

            @Override
            public String toString(ColumnReader columnReader) {
                return String.valueOf(columnReader.getBinary());
            }

            @Override
            public void addValueToRecordConsumer(RecordConsumer recordConsumer, ColumnReader columnReader) {
                recordConsumer.addBinary(columnReader.getBinary());
            }

            @Override
            public void addValueToPrimitiveConverter(PrimitiveConverter primitiveConverter, ColumnReader columnReader) {
                primitiveConverter.addBinary(columnReader.getBinary());
            }

            @Override
            public <T, E extends Exception> T convert(PrimitiveTypeNameConverter<T, E> converter) throws E {
                return converter.convertBINARY(this);
            }
        }
        ,
        FLOAT("getFloat", (Class)Float.TYPE){

            @Override
            public String toString(ColumnReader columnReader) {
                return String.valueOf(columnReader.getFloat());
            }

            @Override
            public void addValueToRecordConsumer(RecordConsumer recordConsumer, ColumnReader columnReader) {
                recordConsumer.addFloat(columnReader.getFloat());
            }

            @Override
            public void addValueToPrimitiveConverter(PrimitiveConverter primitiveConverter, ColumnReader columnReader) {
                primitiveConverter.addFloat(columnReader.getFloat());
            }

            @Override
            public <T, E extends Exception> T convert(PrimitiveTypeNameConverter<T, E> converter) throws E {
                return converter.convertFLOAT(this);
            }
        }
        ,
        DOUBLE("getDouble", (Class)Double.TYPE){

            @Override
            public String toString(ColumnReader columnReader) {
                return String.valueOf(columnReader.getDouble());
            }

            @Override
            public void addValueToRecordConsumer(RecordConsumer recordConsumer, ColumnReader columnReader) {
                recordConsumer.addDouble(columnReader.getDouble());
            }

            @Override
            public void addValueToPrimitiveConverter(PrimitiveConverter primitiveConverter, ColumnReader columnReader) {
                primitiveConverter.addDouble(columnReader.getDouble());
            }

            @Override
            public <T, E extends Exception> T convert(PrimitiveTypeNameConverter<T, E> converter) throws E {
                return converter.convertDOUBLE(this);
            }
        }
        ,
        INT96(null, null){

            @Override
            public String toString(ColumnReader columnReader) {
                throw new UnsupportedOperationException("NYI");
            }

            @Override
            public void addValueToRecordConsumer(RecordConsumer recordConsumer, ColumnReader columnReader) {
                throw new UnsupportedOperationException("NYI");
            }

            @Override
            public void addValueToPrimitiveConverter(PrimitiveConverter primitiveConverter, ColumnReader columnReader) {
                throw new UnsupportedOperationException("NYI");
            }

            @Override
            public <T, E extends Exception> T convert(PrimitiveTypeNameConverter<T, E> converter) throws E {
                return converter.convertINT96(this);
            }
        }
        ,
        FIXED_LEN_BYTE_ARRAY(null, null){

            @Override
            public String toString(ColumnReader columnReader) {
                throw new UnsupportedOperationException("NYI");
            }

            @Override
            public void addValueToRecordConsumer(RecordConsumer recordConsumer, ColumnReader columnReader) {
                throw new UnsupportedOperationException("NYI");
            }

            @Override
            public void addValueToPrimitiveConverter(PrimitiveConverter primitiveConverter, ColumnReader columnReader) {
                throw new UnsupportedOperationException("NYI");
            }

            @Override
            public <T, E extends Exception> T convert(PrimitiveTypeNameConverter<T, E> converter) throws E {
                return converter.convertFIXED_LEN_BYTE_ARRAY(this);
            }
        };

        public final String getMethod;
        public final Class<?> javaType;

        private PrimitiveTypeName(String getMethod, Class<?> javaType) {
            this.getMethod = getMethod;
            this.javaType = javaType;
        }

        public abstract String toString(ColumnReader var1);

        public abstract void addValueToRecordConsumer(RecordConsumer var1, ColumnReader var2);

        public abstract void addValueToPrimitiveConverter(PrimitiveConverter var1, ColumnReader var2);

        public abstract <T, E extends Exception> T convert(PrimitiveTypeNameConverter<T, E> var1) throws E;
    }

    public static interface PrimitiveTypeNameConverter<T, E extends Exception> {
        public T convertFLOAT(PrimitiveTypeName var1) throws E;

        public T convertDOUBLE(PrimitiveTypeName var1) throws E;

        public T convertINT32(PrimitiveTypeName var1) throws E;

        public T convertINT64(PrimitiveTypeName var1) throws E;

        public T convertINT96(PrimitiveTypeName var1) throws E;

        public T convertFIXED_LEN_BYTE_ARRAY(PrimitiveTypeName var1) throws E;

        public T convertBOOLEAN(PrimitiveTypeName var1) throws E;

        public T convertBINARY(PrimitiveTypeName var1) throws E;
    }
}

