/*
 * Decompiled with CFR 0.152.
 */
package parquet.column;

import java.io.IOException;
import parquet.bytes.BytesUtils;
import parquet.column.ColumnDescriptor;
import parquet.column.Dictionary;
import parquet.column.ValuesType;
import parquet.column.page.DictionaryPage;
import parquet.column.values.ValuesReader;
import parquet.column.values.bitpacking.ByteBitPackingValuesReader;
import parquet.column.values.bitpacking.Packer;
import parquet.column.values.boundedint.ZeroIntegerValuesReader;
import parquet.column.values.dictionary.DictionaryValuesReader;
import parquet.column.values.dictionary.PlainValuesDictionary;
import parquet.column.values.plain.BinaryPlainValuesReader;
import parquet.column.values.plain.BooleanPlainValuesReader;
import parquet.column.values.plain.PlainValuesReader;
import parquet.column.values.rle.RunLengthBitPackingHybridValuesReader;
import parquet.io.ParquetDecodingException;

public enum Encoding {
    PLAIN{

        @Override
        public ValuesReader getValuesReader(ColumnDescriptor descriptor, ValuesType valuesType) {
            switch (descriptor.getType()) {
                case BOOLEAN: {
                    return new BooleanPlainValuesReader();
                }
                case BINARY: {
                    return new BinaryPlainValuesReader();
                }
                case FLOAT: {
                    return new PlainValuesReader.FloatPlainValuesReader();
                }
                case DOUBLE: {
                    return new PlainValuesReader.DoublePlainValuesReader();
                }
                case INT32: {
                    return new PlainValuesReader.IntegerPlainValuesReader();
                }
                case INT64: {
                    return new PlainValuesReader.LongPlainValuesReader();
                }
            }
            throw new ParquetDecodingException("no plain reader for type " + (Object)((Object)descriptor.getType()));
        }
    }
    ,
    RLE{

        @Override
        public ValuesReader getValuesReader(ColumnDescriptor descriptor, ValuesType valuesType) {
            int bitWidth = BytesUtils.getWidthFromMaxInt((int)this.getMaxLevel(descriptor, valuesType));
            if (bitWidth == 0) {
                return new ZeroIntegerValuesReader();
            }
            return new RunLengthBitPackingHybridValuesReader(bitWidth);
        }
    }
    ,
    BIT_PACKED{

        @Override
        public ValuesReader getValuesReader(ColumnDescriptor descriptor, ValuesType valuesType) {
            return new ByteBitPackingValuesReader(this.getMaxLevel(descriptor, valuesType), Packer.BIG_ENDIAN);
        }
    }
    ,
    GROUP_VAR_INT{

        @Override
        public ValuesReader getValuesReader(ColumnDescriptor descriptor, ValuesType valuesType) {
            throw new UnsupportedOperationException("NYI");
        }
    }
    ,
    PLAIN_DICTIONARY{

        @Override
        public ValuesReader getDictionaryBasedValuesReader(ColumnDescriptor descriptor, ValuesType valuesType, Dictionary dictionary) {
            switch (descriptor.getType()) {
                case BINARY: 
                case FLOAT: 
                case DOUBLE: 
                case INT32: 
                case INT64: {
                    return new DictionaryValuesReader(dictionary);
                }
            }
            throw new ParquetDecodingException("Dictionary encoding not supported for type: " + (Object)((Object)descriptor.getType()));
        }

        @Override
        public Dictionary initDictionary(ColumnDescriptor descriptor, DictionaryPage dictionaryPage) throws IOException {
            switch (descriptor.getType()) {
                case BINARY: {
                    return new PlainValuesDictionary.PlainBinaryDictionary(dictionaryPage);
                }
                case INT64: {
                    return new PlainValuesDictionary.PlainLongDictionary(dictionaryPage);
                }
                case DOUBLE: {
                    return new PlainValuesDictionary.PlainDoubleDictionary(dictionaryPage);
                }
                case INT32: {
                    return new PlainValuesDictionary.PlainIntegerDictionary(dictionaryPage);
                }
                case FLOAT: {
                    return new PlainValuesDictionary.PlainFloatDictionary(dictionaryPage);
                }
            }
            throw new ParquetDecodingException("Dictionary encoding not supported for type: " + (Object)((Object)descriptor.getType()));
        }

        @Override
        public boolean usesDictionary() {
            return true;
        }
    };


    int getMaxLevel(ColumnDescriptor descriptor, ValuesType valuesType) {
        int maxLevel;
        switch (valuesType) {
            case REPETITION_LEVEL: {
                maxLevel = descriptor.getMaxRepetitionLevel();
                break;
            }
            case DEFINITION_LEVEL: {
                maxLevel = descriptor.getMaxDefinitionLevel();
                break;
            }
            default: {
                throw new ParquetDecodingException("Unsupported encoding for values: " + (Object)((Object)this));
            }
        }
        return maxLevel;
    }

    public boolean usesDictionary() {
        return false;
    }

    public Dictionary initDictionary(ColumnDescriptor descriptor, DictionaryPage dictionaryPage) throws IOException {
        throw new UnsupportedOperationException(this.name() + " does not support dictionary");
    }

    public ValuesReader getValuesReader(ColumnDescriptor descriptor, ValuesType valuesType) {
        throw new UnsupportedOperationException("Error decoding " + descriptor + ". " + this.name() + " is dictionary based");
    }

    public ValuesReader getDictionaryBasedValuesReader(ColumnDescriptor descriptor, ValuesType valuesType, Dictionary dictionary) {
        throw new UnsupportedOperationException(this.name() + " is not dictionary based");
    }
}

