/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.ostrich.stats;

import com.twitter.logging.Logger$;
import com.twitter.ostrich.stats.Distribution;
import com.twitter.ostrich.stats.StatsProvider;
import com.twitter.ostrich.stats.StatsSummary;
import com.twitter.util.Duration;
import com.twitter.util.Future;
import com.twitter.util.Stopwatch$;
import com.twitter.util.TimeLike;
import com.twitter.util.Try;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;

public abstract class StatsProvider$class {
    public static void addMetric(StatsProvider $this, String name, int value) {
        if (value >= 0) {
            $this.getMetric(name).add(value);
        } else {
            $this.log().warning("Tried to add a negative data point: %s", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name}));
        }
    }

    public static void addMetric(StatsProvider $this, String name, Distribution distribution) {
        $this.getMetric(name).add(distribution);
    }

    public static long incr(StatsProvider $this, String name, int count) {
        return $this.getCounter(name).incr(count);
    }

    public static long incr(StatsProvider $this, String name) {
        return $this.incr(name, 1);
    }

    public static void setGauge(StatsProvider $this, String name, double value) {
        $this.addGauge(name, (Function0<Object>)new Serializable($this, value){
            public static final long serialVersionUID = 0L;
            private final double value$1;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return this.value$1;
            }
            {
                this.value$1 = value$1;
            }
        });
    }

    public static StatsSummary get(StatsProvider $this) {
        return new StatsSummary($this.getCounters(), $this.getMetrics(), $this.getGauges(), $this.getLabels());
    }

    public static Object time(StatsProvider $this, String name, Function0 f) {
        Function0 duration = Stopwatch$.MODULE$.start();
        Object rv = f.apply();
        $this.addMetric(new StringBuilder().append((Object)name).append((Object)"_msec").toString(), (int)((TimeLike)duration.apply()).inMilliseconds());
        return rv;
    }

    public static Future timeFutureMicros(StatsProvider $this, String name, Future f) {
        Function0 elapsed = Stopwatch$.MODULE$.start();
        f.respond((Function1)new Serializable($this, elapsed, name){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StatsProvider $outer;
            private final Function0 elapsed$1;
            private final String name$1;

            public final void apply(Try<T> x$5) {
                this.$outer.addMetric(new StringBuilder().append((Object)this.name$1).append((Object)"_usec").toString(), (int)((TimeLike)this.elapsed$1.apply()).inMicroseconds());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.elapsed$1 = elapsed$1;
                this.name$1 = name$1;
            }
        });
        return f;
    }

    public static Future timeFutureMillis(StatsProvider $this, String name, Future f) {
        return $this.timeFutureMillisLazy(name, new Serializable($this, f){
            public static final long serialVersionUID = 0L;
            private final Future f$1;

            public final Future<T> apply() {
                return this.f$1;
            }
            {
                this.f$1 = f$1;
            }
        });
    }

    public static Future timeFutureMillisLazy(StatsProvider $this, String name, Function0 f) {
        Function0 elapsed = Stopwatch$.MODULE$.start();
        return ((Future)f.apply()).ensure((Function0)new Serializable($this, elapsed, name){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StatsProvider $outer;
            private final Function0 elapsed$2;
            private final String name$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.addMetric(new StringBuilder().append((Object)this.name$2).append((Object)"_msec").toString(), (int)((TimeLike)this.elapsed$2.apply()).inMilliseconds());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.elapsed$2 = elapsed$2;
                this.name$2 = name$2;
            }
        });
    }

    public static Future timeFutureNanos(StatsProvider $this, String name, Future f) {
        Function0 elapsed = Stopwatch$.MODULE$.start();
        f.respond((Function1)new Serializable($this, elapsed, name){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StatsProvider $outer;
            private final Function0 elapsed$3;
            private final String name$3;

            public final void apply(Try<T> x$6) {
                this.$outer.addMetric(new StringBuilder().append((Object)this.name$3).append((Object)"_nsec").toString(), (int)((Duration)this.elapsed$3.apply()).inNanoseconds());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.elapsed$3 = elapsed$3;
                this.name$3 = name$3;
            }
        });
        return f;
    }

    public static Object timeMicros(StatsProvider $this, String name, Function0 f) {
        Function0 duration = Stopwatch$.MODULE$.start();
        Object rv = f.apply();
        $this.addMetric(new StringBuilder().append((Object)name).append((Object)"_usec").toString(), (int)((TimeLike)duration.apply()).inMicroseconds());
        return rv;
    }

    public static Object timeNanos(StatsProvider $this, String name, Function0 f) {
        Function0 duration = Stopwatch$.MODULE$.start();
        Object rv = f.apply();
        $this.addMetric(new StringBuilder().append((Object)name).append((Object)"_nsec").toString(), (int)((Duration)duration.apply()).inNanoseconds());
        return rv;
    }

    public static void $init$(StatsProvider $this) {
        $this.com$twitter$ostrich$stats$StatsProvider$_setter_$log_$eq(Logger$.MODULE$.get($this.getClass().getName()));
    }
}

