/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.ostrich.stats;

import com.twitter.logging.Logger;
import com.twitter.logging.Logger$;
import com.twitter.ostrich.admin.PeriodicBackgroundProcess;
import com.twitter.ostrich.stats.Distribution;
import com.twitter.ostrich.stats.StatsCollection;
import com.twitter.ostrich.stats.StatsListener;
import com.twitter.ostrich.stats.StatsSummary;
import com.twitter.util.Duration;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Locale;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001B\u0001\u0003\u0001-\u00111c\u0012:ba\"LG/Z*uCR\u001cHj\\4hKJT!a\u0001\u0003\u0002\u000bM$\u0018\r^:\u000b\u0005\u00151\u0011aB8tiJL7\r\u001b\u0006\u0003\u000f!\tq\u0001^<jiR,'OC\u0001\n\u0003\r\u0019w.\\\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e!5\taB\u0003\u0002\u0010\t\u0005)\u0011\rZ7j]&\u0011\u0011C\u0004\u0002\u001a!\u0016\u0014\u0018n\u001c3jG\n\u000b7m[4s_VtG\r\u0015:pG\u0016\u001c8\u000f\u0003\u0005\u0014\u0001\t\u0015\r\u0011\"\u0001\u0015\u0003\u0011Awn\u001d;\u0016\u0003U\u0001\"A\u0006\u000f\u000f\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0002\rA\u0013X\rZ3g\u0013\tibD\u0001\u0004TiJLgn\u001a\u0006\u00037aA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I!F\u0001\u0006Q>\u001cH\u000f\t\u0005\tE\u0001\u0011)\u0019!C\u0001G\u0005!\u0001o\u001c:u+\u0005!\u0003CA\f&\u0013\t1\u0003DA\u0002J]RD\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I\u0001J\u0001\u0006a>\u0014H\u000f\t\u0005\tU\u0001\u0011)\u0019!C\u0001W\u00051\u0001/\u001a:j_\u0012,\u0012\u0001\f\t\u0003[Aj\u0011A\f\u0006\u0003_\u0019\tA!\u001e;jY&\u0011\u0011G\f\u0002\t\tV\u0014\u0018\r^5p]\"A1\u0007\u0001B\u0001B\u0003%A&A\u0004qKJLw\u000e\u001a\u0011\t\u0011U\u0002!Q1A\u0005\u0002Q\ta\u0001\u001d:fM&D\b\u0002C\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u000b\u0002\u000fA\u0014XMZ5yA!A\u0011\b\u0001BC\u0002\u0013\u0005!(A\u0006tKJ4\u0018nY3OC6,W#A\u001e\u0011\u0007]aT#\u0003\u0002>1\t1q\n\u001d;j_:D\u0001b\u0010\u0001\u0003\u0002\u0003\u0006IaO\u0001\rg\u0016\u0014h/[2f\u001d\u0006lW\r\t\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\u0011\u0005\r#U\"\u0001\u0002\n\u0005\u0015\u0013!aD*uCR\u001c8i\u001c7mK\u000e$\u0018n\u001c8\t\u000b\u001d\u0003A\u0011\u0001%\u0002\rqJg.\u001b;?)\u001dI%j\u0013'N\u001d>\u0003\"a\u0011\u0001\t\u000bM1\u0005\u0019A\u000b\t\u000b\t2\u0005\u0019\u0001\u0013\t\u000b)2\u0005\u0019\u0001\u0017\t\u000bU2\u0005\u0019A\u000b\t\u000be2\u0005\u0019A\u001e\t\u000b\u00053\u0005\u0019\u0001\"\t\u000fE\u0003!\u0019!C\u0001%\u00061An\\4hKJ,\u0012a\u0015\t\u0003)^k\u0011!\u0016\u0006\u0003-\u001a\tq\u0001\\8hO&tw-\u0003\u0002Y+\n1Aj\\4hKJDaA\u0017\u0001!\u0002\u0013\u0019\u0016a\u00027pO\u001e,'\u000f\t\u0005\b9\u0002\u0011\r\u0011\"\u0001^\u0003!a\u0017n\u001d;f]\u0016\u0014X#\u00010\u0011\u0005\r{\u0016B\u00011\u0003\u00055\u0019F/\u0019;t\u0019&\u001cH/\u001a8fe\"1!\r\u0001Q\u0001\ny\u000b\u0011\u0002\\5ti\u0016tWM\u001d\u0011\t\u000f\u0011\u0004!\u0019!C\u0001K\u0006A\u0001n\\:u]\u0006lW-F\u0001g!\t9G.D\u0001i\u0015\tI'.\u0001\u0003mC:<'\"A6\u0002\t)\fg/Y\u0005\u0003;!DaA\u001c\u0001!\u0002\u00131\u0017!\u00035pgRt\u0017-\\3!\u0011\u0015\u0001\b\u0001\"\u0001r\u0003!\u0001XM]5pI&\u001cG#\u0001:\u0011\u0005]\u0019\u0018B\u0001;\u0019\u0005\u0011)f.\u001b;\t\u000bY\u0004A\u0011A<\u0002\u000b]\u0014\u0018\u000e^3\u0015\u0005ID\b\"B=v\u0001\u0004Q\u0018\u0001B:pG.\u0004\"a\u001f@\u000e\u0003qT!! 6\u0002\u00079,G/\u0003\u0002\u0000y\n11k\\2lKR\u0004")
public class GraphiteStatsLogger
extends PeriodicBackgroundProcess {
    private final String host;
    private final int port;
    private final Duration period;
    private final String prefix;
    private final Option<String> serviceName;
    private final Logger logger;
    private final StatsListener listener;
    private final String hostname;

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public Duration period() {
        return this.period;
    }

    public String prefix() {
        return this.prefix;
    }

    public Option<String> serviceName() {
        return this.serviceName;
    }

    public Logger logger() {
        return this.logger;
    }

    public StatsListener listener() {
        return this.listener;
    }

    public String hostname() {
        return this.hostname;
    }

    @Override
    public void periodic() {
        try {
            this.write(new Socket(this.host(), this.port()));
        }
        catch (IOException iOException) {
            this.logger().error("Error connecting to graphite: %s", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{iOException.getMessage()}));
        }
    }

    public void write(Socket sock) {
        block22: {
            block18: {
                StatsSummary stats = this.listener().get();
                Map statMap = ((MapLike)stats.counters().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<String, Object> apply(Tuple2<String, Object> x0$1) {
                        Tuple2<String, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            String key = (String)tuple2._1();
                            long value = tuple2._2$mcJ$sp();
                            Tuple2 tuple22 = new Tuple2((Object)key, (Object)BoxesRunTime.boxToDouble((double)Predef$.MODULE$.long2Long(value).doubleValue()));
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Map$.MODULE$.canBuildFrom())).$plus$plus(stats.gauges()).$plus$plus((GenTraversableOnce)stats.metrics().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Map<String, Object> apply(Tuple2<String, Distribution> x0$2) {
                        Tuple2<String, Distribution> tuple2 = x0$2;
                        if (tuple2 != null) {
                            String key = (String)tuple2._1();
                            Distribution distribution = (Distribution)tuple2._2();
                            Map map = (Map)distribution.toMap().map((Function1)new Serializable(this, key){
                                public static final long serialVersionUID = 0L;
                                private final String key$1;

                                public final Tuple2<String, Object> apply(Tuple2<String, Object> x0$3) {
                                    Tuple2<String, Object> tuple2 = x0$3;
                                    if (tuple2 != null) {
                                        String subkey = (String)tuple2._1();
                                        long value = tuple2._2$mcJ$sp();
                                        Tuple2 tuple22 = new Tuple2((Object)new StringBuilder().append((Object)this.key$1).append((Object)"_").append((Object)subkey).toString(), (Object)BoxesRunTime.boxToDouble((double)Predef$.MODULE$.long2Long(value).doubleValue()));
                                        return tuple22;
                                    }
                                    throw new MatchError(tuple2);
                                }
                                {
                                    this.key$1 = key$1;
                                }
                            }, Map$.MODULE$.canBuildFrom());
                            return map;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Map$.MODULE$.canBuildFrom()));
                Map cleanedKeysStatMap = (Map)statMap.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<String, Object> apply(Tuple2<String, Object> x0$4) {
                        Tuple2<String, Object> tuple2 = x0$4;
                        if (tuple2 != null) {
                            String key = (String)tuple2._1();
                            double value = tuple2._2$mcD$sp();
                            Tuple2 tuple22 = new Tuple2((Object)key.replaceAll(":", "_").replaceAll("/", ".").replaceAll(" ", "_").toLowerCase(), (Object)BoxesRunTime.boxToDouble((double)value));
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Map$.MODULE$.canBuildFrom());
                ObjectRef writer = new ObjectRef(null);
                try {
                    try {
                        long epoch = System.currentTimeMillis() / 1000L;
                        writer.elem = new OutputStreamWriter(sock.getOutputStream());
                        try {
                            cleanedKeysStatMap.foreach((Function1)new Serializable(this, writer, epoch){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ GraphiteStatsLogger $outer;
                                private final ObjectRef writer$1;
                                private final long epoch$1;

                                public final void apply(Tuple2<String, Object> x0$5) {
                                    Tuple2<String, Object> tuple2 = x0$5;
                                    if (tuple2 != null) {
                                        String key = (String)tuple2._1();
                                        double value = tuple2._2$mcD$sp();
                                        ((OutputStreamWriter)this.writer$1.elem).write(new StringOps(Predef$.MODULE$.augmentString("%s.%s.%s %.2f %d\n")).formatLocal(Locale.US, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.prefix(), this.$outer.serviceName().getOrElse((Function0)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final String apply() {
                                                return "unknown";
                                            }
                                        }), key, BoxesRunTime.boxToDouble((double)Predef$.MODULE$.double2Double(value)), BoxesRunTime.boxToLong((long)this.epoch$1)})));
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        return;
                                    }
                                    throw new MatchError(tuple2);
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.writer$1 = writer$1;
                                    this.epoch$1 = epoch$1;
                                }
                            });
                        }
                        catch (IOException iOException) {
                            this.logger().error("Error writing data to graphite: %s", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{iOException.getMessage()}));
                        }
                        ((OutputStreamWriter)writer.elem).flush();
                        break block18;
                    }
                    catch (Exception exception) {
                        this.logger().error("Error writing to Graphite: %s", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{exception.getMessage()}));
                        if ((OutputStreamWriter)writer.elem != null) {
                            try {
                                ((OutputStreamWriter)writer.elem).flush();
                            }
                            catch (IOException iOException) {
                                this.logger().error("Error while flushing writer: %s", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{iOException.getMessage()}));
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (sock != null) {
                        try {
                            sock.close();
                        }
                        catch (IOException iOException) {
                            this.logger().error("Error while closing socket: %s", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{iOException.getMessage()}));
                        }
                    }
                    writer.elem = null;
                    throw throwable;
                }
                if (sock != null) {
                    try {
                        sock.close();
                    }
                    catch (IOException iOException) {
                        this.logger().error("Error while closing socket: %s", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{iOException.getMessage()}));
                    }
                }
                writer.elem = null;
                break block22;
            }
            if (sock != null) {
                try {
                    sock.close();
                }
                catch (IOException iOException) {
                    this.logger().error("Error while closing socket: %s", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{iOException.getMessage()}));
                }
            }
            writer.elem = null;
        }
    }

    public GraphiteStatsLogger(String host, int port, Duration period, String prefix, Option<String> serviceName, StatsCollection collection) {
        this.host = host;
        this.port = port;
        this.period = period;
        this.prefix = prefix;
        this.serviceName = serviceName;
        super("GraphiteStatsLogger", period);
        this.logger = Logger$.MODULE$.get();
        this.listener = new StatsListener(collection);
        this.hostname = InetAddress.getLocalHost().getCanonicalHostName();
    }
}

