/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.hpack;

import com.twitter.hpack.HeaderField;
import com.twitter.hpack.HpackUtil;
import com.twitter.hpack.Huffman;
import com.twitter.hpack.StaticTable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class Encoder {
    private static final int BUCKET_SIZE = 17;
    private static final byte[] EMPTY = new byte[0];
    private final boolean useIndexing;
    private final boolean forceHuffmanOn;
    private final boolean forceHuffmanOff;
    private final HeaderEntry[] headerTable = new HeaderEntry[17];
    private final HeaderEntry head = new HeaderEntry(-1, EMPTY, EMPTY, Integer.MAX_VALUE, null);
    private int size;
    private int capacity;

    public Encoder() {
        this(4096);
    }

    public Encoder(int maxHeaderTableSize) {
        this(maxHeaderTableSize, true, false, false);
    }

    Encoder(int maxHeaderTableSize, boolean useIndexing, boolean forceHuffmanOn, boolean forceHuffmanOff) {
        if (maxHeaderTableSize < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + maxHeaderTableSize);
        }
        this.useIndexing = useIndexing;
        this.forceHuffmanOn = forceHuffmanOn;
        this.forceHuffmanOff = forceHuffmanOff;
        this.capacity = maxHeaderTableSize;
        this.head.before = this.head.after = this.head;
    }

    public void encodeHeader(OutputStream out, byte[] name, byte[] value) throws IOException {
        int headerSize = HeaderField.sizeOf(name, value);
        if (headerSize > this.capacity) {
            int nameIndex = this.getNameIndex(name);
            this.encodeLiteral(out, name, value, false, nameIndex);
            return;
        }
        HeaderEntry headerField = this.getEntry(name, value);
        if (headerField != null) {
            int index = this.getIndex(headerField.index);
            if (headerField.inReferenceSet) {
                if (headerField.emitted) {
                    Encoder.encodeInteger(out, 128, 7, index);
                    Encoder.encodeInteger(out, 128, 7, index);
                    Encoder.encodeInteger(out, 128, 7, index);
                    Encoder.encodeInteger(out, 128, 7, index);
                    headerField.inReferenceSet = false;
                } else {
                    headerField.emitted = true;
                }
            } else {
                if (headerField.emitted) {
                    Encoder.encodeInteger(out, 128, 7, index);
                }
                Encoder.encodeInteger(out, 128, 7, index);
                headerField.emitted = true;
            }
        } else {
            int staticTableIndex = StaticTable.getIndex(name, value);
            if (staticTableIndex != -1 && this.useIndexing) {
                int nameIndex = staticTableIndex + this.length();
                this.ensureCapacity(out, headerSize);
                this.add(name, value);
                Encoder.encodeInteger(out, 128, 7, nameIndex);
            } else {
                int nameIndex = this.getNameIndex(name);
                if (this.useIndexing) {
                    this.ensureCapacity(out, headerSize);
                }
                this.encodeLiteral(out, name, value, this.useIndexing, nameIndex);
                if (this.useIndexing) {
                    this.add(name, value);
                }
            }
        }
    }

    public void endHeaders(OutputStream out) throws IOException {
        HeaderEntry entry = this.head.before;
        while (entry != this.head) {
            if (entry.emitted) {
                entry.inReferenceSet = true;
                entry.emitted = false;
            } else if (entry.inReferenceSet) {
                Encoder.encodeInteger(out, 128, 7, this.getIndex(entry.index));
                entry.inReferenceSet = false;
            }
            entry = entry.before;
        }
    }

    public void clearReferenceSet(OutputStream out) throws IOException {
        HeaderEntry entry = this.head.before;
        while (entry != this.head) {
            entry.inReferenceSet = false;
            entry.emitted = false;
            entry = entry.before;
        }
        out.write(128);
        out.write(128);
    }

    public void setHeaderTableSize(OutputStream out, int maxHeaderTableSize) throws IOException {
        if (maxHeaderTableSize < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + maxHeaderTableSize);
        }
        int neededSize = this.size - maxHeaderTableSize;
        if (neededSize > 0) {
            this.ensureCapacity(out, neededSize);
        }
        this.capacity = maxHeaderTableSize;
        out.write(128);
        Encoder.encodeInteger(out, 0, 7, maxHeaderTableSize);
    }

    private static void encodeInteger(OutputStream out, int mask, int n, int i) throws IOException {
        if (n < 0 || n > 8) {
            throw new IllegalArgumentException("N: " + n);
        }
        int nbits = 255 >>> 8 - n;
        if (i >= nbits) {
            out.write(mask | nbits);
            int length = i - nbits;
            while (true) {
                if ((length & 0xFFFFFF80) == 0) {
                    out.write(length);
                    return;
                }
                out.write(length & 0x7F | 0x80);
                length >>>= 7;
            }
        }
        out.write(mask | i);
    }

    private void encodeLiteral(OutputStream out, byte[] name, byte[] value, boolean indexing, int nameIndex) throws IOException {
        Encoder.encodeInteger(out, indexing ? 0 : 64, 6, nameIndex == -1 ? 0 : nameIndex);
        if (nameIndex == -1) {
            this.encodeStringLiteral(out, name);
        }
        this.encodeStringLiteral(out, value);
    }

    private void encodeStringLiteral(OutputStream out, byte[] string) throws IOException {
        int huffmanLength = Huffman.ENCODER.getEncodedLength(string);
        if (huffmanLength < string.length && !this.forceHuffmanOff || this.forceHuffmanOn) {
            Encoder.encodeInteger(out, 128, 7, huffmanLength);
            Huffman.ENCODER.encode(out, string);
        } else {
            Encoder.encodeInteger(out, 0, 7, string.length);
            out.write(string, 0, string.length);
        }
    }

    private int getNameIndex(byte[] name) {
        int index = this.getIndex(name);
        if (index == -1 && (index = StaticTable.getIndex(name)) >= 0) {
            index += this.length();
        }
        return index;
    }

    private void ensureCapacity(OutputStream out, int headerSize) throws IOException {
        int index;
        while (this.size + headerSize > this.capacity && (index = this.length()) != 0) {
            HeaderField removed = this.remove();
            if (!removed.inReferenceSet || !removed.emitted) continue;
            Encoder.encodeInteger(out, 128, 7, index);
            Encoder.encodeInteger(out, 128, 7, index);
        }
    }

    private int length() {
        return this.size == 0 ? 0 : this.head.after.index - this.head.before.index + 1;
    }

    private HeaderEntry getEntry(byte[] name, byte[] value) {
        if (this.length() == 0 || name == null || value == null) {
            return null;
        }
        int h = Encoder.hash(name);
        int i = Encoder.index(h);
        HeaderEntry e = this.headerTable[i];
        while (e != null) {
            if (e.hash == h && HpackUtil.equals(name, e.name) && HpackUtil.equals(value, e.value)) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    private int getIndex(byte[] name) {
        if (this.length() == 0 || name == null) {
            return -1;
        }
        int h = Encoder.hash(name);
        int i = Encoder.index(h);
        int index = -1;
        HeaderEntry e = this.headerTable[i];
        while (e != null) {
            if (e.hash == h && HpackUtil.equals(name, e.name)) {
                index = e.index;
                break;
            }
            e = e.next;
        }
        return this.getIndex(index);
    }

    private int getIndex(int index) {
        if (index == -1) {
            return index;
        }
        return index - this.head.before.index + 1;
    }

    private void add(byte[] name, byte[] value) {
        HeaderEntry e;
        int headerSize = HeaderField.sizeOf(name, value);
        if (headerSize > this.capacity) {
            this.clear();
            return;
        }
        while (this.size + headerSize > this.capacity) {
            this.remove();
        }
        name = Arrays.copyOf(name, name.length);
        value = Arrays.copyOf(value, value.length);
        int h = Encoder.hash(name);
        int i = Encoder.index(h);
        HeaderEntry old = this.headerTable[i];
        this.headerTable[i] = e = new HeaderEntry(h, name, value, this.head.before.index - 1, old);
        e.addBefore(this.head);
        this.size += headerSize;
    }

    private HeaderField remove() {
        HeaderEntry prev;
        if (this.size == 0) {
            return null;
        }
        HeaderEntry eldest = this.head.after;
        int h = eldest.hash;
        int i = Encoder.index(h);
        HeaderEntry e = prev = this.headerTable[i];
        while (e != null) {
            HeaderEntry next = e.next;
            if (e == eldest) {
                if (prev == eldest) {
                    this.headerTable[i] = next;
                } else {
                    prev.next = next;
                }
                eldest.remove();
                this.size -= eldest.size();
                return eldest;
            }
            prev = e;
            e = next;
        }
        return null;
    }

    private void clear() {
        Arrays.fill(this.headerTable, null);
        this.head.before = this.head.after = this.head;
        this.size = 0;
    }

    private static int hash(byte[] name) {
        int h = 0;
        for (int i = 0; i < name.length; ++i) {
            h = 31 * h + name[i];
        }
        if (h > 0) {
            return h;
        }
        if (h == Integer.MIN_VALUE) {
            return Integer.MAX_VALUE;
        }
        return -h;
    }

    private static int index(int h) {
        return h % 17;
    }

    private static class HeaderEntry
    extends HeaderField {
        HeaderEntry before;
        HeaderEntry after;
        HeaderEntry next;
        int hash;
        int index;

        HeaderEntry(int hash, byte[] name, byte[] value, int index, HeaderEntry next) {
            super(name, value);
            this.index = index;
            this.hash = hash;
            this.next = next;
            this.emitted = true;
        }

        private void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
        }

        private void addBefore(HeaderEntry existingEntry) {
            this.after = existingEntry;
            this.before = existingEntry.before;
            this.before.after = this;
            this.after.before = this;
        }
    }
}

