/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.hbc.core.endpoint;

import com.google.common.base.Preconditions;
import com.twitter.hbc.core.endpoint.EnterpriseStreamingEndpoint;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ReplayEnterpriseStreamingEndpoint
extends EnterpriseStreamingEndpoint {
    private static final String DATE_FMT_STR = "yyyyMMddHHmm";
    private static final String BASE_PATH = "/accounts/%s/publishers/twitter/replay/%s/%s.json";
    private final Date fromDate;
    private final Date toDate;

    public ReplayEnterpriseStreamingEndpoint(String account, String product, String label, Date fromDate, Date toDate) {
        super(account, product, label);
        this.fromDate = (Date)Preconditions.checkNotNull((Object)fromDate);
        this.toDate = (Date)Preconditions.checkNotNull((Object)toDate);
    }

    @Override
    public String getURI() {
        String uri = String.format(BASE_PATH, this.account.trim(), this.product.trim(), this.label.trim());
        this.addQueryParameter("fromDate", this.formatDate(this.fromDate));
        this.addQueryParameter("toDate", this.formatDate(this.toDate));
        return uri + "?" + this.generateParamString(this.queryParameters);
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    private String formatDate(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FMT_STR);
        return dateFormat.format(date);
    }
}

