/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finatra.http.request;

import com.twitter.finagle.http.MediaType$;
import com.twitter.finagle.http.Request;
import com.twitter.finatra.http.exceptions.BadRequestException;
import com.twitter.finatra.http.exceptions.NotAcceptableException;
import com.twitter.finatra.http.fileupload.FinagleRequestFileUpload;
import com.twitter.finatra.http.fileupload.MultipartItem;
import com.twitter.finatra.http.request.ContentType;
import com.twitter.finatra.http.request.MediaRange;
import com.twitter.finatra.http.request.MediaRange$parseAndSort$;
import com.twitter.inject.conversions.string;
import com.twitter.inject.conversions.string$;
import java.io.Serializable;
import java.net.URI;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;

public final class RequestUtils$ {
    public static RequestUtils$ MODULE$;

    static {
        new RequestUtils$();
    }

    public String pathUrl(Request request) {
        String scheme = this.getScheme(request);
        String hostHeader = this.getHost(request);
        String pathWithTrailingSlash = request.path().endsWith("/") ? request.path() : new StringBuilder(1).append(request.path()).append("/").toString();
        return new StringBuilder(3).append(scheme).append("://").append(hostHeader).append(pathWithTrailingSlash).toString();
    }

    public String normalizedURIWithoutScheme(URI uri, Request request) {
        URI normalizedURI = uri.normalize();
        return new StringBuilder(1).append(this.getScheme(request)).append(":").append(new StringBuilder(2).append("//").append(this.getAuthority(request, normalizedURI)).toString()).append(this.getPath(request, normalizedURI.getPath())).append(this.getQuery(normalizedURI)).append(this.getFragment(normalizedURI)).toString();
    }

    private String getScheme(Request request) {
        String string2;
        Option option = request.headerMap().get("x-forwarded-proto");
        if (option instanceof Some) {
            String protocol;
            Some some = (Some)option;
            string2 = protocol = (String)some.value();
        } else {
            string2 = "http";
        }
        return string2;
    }

    private String getAuthority(Request request, URI uri) {
        String string2;
        Option option = string.RichString$.MODULE$.toOption$extension(string$.MODULE$.RichString(uri.getAuthority()));
        if (option instanceof Some) {
            String authority;
            Some some = (Some)option;
            string2 = authority = (String)some.value();
        } else {
            string2 = this.getHost(request);
        }
        return string2;
    }

    private String getHost(Request request) {
        String host;
        Option option = request.host();
        if (!(option instanceof Some)) {
            throw new BadRequestException("Host header not set");
        }
        Some some = (Some)option;
        String string2 = host = (String)some.value();
        return string2;
    }

    private String getPath(Request request, String requestPath) {
        String string2;
        Option option = string.RichString$.MODULE$.toOption$extension(string$.MODULE$.RichString(requestPath));
        if (option instanceof Some) {
            String string3;
            Some some = (Some)option;
            String path = (String)some.value();
            if (!path.startsWith("/")) {
                String pathWithTrailingSlash = request.path().endsWith("/") ? request.path() : new StringBuilder(1).append(request.path()).append("/").toString();
                string3 = new StringBuilder(0).append(pathWithTrailingSlash).append(path).toString();
            } else {
                string3 = path;
            }
            string2 = string3;
        } else {
            string2 = "";
        }
        return string2;
    }

    private String getQuery(URI uri) {
        String string2;
        Option option = string.RichString$.MODULE$.toOption$extension(string$.MODULE$.RichString(uri.getQuery()));
        if (option instanceof Some) {
            Some some = (Some)option;
            String query = (String)some.value();
            string2 = new StringBuilder(1).append("?").append(query).toString();
        } else {
            string2 = "";
        }
        return string2;
    }

    private String getFragment(URI uri) {
        String string2;
        Option option = string.RichString$.MODULE$.toOption$extension(string$.MODULE$.RichString(uri.getFragment()));
        if (option instanceof Some) {
            Some some = (Some)option;
            String fragment = (String)some.value();
            string2 = new StringBuilder(1).append("#").append(fragment).toString();
        } else {
            string2 = "";
        }
        return string2;
    }

    public Map<String, MultipartItem> multiParams(Request request) {
        return new FinagleRequestFileUpload().parseMultipartItems(request);
    }

    public <T> T respondTo(Request request, PartialFunction<ContentType, T> callback) {
        String acceptHeader = (String)request.headerMap().getOrElse((Object)"Accept", (Function0 & Serializable & scala.Serializable)() -> "*/*");
        Seq<MediaRange> mediaRanges = MediaRange$parseAndSort$.MODULE$.apply(acceptHeader);
        Seq contentTypes = (Seq)mediaRanges.map((Function1 & Serializable & scala.Serializable)mediaRange -> ContentType.fromString(mediaRange.contentType()), Seq$.MODULE$.canBuildFrom());
        return (T)contentTypes.collectFirst(callback).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotAcceptableException(MediaType$.MODULE$.PlainTextUtf8(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not Acceptable Media Type"}))));
        });
    }

    private RequestUtils$() {
        MODULE$ = this;
    }
}

