/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finatra.http.modules;

import com.google.inject.Provides;
import com.twitter.app.Flag;
import com.twitter.app.Flaggable$;
import com.twitter.finagle.Filter;
import com.twitter.finagle.Filter$;
import com.twitter.finagle.Http;
import com.twitter.finagle.Http$;
import com.twitter.finagle.Service;
import com.twitter.finagle.SimpleFilter;
import com.twitter.finagle.exp.DarkTrafficFilter;
import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Response;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.finatra.annotations.CanonicalResourceFilter;
import com.twitter.finatra.annotations.DarkTrafficFilterType;
import com.twitter.finatra.annotations.DarkTrafficService;
import com.twitter.finatra.http.contexts.RouteInfo$;
import com.twitter.finatra.http.modules.DarkTrafficFilterModule$;
import com.twitter.inject.Injector;
import com.twitter.inject.TwitterModule;
import com.twitter.util.Future;
import java.io.Serializable;
import javax.inject.Singleton;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015uAB\n\u0015\u0011\u0003AbD\u0002\u0004!)!\u0005\u0001$\t\u0005\u0006Q\u0005!\tA\u000b\u0005\bW\u0005\u0011\r\u0011\"\u0001-\u0011\u0019)\u0014\u0001)A\u0005[\u0019)\u0001\u0005FA\u0001m!)\u0001&\u0002C\u0001{!9q(\u0002b\u0001\n\u0013\u0001\u0005BB)\u0006A\u0003%\u0011\tC\u0004S\u000b\t\u0007I\u0011C*\t\rQ+\u0001\u0015!\u0003H\u0011\u001d)VA1A\u0005\u0002YCaAW\u0003!\u0002\u00139\u0006\"B.\u0006\r\u0003a\u0006\"\u00027\u0006\t#i\u0007\"B=\u0006\t\u000bQ\bbBA4\u000b\u0011\u0015\u0011\u0011\u000e\u0005\b\u0003k*AQAA<\u0011!\ty(\u0002Q\u0005\n\u0005\u0005\u0015a\u0006#be.$&/\u00194gS\u000e4\u0015\u000e\u001c;fe6{G-\u001e7f\u0015\t)b#A\u0004n_\u0012,H.Z:\u000b\u0005]A\u0012\u0001\u00025uiBT!!\u0007\u000e\u0002\u000f\u0019Lg.\u0019;sC*\u00111\u0004H\u0001\bi^LG\u000f^3s\u0015\u0005i\u0012aA2p[B\u0011q$A\u0007\u0002)\t9B)\u0019:l)J\fgMZ5d\r&dG/\u001a:N_\u0012,H.Z\n\u0003\u0003\t\u0002\"a\t\u0014\u000e\u0003\u0011R\u0011!J\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0011\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003y\t\u0011cQ1o_:L7-\u00197SKN|WO]2f+\u0005i\u0003C\u0001\u00184\u001b\u0005y#B\u0001\u00192\u0003\u0011a\u0017M\\4\u000b\u0003I\nAA[1wC&\u0011Ag\f\u0002\u0007'R\u0014\u0018N\\4\u0002%\r\u000bgn\u001c8jG\u0006d'+Z:pkJ\u001cW\rI\n\u0003\u000b]\u0002\"\u0001O\u001e\u000e\u0003eR!A\u000f\u000e\u0002\r%t'.Z2u\u0013\ta\u0014HA\u0007Uo&$H/\u001a:N_\u0012,H.\u001a\u000b\u0002}A\u0011q$B\u0001\tI\u0016\u001cHO\u00127bOV\t\u0011\tE\u0002C\u000b\u001ek\u0011a\u0011\u0006\u0003\tj\t1!\u00199q\u0013\t15I\u0001\u0003GY\u0006<\u0007C\u0001%P\u001d\tIU\n\u0005\u0002KI5\t1J\u0003\u0002MS\u00051AH]8pizJ!A\u0014\u0013\u0002\rA\u0013X\rZ3g\u0013\t!\u0004K\u0003\u0002OI\u0005IA-Z:u\r2\fw\rI\u0001\u0006Y\u0006\u0014W\r\\\u000b\u0002\u000f\u00061A.\u00192fY\u0002\n1CZ8so\u0006\u0014H-\u00114uKJ\u001cVM\u001d<jG\u0016,\u0012a\u0016\t\u0003GaK!!\u0017\u0013\u0003\u000f\t{w\u000e\\3b]\u0006!bm\u001c:xCJ$\u0017I\u001a;feN+'O^5dK\u0002\na\"\u001a8bE2,7+Y7qY&tw\r\u0006\u0002^OB!1E\u00181X\u0013\tyFEA\u0005Gk:\u001cG/[8ocA\u0011\u0011-Z\u0007\u0002E*\u0011qc\u0019\u0006\u0003Ij\tqAZ5oC\u001edW-\u0003\u0002gE\n9!+Z9vKN$\b\"\u00025\u000e\u0001\u0004I\u0017\u0001C5oU\u0016\u001cGo\u001c:\u0011\u0005aR\u0017BA6:\u0005!IeN[3di>\u0014\u0018aE2p]\u001aLw-\u001e:f\u0011R$\bo\u00117jK:$Hc\u00018woB\u0011qn\u001d\b\u0003aFl\u0011aY\u0005\u0003e\u000e\fA\u0001\u0013;ua&\u0011A/\u001e\u0002\u0007\u00072LWM\u001c;\u000b\u0005I\u001c\u0007\"\u00025\u000f\u0001\u0004I\u0007\"\u0002=\u000f\u0001\u0004q\u0017AB2mS\u0016tG/\u0001\rqe>4\u0018\u000eZ3ECJ\\GK]1gM&\u001cg)\u001b7uKJ$\u0012b_A\u0002\u0003\u000b\t)\"a\n\u0011\rAd\bM 1\u007f\u0013\ti8M\u0001\u0004GS2$XM\u001d\t\u0003C~L1!!\u0001c\u0005!\u0011Vm\u001d9p]N,\u0007\"\u00025\u0010\u0001\u0004I\u0007bBA\u0004\u001f\u0001\u0007\u0011\u0011B\u0001\u000egR\fGo\u001d*fG\u0016Lg/\u001a:\u0011\t\u0005-\u0011\u0011C\u0007\u0003\u0003\u001bQ1!a\u0004d\u0003\u0015\u0019H/\u0019;t\u0013\u0011\t\u0019\"!\u0004\u0003\u001bM#\u0018\r^:SK\u000e,\u0017N^3s\u0011\u0019\t9b\u0004a\u0001w\u000692-\u00198p]&\u001c\u0017\r\u001c*fg>,(oY3GS2$XM\u001d\u0015\u0005\u0003+\tY\u0002\u0005\u0003\u0002\u001e\u0005\rRBAA\u0010\u0015\r\t\t\u0003G\u0001\fC:tw\u000e^1uS>t7/\u0003\u0003\u0002&\u0005}!aF\"b]>t\u0017nY1m%\u0016\u001cx.\u001e:dK\u001aKG\u000e^3s\u0011\u001d\tIc\u0004a\u0001\u0003W\tqa]3sm&\u001cW\rE\u0003$\u0003[\t\t$C\u0002\u00020\u0011\u0012aa\u00149uS>t\u0007#\u00029\u00024\u0001t\u0018bAA\u001bG\n91+\u001a:wS\u000e,\u0007\u0006BA\u0014\u0003s\u0001B!!\b\u0002<%!\u0011QHA\u0010\u0005I!\u0015M]6Ue\u00064g-[2TKJ4\u0018nY3)\u0007=\t\t\u0005\u0005\u0003\u0002\u001e\u0005\r\u0013\u0002BA#\u0003?\u0011Q\u0003R1sWR\u0013\u0018M\u001a4jG\u001aKG\u000e^3s)f\u0004X\rK\u0002\u0010\u0003\u0013\u0002B!a\u0013\u0002T5\u0011\u0011Q\n\u0006\u0004u\u0005=#BAA)\u0003\u0015Q\u0017M^1y\u0013\u0011\t)&!\u0014\u0003\u0013MKgn\u001a7fi>t\u0007fA\b\u0002ZA!\u00111LA2\u001b\t\tiFC\u0002;\u0003?R1!!\u0019\u001d\u0003\u00199wn\\4mK&!\u0011QMA/\u0005!\u0001&o\u001c<jI\u0016\u001c\u0018!\u00079s_ZLG-\u001a#be.$&/\u00194gS\u000e\u001cVM\u001d<jG\u0016$b!a\u000b\u0002l\u00055\u0004\"\u00025\u0011\u0001\u0004I\u0007bBA\u0004!\u0001\u0007\u0011\u0011\u0002\u0015\u0004!\u0005e\u0002f\u0001\t\u0002J!\u001a\u0001#!\u0017\u0002=A\u0014xN^5eK\u000e\u000bgn\u001c8jG\u0006d'+Z:pkJ\u001cWMR5mi\u0016\u0014X#A>)\u0007E\tY\u0002K\u0002\u0012\u0003\u0013B3!EA-\u0003E!WMZ1vYRDE\u000f\u001e9DY&,g\u000e\u001e\u000b\u0004]\u0006\r\u0005bBA\u0004%\u0001\u0007\u0011\u0011\u0002")
public abstract class DarkTrafficFilterModule
extends TwitterModule {
    private final Flag<String> destFlag = this.flag("http.dark.service.dest", "Resolvable name/dest of dark traffic service", Flaggable$.MODULE$.ofString(), ManifestFactory$.MODULE$.classType(String.class));
    private final String label;
    private final boolean forwardAfterService;

    public static String CanonicalResource() {
        return DarkTrafficFilterModule$.MODULE$.CanonicalResource();
    }

    private Flag<String> destFlag() {
        return this.destFlag;
    }

    public String label() {
        return this.label;
    }

    public boolean forwardAfterService() {
        return this.forwardAfterService;
    }

    public abstract Function1<Request, Object> enableSampling(Injector var1);

    public Http.Client configureHttpClient(Injector injector, Http.Client client) {
        return client;
    }

    @Provides
    @Singleton
    @DarkTrafficFilterType
    public final Filter<Request, Response, Request, Response> provideDarkTrafficFilter(Injector injector, StatsReceiver statsReceiver, @CanonicalResourceFilter Filter<Request, Response, Request, Response> canonicalResourceFilter, @DarkTrafficService Option<Service<Request, Response>> service) {
        SimpleFilter simpleFilter;
        Option<Service<Request, Response>> option = service;
        if (option instanceof Some) {
            Some some = (Some)option;
            Service svc = (Service)some.value();
            Service filteredDarkService = canonicalResourceFilter.andThen(svc);
            simpleFilter = new DarkTrafficFilter(filteredDarkService, this.enableSampling(injector), statsReceiver, this.forwardAfterService());
        } else {
            simpleFilter = Filter$.MODULE$.identity();
        }
        return simpleFilter;
    }

    @Provides
    @Singleton
    @DarkTrafficService
    public final Option<Service<Request, Response>> provideDarkTrafficService(Injector injector, StatsReceiver statsReceiver) {
        return this.destFlag().get().map((Function1 & Serializable & scala.Serializable)dest -> {
            StatsReceiver clientStatsReceiver = statsReceiver.scope((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"clnt", "dark_traffic_filter"}));
            return this.configureHttpClient(injector, this.defaultHttpClient(clientStatsReceiver)).newService(dest, this.label());
        });
    }

    @Provides
    @Singleton
    @CanonicalResourceFilter
    public final Filter<Request, Response, Request, Response> provideCanonicalResourceFilter() {
        return Filter$.MODULE$.mk((Function2 & Serializable & scala.Serializable)(request, service) -> {
            RouteInfo$.MODULE$.apply((Request)request).foreach((Function1 & Serializable & scala.Serializable)info -> {
                String nameOrPath = new StringOps(Predef$.MODULE$.augmentString(info.name())).nonEmpty() ? info.name() : info.path();
                return request.headerMap().set(DarkTrafficFilterModule$.MODULE$.CanonicalResource(), new StringBuilder(1).append(request.method().toString()).append("_").append(nameOrPath).toString());
            });
            return (Future)service.apply(request);
        });
    }

    private Http.Client defaultHttpClient(StatsReceiver statsReceiver) {
        return Http$.MODULE$.client().withStatsReceiver(statsReceiver);
    }

    public DarkTrafficFilterModule() {
        this.label = "service";
        this.forwardAfterService = true;
    }
}

