/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finatra.http.jsonpatch;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.twitter.finatra.http.jsonpatch.JsonPatchException;
import com.twitter.finatra.http.jsonpatch.PatchOperation;
import com.twitter.finatra.json.FinatraObjectMapper;
import javax.inject.Inject;
import javax.inject.Singleton;
import scala.Option;
import scala.Some;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Singleton
@ScalaSignature(bytes="\u0006\u0001\u0005uf\u0001B\f\u0019\u0001\rB\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\u0006c\u0001!\tA\r\u0005\u0006\u007f\u0001!\t\u0001\u0011\u0005\u0006\u007f\u0001!\t!\u0017\u0005\u0006M\u0002!\ta\u001a\u0005\u0006e\u0002!\ta\u001d\u0005\u0006m\u0002!\ta\u001e\u0005\u0006u\u0002!\ta\u001f\u0005\u0006}\u0002!\ta \u0005\b\u0003\u000b\u0001A\u0011AA\u0004\u0011%\ti\u0001\u0001b\u0001\n\u0013\ty\u0001\u0003\u0005\u0002\u001e\u0001\u0001\u000b\u0011BA\t\u0011\u001d\ty\u0002\u0001C\u0005\u0003CAq!!\r\u0001\t\u0013\t\u0019\u0004C\u0004\u0002P\u0001!I!!\u0015\t\u000f\u0005e\u0003\u0001\"\u0003\u0002\\!9\u0011\u0011\u000f\u0001\u0005\n\u0005M\u0004bBA@\u0001\u0011%\u0011\u0011\u0011\u0005\b\u0003\u0013\u0003A\u0011BAF\u0011\u001d\t)\n\u0001C\u0005\u0003/Cq!!)\u0001\t\u0013\t\u0019\u000bC\u0004\u0002,\u0002!I!!,\u0003#)\u001bxN\u001c)bi\u000eDw\n]3sCR|'O\u0003\u0002\u001a5\u0005I!n]8oa\u0006$8\r\u001b\u0006\u00037q\tA\u0001\u001b;ua*\u0011QDH\u0001\bM&t\u0017\r\u001e:b\u0015\ty\u0002%A\u0004uo&$H/\u001a:\u000b\u0003\u0005\n1aY8n\u0007\u0001\u0019\"\u0001\u0001\u0013\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0003\u001d\nQa]2bY\u0006L!!\u000b\u0014\u0003\r\u0005s\u0017PU3g\u0003\u0019i\u0017\r\u001d9feB\u0011AfL\u0007\u0002[)\u0011a\u0006H\u0001\u0005UN|g.\u0003\u00021[\t\u0019b)\u001b8biJ\fwJ\u00196fGRl\u0015\r\u001d9fe\u00061A(\u001b8jiz\"\"aM\u001b\u0011\u0005Q\u0002Q\"\u0001\r\t\u000b)\u0012\u0001\u0019A\u0016)\u0005\t9\u0004C\u0001\u001d>\u001b\u0005I$B\u0001\u001e<\u0003\u0019IgN[3di*\tA(A\u0003kCZ\f\u00070\u0003\u0002?s\t1\u0011J\u001c6fGR\f!\u0002^8Kg>tgj\u001c3f+\t\t\u0005\u000b\u0006\u0002C\u0019B\u00111IS\u0007\u0002\t*\u0011QIR\u0001\tI\u0006$\u0018MY5oI*\u0011q\tS\u0001\bU\u0006\u001c7n]8o\u0015\tI\u0005%A\u0005gCN$XM\u001d=nY&\u00111\n\u0012\u0002\t\u0015N|gNT8eK\")Qj\u0001a\u0001\u001d\u0006AqN]5hS:\fG\u000e\u0005\u0002P!2\u0001A!B)\u0004\u0005\u0004\u0011&!\u0001+\u0012\u0005M3\u0006CA\u0013U\u0013\t)fEA\u0004O_RD\u0017N\\4\u0011\u0005\u0015:\u0016B\u0001-'\u0005\r\te.\u001f\u000b\u0003\u0005jCQ!\u0014\u0003A\u0002m\u0003\"\u0001X2\u000f\u0005u\u000b\u0007C\u00010'\u001b\u0005y&B\u00011#\u0003\u0019a$o\\8u}%\u0011!MJ\u0001\u0007!J,G-\u001a4\n\u0005\u0011,'AB*ue&twM\u0003\u0002cM\u0005\u0019\u0011\r\u001a3\u0015\u0007!\\\u0007\u000f\u0005\u0002&S&\u0011!N\n\u0002\u0005+:LG\u000fC\u0003m\u000b\u0001\u0007Q.A\u0003qCR\u001c\u0007\u000e\u0005\u00025]&\u0011q\u000e\u0007\u0002\u000f!\u0006$8\r[(qKJ\fG/[8o\u0011\u0015\tX\u00011\u0001C\u0003\u0019!\u0018M]4fi\u00061!/Z7pm\u0016$2\u0001\u001b;v\u0011\u0015ag\u00011\u0001n\u0011\u0015\th\u00011\u0001C\u0003\u001d\u0011X\r\u001d7bG\u0016$2\u0001\u001b=z\u0011\u0015aw\u00011\u0001n\u0011\u0015\tx\u00011\u0001C\u0003\u0011iwN^3\u0015\u0007!dX\u0010C\u0003m\u0011\u0001\u0007Q\u000eC\u0003r\u0011\u0001\u0007!)\u0001\u0003d_BLH#\u00025\u0002\u0002\u0005\r\u0001\"\u00027\n\u0001\u0004i\u0007\"B9\n\u0001\u0004\u0011\u0015\u0001\u0002;fgR$R\u0001[A\u0005\u0003\u0017AQ\u0001\u001c\u0006A\u00025DQ!\u001d\u0006A\u0002\t\u000b!\u0003\\1ti\u0016cW-\\3oiB{\u0017N\u001c;feV\u0011\u0011\u0011\u0003\t\u0005\u0003'\tI\"\u0004\u0002\u0002\u0016)\u0019\u0011q\u0003$\u0002\t\r|'/Z\u0005\u0005\u00037\t)BA\u0006Kg>t\u0007k\\5oi\u0016\u0014\u0018a\u00057bgR,E.Z7f]R\u0004v.\u001b8uKJ\u0004\u0013AC2iK\u000e\\'i\\;oIR)\u0001.a\t\u0002(!1\u0011QE\u0007A\u0002m\u000b\u0011b\u001c9fe\u0006$\u0018n\u001c8\t\u000f\u0005%R\u00021\u0001\u0002,\u0005I1m\u001c8eSRLwN\u001c\t\u0004K\u00055\u0012bAA\u0018M\t9!i\\8mK\u0006t\u0017\u0001D4fi2+\u0017MZ%oI\u0016DH\u0003CA\u001b\u0003w\ty$!\u0014\u0011\u0007\u0015\n9$C\u0002\u0002:\u0019\u00121!\u00138u\u0011\u001d\tiD\u0004a\u0001\u0003#\tA\u0001]1uQ\"1\u0011O\u0004a\u0001\u0003\u0003\u0002B!a\u0011\u0002J5\u0011\u0011Q\t\u0006\u0004\u0003\u000f\"\u0015\u0001\u00028pI\u0016LA!a\u0013\u0002F\tI\u0011I\u001d:bs:{G-\u001a\u0005\u0007\u0003Kq\u0001\u0019A.\u0002\u001d9,\u0007\u0010\u001e(pI\u0016\u0014\u0015\u0010U1uQR9!)a\u0015\u0002V\u0005]\u0003bBA\u001f\u001f\u0001\u0007\u0011\u0011\u0003\u0005\u0006c>\u0001\rA\u0011\u0005\u0007\u0003Ky\u0001\u0019A.\u0002\u0017M\fg-Z$fi:{G-\u001a\u000b\b\u0005\u0006u\u0013qLA1\u0011\u001d\ti\u0004\u0005a\u0001\u0003#AQ!\u001d\tA\u0002\tCa!!\n\u0011\u0001\u0004Y\u0006f\u0001\t\u0002fA!\u0011qMA7\u001b\t\tIGC\u0002\u0002l\u0019\n!\"\u00198o_R\fG/[8o\u0013\u0011\ty'!\u001b\u0003\u000fQ\f\u0017\u000e\u001c:fG\u00069\u0011\r\u001a3O_\u0012,Gc\u00025\u0002v\u0005]\u00141\u0010\u0005\b\u0003{\t\u0002\u0019AA\t\u0011\u0019\tI(\u0005a\u0001\u0005\u0006)a/\u00197vK\")\u0011/\u0005a\u0001\u0005\"\u001a\u0011#!\u001a\u0002\u0015I,Wn\u001c<f\u001d>$W\rF\u0003i\u0003\u0007\u000b)\tC\u0004\u0002>I\u0001\r!!\u0005\t\u000bE\u0014\u0002\u0019\u0001\")\u0007I\t)'A\u0006sKBd\u0017mY3O_\u0012,Gc\u00025\u0002\u000e\u0006=\u0015\u0011\u0013\u0005\b\u0003{\u0019\u0002\u0019AA\t\u0011\u0019\tIh\u0005a\u0001\u0005\")\u0011o\u0005a\u0001\u0005\"\u001a1#!\u001a\u0002\u00115|g/\u001a(pI\u0016$r\u0001[AM\u00037\u000bi\nC\u0004\u0002>Q\u0001\r!!\u0005\t\u000bE$\u0002\u0019\u0001\"\t\u000f\u0005}E\u00031\u0001\u0002\u0012\u0005!aM]8n\u0003!\u0019w\u000e]=O_\u0012,Gc\u00025\u0002&\u0006\u001d\u0016\u0011\u0016\u0005\b\u0003{)\u0002\u0019AA\t\u0011\u0015\tX\u00031\u0001C\u0011\u001d\ty*\u0006a\u0001\u0003#\t\u0001\u0002^3ti:{G-\u001a\u000b\bQ\u0006=\u0016\u0011WAZ\u0011\u001d\tiD\u0006a\u0001\u0003#AQ!\u001d\fA\u0002\tCa!!\u001f\u0017\u0001\u0004\u0011\u0005f\u0001\u0001\u00028B\u0019\u0001(!/\n\u0007\u0005m\u0016HA\u0005TS:<G.\u001a;p]\u0002")
public class JsonPatchOperator {
    private final FinatraObjectMapper mapper;
    private final JsonPointer lastElementPointer;

    public <T> JsonNode toJsonNode(T original) {
        String str = this.mapper.writeValueAsString(original);
        return (JsonNode)this.mapper.parse(str, ManifestFactory$.MODULE$.classType(JsonNode.class));
    }

    public JsonNode toJsonNode(String original) {
        return (JsonNode)this.mapper.parse(original, ManifestFactory$.MODULE$.classType(JsonNode.class));
    }

    public void add(PatchOperation patch, JsonNode target) {
        Option<JsonNode> option = patch.value();
        if (!(option instanceof Some)) {
            throw new JsonPatchException("invalid value for add operation");
        }
        Some some = (Some)option;
        JsonNode v = (JsonNode)some.value();
        this.addNode(patch.path(), v, target);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void remove(PatchOperation patch, JsonNode target) {
        this.removeNode(patch.path(), target);
    }

    public void replace(PatchOperation patch, JsonNode target) {
        Option<JsonNode> option = patch.value();
        if (!(option instanceof Some)) {
            throw new JsonPatchException("invalid value for replace operation");
        }
        Some some = (Some)option;
        JsonNode v = (JsonNode)some.value();
        this.replaceNode(patch.path(), v, target);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void move(PatchOperation patch, JsonNode target) {
        BoxedUnit boxedUnit;
        Option<JsonPointer> option = patch.from();
        if (option instanceof Some) {
            Some some = (Some)option;
            JsonPointer f = (JsonPointer)some.value();
            JsonPointer jsonPointer = patch.path();
            JsonPointer jsonPointer2 = f;
            if (jsonPointer == null ? jsonPointer2 != null : !jsonPointer.equals(jsonPointer2)) {
                this.moveNode(patch.path(), target, f);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new JsonPatchException("invalid from for move operation");
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public void copy(PatchOperation patch, JsonNode target) {
        Option<JsonPointer> option = patch.from();
        if (!(option instanceof Some)) {
            throw new JsonPatchException("invalid from for copy operation");
        }
        Some some = (Some)option;
        JsonPointer f = (JsonPointer)some.value();
        this.copyNode(patch.path(), target, f);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void test(PatchOperation patch, JsonNode target) {
        Option<JsonNode> option = patch.value();
        if (!(option instanceof Some)) {
            throw new JsonPatchException("invalid value for test operation");
        }
        Some some = (Some)option;
        JsonNode v = (JsonNode)some.value();
        this.testNode(patch.path(), target, v);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private JsonPointer lastElementPointer() {
        return this.lastElementPointer;
    }

    private void checkBound(String operation, boolean condition) {
        if (!((Object)BoxesRunTime.boxToBoolean((boolean)condition)).equals(BoxesRunTime.boxToBoolean((boolean)true))) {
            throw new JsonPatchException(new StringBuilder(54).append("invalid path for ").append(operation).append(" operation, array index out of bounds").toString());
        }
    }

    private int getLeafIndex(JsonPointer path, ArrayNode target, String operation) {
        JsonPointer jsonPointer = path;
        JsonPointer jsonPointer2 = this.lastElementPointer();
        int index = !(jsonPointer != null ? !jsonPointer.equals(jsonPointer2) : jsonPointer2 != null) ? target.size() - 1 : path.getMatchingIndex();
        this.checkBound(operation, index < target.size() && index >= 0);
        return index;
    }

    private JsonNode nextNodeByPath(JsonPointer path, JsonNode target, String operation) {
        JsonNode jsonNode;
        JsonNode jsonNode2 = target;
        if (jsonNode2 instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)jsonNode2;
            if (!path.mayMatchElement()) {
                throw new JsonPatchException(new StringBuilder(49).append("invalid path for ").append(operation).append(" operation, expected array index").toString());
            }
            int index = path.getMatchingIndex();
            this.checkBound(operation, index < arrayNode.size() && index >= 0);
            jsonNode = arrayNode.get(index);
        } else {
            if (jsonNode2 == null) {
                throw new JsonPatchException(new StringBuilder(29).append("invalid target for ").append(operation).append(" operation").toString());
            }
            jsonNode = target.get(path.getMatchingProperty());
        }
        return jsonNode;
    }

    private JsonNode safeGetNode(JsonPointer path, JsonNode target, String operation) {
        JsonNode jsonNode;
        while (true) {
            if (path.tail() == null) {
                throw new JsonPatchException(new StringBuilder(27).append("invalid path for ").append(operation).append(" operation").toString());
            }
            if (path.tail().matches()) {
                JsonNode jsonNode2 = target;
                if (jsonNode2 instanceof ObjectNode) {
                    ObjectNode objectNode = (ObjectNode)jsonNode2;
                    jsonNode = objectNode.get(path.getMatchingProperty());
                    break;
                }
                if (jsonNode2 instanceof ArrayNode) {
                    ArrayNode arrayNode = (ArrayNode)jsonNode2;
                    jsonNode = arrayNode.get(this.getLeafIndex(path, arrayNode, operation));
                    break;
                }
                throw new JsonPatchException(new StringBuilder(29).append("invalid target for ").append(operation).append(" operation").toString());
            }
            JsonNode jsonNode3 = this.nextNodeByPath(path, target, operation);
            target = jsonNode3;
            path = path.tail();
        }
        return jsonNode;
    }

    private void addNode(JsonPointer path, JsonNode value, JsonNode target) {
        while (true) {
            if (path.tail() == null) {
                throw new JsonPatchException("invalid path for add operation");
            }
            if (path.tail().matches()) {
                JsonNode jsonNode = target;
                if (jsonNode instanceof ObjectNode) {
                    ObjectNode objectNode = (ObjectNode)jsonNode;
                    objectNode.set(path.getMatchingProperty(), value);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break;
                }
                if (jsonNode instanceof ArrayNode) {
                    ArrayNode arrayNode = (ArrayNode)jsonNode;
                    JsonPointer jsonPointer = path;
                    JsonPointer jsonPointer2 = this.lastElementPointer();
                    int index = !(jsonPointer != null ? !jsonPointer.equals(jsonPointer2) : jsonPointer2 != null) ? arrayNode.size() : path.getMatchingIndex();
                    this.checkBound("add", index <= arrayNode.size() && index >= 0);
                    arrayNode.insert(index, value);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break;
                }
                throw new JsonPatchException("invalid target for add");
            }
            target = this.nextNodeByPath(path, target, "add");
            path = path.tail();
        }
    }

    private void removeNode(JsonPointer path, JsonNode target) {
        while (true) {
            if (path.tail() == null) {
                throw new JsonPatchException("invalid path for remove operation");
            }
            if (path.tail().matches()) {
                JsonNode jsonNode = target;
                if (jsonNode instanceof ObjectNode) {
                    ObjectNode objectNode = (ObjectNode)jsonNode;
                    objectNode.remove(path.getMatchingProperty());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break;
                }
                if (jsonNode instanceof ArrayNode) {
                    ArrayNode arrayNode = (ArrayNode)jsonNode;
                    arrayNode.remove(this.getLeafIndex(path, arrayNode, "remove"));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break;
                }
                throw new JsonPatchException("invalid target for remove");
            }
            target = this.nextNodeByPath(path, target, "remove");
            path = path.tail();
        }
    }

    private void replaceNode(JsonPointer path, JsonNode value, JsonNode target) {
        while (true) {
            if (path.tail() == null) {
                throw new JsonPatchException("invalid path for replace operation");
            }
            if (path.tail().matches()) {
                JsonNode jsonNode = target;
                if (jsonNode instanceof ObjectNode) {
                    ObjectNode objectNode = (ObjectNode)jsonNode;
                    objectNode.set(path.getMatchingProperty(), value);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break;
                }
                if (jsonNode instanceof ArrayNode) {
                    ArrayNode arrayNode = (ArrayNode)jsonNode;
                    arrayNode.set(this.getLeafIndex(path, arrayNode, "replace"), value);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break;
                }
                throw new JsonPatchException("invalid target for replace");
            }
            target = this.nextNodeByPath(path, target, "replace");
            path = path.tail();
        }
    }

    private void moveNode(JsonPointer path, JsonNode target, JsonPointer from) {
        JsonNode nodeToMove = this.safeGetNode(from, target, "move");
        this.removeNode(from, target);
        this.addNode(path, nodeToMove, target);
    }

    private void copyNode(JsonPointer path, JsonNode target, JsonPointer from) {
        this.addNode(path, this.safeGetNode(from, target, "copy"), target);
    }

    private void testNode(JsonPointer path, JsonNode target, JsonNode value) {
        JsonNode jsonNode = this.safeGetNode(path, target, "test");
        JsonNode jsonNode2 = value;
        if (jsonNode == null ? jsonNode2 != null : !jsonNode.equals(jsonNode2)) {
            throw new JsonPatchException("test operation failed");
        }
    }

    @Inject
    public JsonPatchOperator(FinatraObjectMapper mapper2) {
        this.mapper = mapper2;
        this.lastElementPointer = JsonPointer.compile((String)"/-");
    }
}

