/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finatra.http.internal.marshalling;

import com.twitter.finagle.http.MediaType$;
import com.twitter.finagle.http.Message;
import com.twitter.finatra.http.marshalling.DefaultMessageBodyWriter;
import com.twitter.finatra.http.marshalling.MessageBodyWriter;
import com.twitter.finatra.http.marshalling.WriterResponse;
import com.twitter.finatra.http.marshalling.WriterResponse$;
import com.twitter.finatra.http.marshalling.WriterResponse$EmptyResponse$;
import com.twitter.finatra.json.FinatraObjectMapper;
import com.twitter.finatra.utils.AutoClosable$;
import com.twitter.finatra.utils.FileResolver;
import com.twitter.inject.annotations.Flag;
import com.twitter.io.Buf;
import com.twitter.io.StreamIO$;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import javax.inject.Inject;
import javax.inject.Singleton;
import scala.Function1;
import scala.None$;
import scala.Unit$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Singleton
@ScalaSignature(bytes="\u0006\u0001\u0005ea!B\u0006\r\u0001IA\u0002\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0014\t\u0011U\u0002!\u0011!Q\u0001\nYB\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\u0006\u0007\u0002!\t\u0001\u0012\u0005\u0007'\u0002\u0001\u000b\u0011\u0002+\t\rq\u0003\u0001\u0015!\u0003U\u0011\u0019i\u0006\u0001)A\u0005)\")a\f\u0001C!?\"1\u0001\u000e\u0001Q\u0005\n%Dq!!\u0001\u0001\t\u0013\t\u0019A\u0001\u000fEK\u001a\fW\u000f\u001c;NKN\u001c\u0018mZ3C_\u0012LxK]5uKJLU\u000e\u001d7\u000b\u00055q\u0011aC7beND\u0017\r\u001c7j]\u001eT!a\u0004\t\u0002\u0011%tG/\u001a:oC2T!!\u0005\n\u0002\t!$H\u000f\u001d\u0006\u0003'Q\tqAZ5oCR\u0014\u0018M\u0003\u0002\u0016-\u00059Ao^5ui\u0016\u0014(\"A\f\u0002\u0007\r|WnE\u0002\u00013}\u0001\"AG\u000f\u000e\u0003mQ\u0011\u0001H\u0001\u0006g\u000e\fG.Y\u0005\u0003=m\u0011a!\u00118z%\u00164\u0007C\u0001\u0011#\u001b\u0005\t#BA\u0007\u0011\u0013\t\u0019\u0013E\u0001\rEK\u001a\fW\u000f\u001c;NKN\u001c\u0018mZ3C_\u0012LxK]5uKJ\f\u0011$\u001b8dYV$WmQ8oi\u0016tG\u000fV=qK\u000eC\u0017M]:fi\u000e\u0001\u0001C\u0001\u000e(\u0013\tA3DA\u0004C_>dW-\u00198)\t\u0005Q#g\r\t\u0003WAj\u0011\u0001\f\u0006\u0003[9\n1\"\u00198o_R\fG/[8og*\u0011q\u0006F\u0001\u0007S:TWm\u0019;\n\u0005Eb#\u0001\u0002$mC\u001e\fQA^1mk\u0016\f\u0013\u0001N\u0001\u001eQR$\bO\f:fgB|gn]3/G\"\f'o]3u]\u0015t\u0017M\u00197fI\u0006aa-\u001b7f%\u0016\u001cx\u000e\u001c<feB\u0011qGO\u0007\u0002q)\u0011\u0011HE\u0001\u0006kRLGn]\u0005\u0003wa\u0012ABR5mKJ+7o\u001c7wKJ\fa!\\1qa\u0016\u0014\bC\u0001 B\u001b\u0005y$B\u0001!\u0013\u0003\u0011Q7o\u001c8\n\u0005\t{$a\u0005$j]\u0006$(/Y(cU\u0016\u001cG/T1qa\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u0003F\u000f&S\u0005C\u0001$\u0001\u001b\u0005a\u0001\"\u0002\u0013\u0005\u0001\u00041\u0003\u0006B$+eMBQ!\u000e\u0003A\u0002YBQ\u0001\u0010\u0003A\u0002uB#\u0001\u0002'\u0011\u00055\u000bV\"\u0001(\u000b\u0005=z%\"\u0001)\u0002\u000b)\fg/\u0019=\n\u0005Is%AB%oU\u0016\u001cG/A\bbaBd\u0017nY1uS>t'j]8o!\t)&,D\u0001W\u0015\t9\u0006,\u0001\u0003mC:<'\"A-\u0002\t)\fg/Y\u0005\u00037Z\u0013aa\u0015;sS:<\u0017!\u00039mC&tG+\u001a=u\u0003-y7\r^3u'R\u0014X-Y7\u0002\u000b]\u0014\u0018\u000e^3\u0015\u0005\u0001\u001c\u0007C\u0001\u0011b\u0013\t\u0011\u0017E\u0001\bXe&$XM\u001d*fgB|gn]3\t\u000b\u0011D\u0001\u0019A3\u0002\u0007=\u0014'\u000e\u0005\u0002\u001bM&\u0011qm\u0007\u0002\u0004\u0003:L\u0018AE5t!JLW.\u001b;jm\u0016<&/\u00199qKJ$\"A\n6\t\u000b-L\u0001\u0019\u00017\u0002\u000b\rd\u0017M\u001f>1\u00055T\bc\u00018vq:\u0011qn\u001d\t\u0003ani\u0011!\u001d\u0006\u0003e\u0016\na\u0001\u0010:p_Rt\u0014B\u0001;\u001c\u0003\u0019\u0001&/\u001a3fM&\u0011ao\u001e\u0002\u0006\u00072\f7o\u001d\u0006\u0003in\u0001\"!\u001f>\r\u0001\u0011I1P[A\u0001\u0002\u0003\u0015\t\u0001 \u0002\u0004?\u0012\n\u0014CA?f!\tQb0\u0003\u0002\u00007\t9aj\u001c;iS:<\u0017\u0001F5t!JLW.\u001b;jm\u0016|%o\u0016:baB,'\u000fF\u0002'\u0003\u000bAaa\u001b\u0006A\u0002\u0005\u001d\u0001\u0007BA\u0005\u0003\u001b\u0001BA\\;\u0002\fA\u0019\u00110!\u0004\u0005\u0017\u0005=\u0011QAA\u0001\u0002\u0003\u0015\t\u0001 \u0002\u0004?\u0012\u0012\u0004f\u0001\u0001\u0002\u0014A\u0019Q*!\u0006\n\u0007\u0005]aJA\u0005TS:<G.\u001a;p]\u0002")
public class DefaultMessageBodyWriterImpl
implements DefaultMessageBodyWriter {
    private final FileResolver fileResolver;
    private final FinatraObjectMapper mapper;
    private final String applicationJson;
    private final String plainText;
    private final String octetStream;

    @Override
    public WriterResponse write(Message message, Object obj) {
        return MessageBodyWriter.write$(this, message, obj);
    }

    @Override
    public WriterResponse write(Object obj) {
        WriterResponse writerResponse;
        Object object = obj;
        if (object == null) {
            writerResponse = WriterResponse$EmptyResponse$.MODULE$;
        } else if (object instanceof Buf) {
            Buf buf = (Buf)object;
            writerResponse = WriterResponse$.MODULE$.apply(this.octetStream, (Object)buf, WriterResponse$.MODULE$.apply$default$3());
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            writerResponse = WriterResponse$.MODULE$.apply(this.octetStream, (Object)byArray, WriterResponse$.MODULE$.apply$default$3());
        } else if ("".equals(object)) {
            writerResponse = WriterResponse$EmptyResponse$.MODULE$;
        } else if (Unit$.MODULE$.equals(object)) {
            writerResponse = WriterResponse$EmptyResponse$.MODULE$;
        } else if (object instanceof BoxedUnit) {
            writerResponse = WriterResponse$EmptyResponse$.MODULE$;
        } else {
            Object object2 = object;
            None$ none$ = None$.MODULE$;
            if (!(object2 != null ? !object2.equals(none$) : none$ != null)) {
                writerResponse = WriterResponse$EmptyResponse$.MODULE$;
            } else if (object instanceof String) {
                String string2 = (String)object;
                writerResponse = WriterResponse$.MODULE$.apply(this.plainText, (Object)string2, WriterResponse$.MODULE$.apply$default$3());
            } else if (object instanceof InputStream) {
                InputStream inputStream = (InputStream)object;
                writerResponse = (WriterResponse)AutoClosable$.MODULE$.tryWith((AutoCloseable)inputStream, (Function1 & Serializable & scala.Serializable)closable -> WriterResponse$.MODULE$.apply($this.octetStream, (Object)StreamIO$.MODULE$.buffer(closable).toByteArray(), WriterResponse$.MODULE$.apply$default$3()));
            } else if (object instanceof File) {
                File file = (File)object;
                writerResponse = (WriterResponse)AutoClosable$.MODULE$.tryWith((AutoCloseable)new BufferedInputStream(new FileInputStream(file)), (Function1 & Serializable & scala.Serializable)closable -> WriterResponse$.MODULE$.apply($this.fileResolver.getContentType(file.getName()), (Object)StreamIO$.MODULE$.buffer((InputStream)closable).toByteArray(), WriterResponse$.MODULE$.apply$default$3()));
            } else {
                writerResponse = this.isPrimitiveOrWrapper(obj.getClass()) ? WriterResponse$.MODULE$.apply(this.plainText, (Object)obj.toString(), WriterResponse$.MODULE$.apply$default$3()) : WriterResponse$.MODULE$.apply(this.applicationJson, (Object)this.mapper.writeValueAsBytes(obj), WriterResponse$.MODULE$.apply$default$3());
            }
        }
        return writerResponse;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isPrimitiveWrapper(Class<?> clazz) {
        Class<?> clazz2 = clazz;
        Class<Double> clazz3 = Double.class;
        if (clazz2 == null) {
            if (clazz3 == null) return true;
        } else if (clazz2.equals(clazz3)) return true;
        Class<?> clazz4 = clazz;
        Class<Float> clazz5 = Float.class;
        if (clazz4 == null) {
            if (clazz5 == null) return true;
        } else if (clazz4.equals(clazz5)) return true;
        Class<?> clazz6 = clazz;
        Class<Long> clazz7 = Long.class;
        if (clazz6 == null) {
            if (clazz7 == null) return true;
        } else if (clazz6.equals(clazz7)) return true;
        Class<?> clazz8 = clazz;
        Class<Integer> clazz9 = Integer.class;
        if (clazz8 == null) {
            if (clazz9 == null) return true;
        } else if (clazz8.equals(clazz9)) return true;
        Class<?> clazz10 = clazz;
        Class<Short> clazz11 = Short.class;
        if (clazz10 == null) {
            if (clazz11 == null) return true;
        } else if (clazz10.equals(clazz11)) return true;
        Class<?> clazz12 = clazz;
        Class<Character> clazz13 = Character.class;
        if (clazz12 == null) {
            if (clazz13 == null) return true;
        } else if (clazz12.equals(clazz13)) return true;
        Class<?> clazz14 = clazz;
        Class<Byte> clazz15 = Byte.class;
        if (clazz14 == null) {
            if (clazz15 == null) return true;
        } else if (clazz14.equals(clazz15)) return true;
        Class<?> clazz16 = clazz;
        Class<Boolean> clazz17 = Boolean.class;
        if (clazz16 == null) {
            if (clazz17 == null) return true;
        } else if (clazz16.equals(clazz17)) return true;
        Class<?> clazz18 = clazz;
        Class<Void> clazz19 = Void.class;
        if (clazz18 != null) {
            if (!clazz18.equals(clazz19)) return false;
            return true;
        }
        if (clazz19 == null) return true;
        return false;
    }

    private boolean isPrimitiveOrWrapper(Class<?> clazz) {
        return clazz.isPrimitive() || this.isPrimitiveWrapper(clazz);
    }

    @Inject
    public DefaultMessageBodyWriterImpl(@Flag(value="http.response.charset.enabled") boolean includeContentTypeCharset, FileResolver fileResolver, FinatraObjectMapper mapper2) {
        this.fileResolver = fileResolver;
        this.mapper = mapper2;
        MessageBodyWriter.$init$(this);
        this.applicationJson = includeContentTypeCharset ? MediaType$.MODULE$.JsonUtf8() : MediaType$.MODULE$.Json();
        this.plainText = includeContentTypeCharset ? MediaType$.MODULE$.PlainTextUtf8() : MediaType$.MODULE$.PlainText();
        this.octetStream = MediaType$.MODULE$.OctetStream();
    }
}

