/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.toggle;

import com.twitter.finagle.server.ServerInfo;
import com.twitter.finagle.server.ServerInfo$;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.finagle.toggle.JsonToggleMap;
import com.twitter.finagle.toggle.JsonToggleMap$;
import com.twitter.finagle.toggle.JsonToggleMap$DescriptionIgnored$;
import com.twitter.finagle.toggle.JsonToggleMap$DescriptionRequired$;
import com.twitter.finagle.toggle.JsonToggleMap$FailParsingOnDuplicateId$;
import com.twitter.finagle.toggle.NullToggleMap$;
import com.twitter.finagle.toggle.ServiceLoadedToggleMap$;
import com.twitter.finagle.toggle.Toggle;
import com.twitter.finagle.toggle.Toggle$;
import com.twitter.finagle.toggle.ToggleMap;
import com.twitter.finagle.toggle.ToggleMap$;
import com.twitter.logging.Logger;
import com.twitter.logging.Logger$;
import com.twitter.util.Return;
import com.twitter.util.Throw;
import com.twitter.util.Try;
import java.io.Serializable;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;

public final class StandardToggleMap$ {
    public static StandardToggleMap$ MODULE$;
    private final Logger log;
    private final ConcurrentHashMap<String, ToggleMap.Mutable> libs;

    static {
        new StandardToggleMap$();
    }

    public Map<String, ToggleMap.Mutable> registeredLibraries() {
        return ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.libs).asScala()).toMap(Predef$.MODULE$.$conforms());
    }

    public ToggleMap.Mutable apply(String libraryName, StatsReceiver statsReceiver, JsonToggleMap.DuplicateHandling duplicateHandling) {
        return this.apply(libraryName, statsReceiver, ToggleMap$.MODULE$.newMutable(new StringBuilder(9).append("Mutable(").append(libraryName).append(")").toString()), ServerInfo$.MODULE$.apply(), this.libs, duplicateHandling);
    }

    public ToggleMap.Mutable apply(String libraryName, StatsReceiver statsReceiver, ToggleMap.Mutable mutable, ServerInfo serverInfo, ConcurrentMap<String, ToggleMap.Mutable> registry, JsonToggleMap.DuplicateHandling duplicateHandling) {
        Toggle$.MODULE$.validateId(libraryName);
        ToggleMap svcsJson = this.loadJsonConfig(new StringBuilder(8).append(libraryName).append("-service").toString(), serverInfo, JsonToggleMap$DescriptionIgnored$.MODULE$, JsonToggleMap$FailParsingOnDuplicateId$.MODULE$);
        ToggleMap libsJson = this.loadJsonConfig(libraryName, serverInfo, JsonToggleMap$DescriptionRequired$.MODULE$, JsonToggleMap$FailParsingOnDuplicateId$.MODULE$);
        ToggleMap stacked = ToggleMap$.MODULE$.of((Seq<ToggleMap>)Predef$.MODULE$.wrapRefArray((Object[])new ToggleMap[]{mutable, ToggleMap$.MODULE$.flags(), svcsJson, ServiceLoadedToggleMap$.MODULE$.apply(libraryName), libsJson}));
        ToggleMap observed = ToggleMap$.MODULE$.observed(stacked, statsReceiver.scope((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"toggles", libraryName})));
        ToggleMap.Proxy toggleMap = new ToggleMap.Proxy(observed, mutable){
            private final ToggleMap observed$1;
            private final ToggleMap.Mutable mutable$1;

            public String toString() {
                return ToggleMap.Proxy.toString$(this);
            }

            public Toggle apply(String id) {
                return ToggleMap.Proxy.apply$(this, id);
            }

            public Iterator<Toggle.Metadata> iterator() {
                return ToggleMap.Proxy.iterator$(this);
            }

            public ToggleMap underlying() {
                return this.observed$1;
            }

            public void put(String id, double fraction) {
                this.mutable$1.put(id, fraction);
            }

            public void remove(String id) {
                this.mutable$1.remove(id);
            }
            {
                this.observed$1 = observed$1;
                this.mutable$1 = mutable$1;
                ToggleMap.Proxy.$init$(this);
            }
        };
        ToggleMap.Mutable prev = registry.putIfAbsent(libraryName, (ToggleMap.Mutable)((Object)toggleMap));
        return prev == null ? toggleMap : prev;
    }

    public JsonToggleMap.DuplicateHandling apply$default$3() {
        return JsonToggleMap$FailParsingOnDuplicateId$.MODULE$;
    }

    private ToggleMap loadJsonConfig(String configName, ServerInfo serverInfo, JsonToggleMap.DescriptionMode descriptionMode, JsonToggleMap.DuplicateHandling duplicateHandling) {
        ToggleMap toggleMap;
        ToggleMap withoutEnv = this.loadJsonConfigWithEnv(configName, descriptionMode, duplicateHandling);
        Option<String> option = serverInfo.environment();
        if (option instanceof Some) {
            Some some = (Some)option;
            String env = (String)some.value();
            String e = env.toString().toLowerCase();
            toggleMap = this.loadJsonConfigWithEnv(new StringBuilder(1).append(configName).append("-").append(e).toString(), descriptionMode, duplicateHandling);
        } else if (None$.MODULE$.equals(option)) {
            toggleMap = NullToggleMap$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        NullToggleMap$ withEnv = toggleMap;
        return ((ToggleMap)withEnv).orElse(withoutEnv);
    }

    private long checksum(URL url) {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        try (DigestInputStream is = new DigestInputStream(url.openStream(), md);){
            byte[] bs = new byte[128];
            while (is.read(bs, 0, 128) != -1) {
            }
        }
        byte[] d = md.digest();
        return (long)d[0] & 0xFFL | ((long)d[1] & 0xFFL) << 8 | ((long)d[2] & 0xFFL) << 16 | ((long)d[3] & 0xFFL) << 24 | ((long)d[4] & 0xFFL) << 32 | ((long)d[5] & 0xFFL) << 40 | ((long)d[6] & 0xFFL) << 48 | ((long)d[7] & 0xFFL) << 56;
    }

    public URL selectResource(String configName, Seq<URL> urls) {
        Predef$.MODULE$.assert(urls.nonEmpty());
        if (urls.size() > 1 && ((SeqLike)((SeqLike)urls.map((Function1 & Serializable & scala.Serializable)url -> BoxesRunTime.boxToLong((long)StandardToggleMap$.MODULE$.checksum(url)), Seq$.MODULE$.canBuildFrom())).distinct()).size() > 1) {
            throw new IllegalArgumentException(new StringBuilder(55).append("Multiple differing Toggle config resources found for ").append(configName).append(", ").append(urls.mkString(", ")).toString());
        }
        return (URL)urls.head();
    }

    public ToggleMap loadJsonConfigWithEnv(String configName, JsonToggleMap.DescriptionMode descriptionMode, JsonToggleMap.DuplicateHandling duplicateHandling) {
        ToggleMap toggleMap;
        String rscPath;
        ClassLoader classLoader = this.getClass().getClassLoader();
        Seq rscs = ((TraversableOnce)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(classLoader.getResources(rscPath = new StringBuilder(33).append("com/twitter/toggles/configs/").append(configName).append(".json").toString())).asScala()).toSeq();
        if (rscs.isEmpty()) {
            toggleMap = NullToggleMap$.MODULE$;
        } else {
            ToggleMap toggleMap2;
            URL rsc = this.selectResource(configName, (Seq<URL>)rscs);
            this.log.debug(new StringBuilder(42).append("Toggle config resources found for ").append(configName).append(", using ").append(rsc).toString(), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            Try<ToggleMap> try_ = JsonToggleMap$.MODULE$.parse(rsc, descriptionMode, duplicateHandling);
            if (try_ instanceof Throw) {
                Throw throw_ = (Throw)try_;
                Throwable t = throw_.e();
                throw new IllegalArgumentException(new StringBuilder(51).append("Failure parsing Toggle config resources for ").append(configName).append(", from ").append(rsc).toString(), t);
            }
            if (!(try_ instanceof Return)) {
                throw new MatchError(try_);
            }
            Return return_ = (Return)try_;
            ToggleMap toggleMap3 = toggleMap2 = (ToggleMap)return_.r();
            toggleMap = toggleMap3;
        }
        return toggleMap;
    }

    private StandardToggleMap$() {
        MODULE$ = this;
        this.log = Logger$.MODULE$.get();
        this.libs = new ConcurrentHashMap();
    }
}

