/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.toggle;

import com.twitter.finagle.server.ServerInfo;
import com.twitter.finagle.server.ServerInfo$;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.finagle.toggle.JsonToggleMap;
import com.twitter.finagle.toggle.JsonToggleMap$;
import com.twitter.finagle.toggle.JsonToggleMap$DescriptionIgnored$;
import com.twitter.finagle.toggle.JsonToggleMap$DescriptionRequired$;
import com.twitter.finagle.toggle.NullToggleMap$;
import com.twitter.finagle.toggle.ServiceLoadedToggleMap$;
import com.twitter.finagle.toggle.Toggle$;
import com.twitter.finagle.toggle.ToggleMap;
import com.twitter.finagle.toggle.ToggleMap$;
import com.twitter.logging.Logger;
import com.twitter.logging.Logger$;
import com.twitter.util.Return;
import com.twitter.util.Throw;
import com.twitter.util.Try;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;

public final class StandardToggleMap$ {
    public static final StandardToggleMap$ MODULE$;
    private final Logger log;
    private final ConcurrentHashMap<String, ToggleMap> libs;

    static {
        new StandardToggleMap$();
    }

    public Map<String, ToggleMap> registeredLibraries() {
        return ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.libs).asScala()).toMap(Predef$.MODULE$.$conforms());
    }

    public ToggleMap apply(String libraryName, StatsReceiver statsReceiver) {
        return this.apply(libraryName, statsReceiver, (ToggleMap)((Object)ToggleMap$.MODULE$.newMutable()), ServerInfo$.MODULE$.apply(), this.libs);
    }

    public ToggleMap apply(String libraryName, StatsReceiver statsReceiver, ToggleMap mutable, ServerInfo serverInfo, ConcurrentMap<String, ToggleMap> registry) {
        Toggle$.MODULE$.validateId(libraryName);
        ToggleMap svcsJson = this.loadJsonConfig(libraryName, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-service"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{libraryName})), serverInfo, JsonToggleMap$DescriptionIgnored$.MODULE$);
        ToggleMap libsJson = this.loadJsonConfig(libraryName, libraryName, serverInfo, JsonToggleMap$DescriptionRequired$.MODULE$);
        ToggleMap stacked = ToggleMap$.MODULE$.of((Seq<ToggleMap>)Predef$.MODULE$.wrapRefArray((Object[])new ToggleMap[]{mutable, ToggleMap$.MODULE$.flags(), svcsJson, ServiceLoadedToggleMap$.MODULE$.apply(libraryName), libsJson}));
        ToggleMap toggleMap = ToggleMap$.MODULE$.observed(stacked, statsReceiver.scope((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"toggles", libraryName})));
        ToggleMap prev = registry.putIfAbsent(libraryName, toggleMap);
        return prev == null ? toggleMap : prev;
    }

    private ToggleMap loadJsonConfig(String libraryName, String configName, ServerInfo serverInfo, JsonToggleMap.DescriptionMode descriptionMode) {
        Option<String> option;
        block4: {
            ToggleMap toggleMap;
            ToggleMap withoutEnv;
            block3: {
                block2: {
                    withoutEnv = this.loadJsonConfigWithEnv(libraryName, configName, descriptionMode);
                    option = serverInfo.environment();
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String env = (String)some.x();
                    String e = env.toString().toLowerCase();
                    toggleMap = this.loadJsonConfigWithEnv(libraryName, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{configName, e})), descriptionMode);
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                toggleMap = NullToggleMap$.MODULE$;
            }
            NullToggleMap$ withEnv = toggleMap;
            return ((ToggleMap)withEnv).orElse(withoutEnv);
        }
        throw new MatchError(option);
    }

    private ToggleMap loadJsonConfigWithEnv(String libraryName, String configName, JsonToggleMap.DescriptionMode descriptionMode) {
        Try<ToggleMap> try_;
        block7: {
            ToggleMap toggleMap;
            block6: {
                ToggleMap toggleMap2;
                Seq rscs;
                block5: {
                    ClassLoader classLoader = this.getClass().getClassLoader();
                    String rscPath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"com/twitter/toggles/configs/", ".json"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{configName}));
                    rscs = ((TraversableOnce)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(classLoader.getResources(rscPath)).asScala()).toSeq();
                    if (rscs.size() > 1) {
                        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Multiple Toggle config resources found for ", ", ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{configName, rscs.mkString(",")})));
                    }
                    if (!rscs.isEmpty()) break block5;
                    toggleMap = NullToggleMap$.MODULE$;
                    break block6;
                }
                URL rsc = (URL)rscs.head();
                this.log.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Toggle config resources found for ", ", using ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{configName, rsc})), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                try_ = JsonToggleMap$.MODULE$.parse(rsc, descriptionMode);
                if (try_ instanceof Throw) {
                    Throw throw_ = (Throw)try_;
                    Throwable t = throw_.e();
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failure parsing Toggle config resources for ", ", from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{configName, rsc})), t);
                }
                if (!(try_ instanceof Return)) break block7;
                Return return_ = (Return)try_;
                ToggleMap toggleMap3 = toggleMap2 = (ToggleMap)return_.r();
                toggleMap = toggleMap3;
            }
            return toggleMap;
        }
        throw new MatchError(try_);
    }

    private StandardToggleMap$() {
        MODULE$ = this;
        this.log = Logger$.MODULE$.get();
        this.libs = new ConcurrentHashMap();
    }
}

