/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.toggle;

import com.twitter.finagle.server.ServerInfo;
import com.twitter.finagle.server.ServerInfo$;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.finagle.toggle.JsonToggleMap;
import com.twitter.finagle.toggle.JsonToggleMap$;
import com.twitter.finagle.toggle.JsonToggleMap$DescriptionIgnored$;
import com.twitter.finagle.toggle.JsonToggleMap$DescriptionRequired$;
import com.twitter.finagle.toggle.NullToggleMap$;
import com.twitter.finagle.toggle.ServiceLoadedToggleMap$;
import com.twitter.finagle.toggle.Toggle$;
import com.twitter.finagle.toggle.ToggleMap;
import com.twitter.finagle.toggle.ToggleMap$;
import com.twitter.logging.Logger;
import com.twitter.logging.Logger$;
import com.twitter.util.Return;
import com.twitter.util.Throw;
import com.twitter.util.Try;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;

public final class StandardToggleMap$ {
    public static final StandardToggleMap$ MODULE$;
    private final Logger log;
    private final ConcurrentHashMap<String, ToggleMap> libs;

    static {
        new StandardToggleMap$();
    }

    public Map<String, ToggleMap> registeredLibraries() {
        return ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.libs).asScala()).toMap(Predef$.MODULE$.$conforms());
    }

    public ToggleMap apply(String libraryName, StatsReceiver statsReceiver) {
        return this.apply(libraryName, statsReceiver, (ToggleMap)((Object)ToggleMap$.MODULE$.newMutable(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mutable(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{libraryName})))), ServerInfo$.MODULE$.apply(), this.libs);
    }

    public ToggleMap apply(String libraryName, StatsReceiver statsReceiver, ToggleMap mutable, ServerInfo serverInfo, ConcurrentMap<String, ToggleMap> registry) {
        Toggle$.MODULE$.validateId(libraryName);
        ToggleMap svcsJson = this.loadJsonConfig(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-service"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{libraryName})), serverInfo, JsonToggleMap$DescriptionIgnored$.MODULE$);
        ToggleMap libsJson = this.loadJsonConfig(libraryName, serverInfo, JsonToggleMap$DescriptionRequired$.MODULE$);
        ToggleMap stacked = ToggleMap$.MODULE$.of((Seq<ToggleMap>)Predef$.MODULE$.wrapRefArray((Object[])new ToggleMap[]{mutable, ToggleMap$.MODULE$.flags(), svcsJson, ServiceLoadedToggleMap$.MODULE$.apply(libraryName), libsJson}));
        ToggleMap toggleMap = ToggleMap$.MODULE$.observed(stacked, statsReceiver.scope((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"toggles", libraryName})));
        ToggleMap prev = registry.putIfAbsent(libraryName, toggleMap);
        return prev == null ? toggleMap : prev;
    }

    private ToggleMap loadJsonConfig(String configName, ServerInfo serverInfo, JsonToggleMap.DescriptionMode descriptionMode) {
        Option<String> option;
        block4: {
            ToggleMap toggleMap;
            ToggleMap withoutEnv;
            block3: {
                block2: {
                    withoutEnv = this.loadJsonConfigWithEnv(configName, descriptionMode);
                    option = serverInfo.environment();
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String env = (String)some.x();
                    String e = env.toString().toLowerCase();
                    toggleMap = this.loadJsonConfigWithEnv(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{configName, e})), descriptionMode);
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                toggleMap = NullToggleMap$.MODULE$;
            }
            NullToggleMap$ withEnv = toggleMap;
            return ((ToggleMap)withEnv).orElse(withoutEnv);
        }
        throw new MatchError(option);
    }

    /*
     * WARNING - void declaration
     */
    public long com$twitter$finagle$toggle$StandardToggleMap$$checksum(URL url) {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        DigestInputStream is = new DigestInputStream(url.openStream(), md);
        try {
            byte[] bs = new byte[128];
            while (is.read(bs, 0, 128) != -1) {
            }
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        is.close();
        byte[] d = md.digest();
        return (long)d[0] & 0xFFL | ((long)d[1] & 0xFFL) << 8 | ((long)d[2] & 0xFFL) << 16 | ((long)d[3] & 0xFFL) << 24 | ((long)d[4] & 0xFFL) << 32 | ((long)d[5] & 0xFFL) << 40 | ((long)d[6] & 0xFFL) << 48 | ((long)d[7] & 0xFFL) << 56;
    }

    public URL selectResource(String configName, Seq<URL> urls) {
        Predef$.MODULE$.assert(urls.nonEmpty());
        if (urls.size() > 1 && ((SeqLike)((SeqLike)urls.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(URL url) {
                return StandardToggleMap$.MODULE$.com$twitter$finagle$toggle$StandardToggleMap$$checksum(url);
            }
        }, Seq$.MODULE$.canBuildFrom())).distinct()).size() > 1) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Multiple differing Toggle config resources found for ", ", ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{configName, urls.mkString(", ")})));
        }
        return (URL)urls.head();
    }

    public ToggleMap loadJsonConfigWithEnv(String configName, JsonToggleMap.DescriptionMode descriptionMode) {
        Try<ToggleMap> try_;
        block6: {
            ToggleMap toggleMap;
            block5: {
                ToggleMap toggleMap2;
                Seq rscs;
                block4: {
                    ClassLoader classLoader = this.getClass().getClassLoader();
                    String rscPath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"com/twitter/toggles/configs/", ".json"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{configName}));
                    rscs = ((TraversableOnce)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(classLoader.getResources(rscPath)).asScala()).toSeq();
                    if (!rscs.isEmpty()) break block4;
                    toggleMap = NullToggleMap$.MODULE$;
                    break block5;
                }
                URL rsc = this.selectResource(configName, (Seq<URL>)rscs);
                this.log.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Toggle config resources found for ", ", using ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{configName, rsc})), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                try_ = JsonToggleMap$.MODULE$.parse(rsc, descriptionMode);
                if (try_ instanceof Throw) {
                    Throw throw_ = (Throw)try_;
                    Throwable t = throw_.e();
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failure parsing Toggle config resources for ", ", from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{configName, rsc})), t);
                }
                if (!(try_ instanceof Return)) break block6;
                Return return_ = (Return)try_;
                ToggleMap toggleMap3 = toggleMap2 = (ToggleMap)return_.r();
                toggleMap = toggleMap3;
            }
            return toggleMap;
        }
        throw new MatchError(try_);
    }

    private StandardToggleMap$() {
        MODULE$ = this;
        this.log = Logger$.MODULE$.get();
        this.libs = new ConcurrentHashMap();
    }
}

