/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4.codec.compression.zstd;

import com.twitter.finagle.netty4.codec.compression.zstd.ZstdByteBufDirectBufferCompressingStream;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;

public class ZstdStreamingEncoder
extends ChannelOutboundHandlerAdapter {
    private final int level;
    private ZstdByteBufDirectBufferCompressingStream compressor;

    public ZstdStreamingEncoder(int n) {
        this.level = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) throws Exception {
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            try {
                this.compressor.compressByteBuf(byteBuf);
                channelPromise.setSuccess();
            }
            finally {
                ReferenceCountUtil.release((Object)byteBuf);
            }
        } else {
            super.write(channelHandlerContext, object, channelPromise);
        }
    }

    public void flush(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.compressor.flush();
        channelHandlerContext.flush();
    }

    public void handlerAdded(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.compressor = new ZstdByteBufDirectBufferCompressingStream(channelHandlerContext, this.level);
    }

    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.closeCompressor();
    }

    private void closeCompressor() throws IOException {
        if (this.compressor != null) {
            this.compressor.close();
            this.compressor = null;
        }
    }
}

