/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4.ssl.client;

import com.twitter.finagle.Address;
import com.twitter.finagle.netty4.param.Allocator;
import com.twitter.finagle.netty4.param.Allocator$;
import com.twitter.finagle.netty4.ssl.client.Netty4ClientSslConfigurations$;
import com.twitter.finagle.ssl.ApplicationProtocols;
import com.twitter.finagle.ssl.CipherSuites;
import com.twitter.finagle.ssl.Engine;
import com.twitter.finagle.ssl.KeyCredentials;
import com.twitter.finagle.ssl.Protocols;
import com.twitter.finagle.ssl.SslConfigurationException$;
import com.twitter.finagle.ssl.TrustCredentials;
import com.twitter.finagle.ssl.client.SslClientConfiguration;
import com.twitter.finagle.ssl.client.SslClientConfiguration$;
import com.twitter.finagle.ssl.client.SslClientEngineFactory;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ScalaRunTime$;

public final class ExternalClientEngineFactory$
extends SslClientEngineFactory {
    public static final ExternalClientEngineFactory$ MODULE$ = new ExternalClientEngineFactory$();
    private static final ByteBufAllocator allocator = ((Allocator)Allocator$.MODULE$.allocatorParam().default()).allocator();
    private static final boolean forceJdk = !OpenSsl.isAvailable();
    private static final ApplicationProtocols.Supported http2AppProtocols = new ApplicationProtocols.Supported((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"h2", "http/1.1"})));
    private static final SslClientConfiguration withValidationConfig = new SslClientConfiguration(SslClientConfiguration$.MODULE$.apply$default$1(), SslClientConfiguration$.MODULE$.apply$default$2(), SslClientConfiguration$.MODULE$.apply$default$3(), SslClientConfiguration$.MODULE$.apply$default$4(), SslClientConfiguration$.MODULE$.apply$default$5(), SslClientConfiguration$.MODULE$.apply$default$6(), SslClientConfiguration$.MODULE$.apply$default$7());
    private static final SslClientConfiguration withoutValidationConfig;
    private static final SslClientConfiguration withValidation2Config;
    private static final SslClientConfiguration withoutValidation2Config;
    private static final SslContext withValidationContext;
    private static final SslContext withoutValidationContext;
    private static final SslContext withValidation2Context;
    private static final SslContext withoutValidation2Context;

    static {
        TrustCredentials.Insecure$ x$1 = TrustCredentials.Insecure$.MODULE$;
        Option x$2 = SslClientConfiguration$.MODULE$.apply$default$1();
        Option x$3 = SslClientConfiguration$.MODULE$.apply$default$2();
        KeyCredentials x$4 = SslClientConfiguration$.MODULE$.apply$default$3();
        CipherSuites x$5 = SslClientConfiguration$.MODULE$.apply$default$5();
        Protocols x$6 = SslClientConfiguration$.MODULE$.apply$default$6();
        ApplicationProtocols x$7 = SslClientConfiguration$.MODULE$.apply$default$7();
        withoutValidationConfig = new SslClientConfiguration(x$2, x$3, x$4, (TrustCredentials)x$1, x$5, x$6, x$7);
        ApplicationProtocols.Supported x$8 = MODULE$.http2AppProtocols();
        Option x$9 = MODULE$.withValidationConfig().copy$default$1();
        Option x$10 = MODULE$.withValidationConfig().copy$default$2();
        KeyCredentials x$11 = MODULE$.withValidationConfig().copy$default$3();
        TrustCredentials x$12 = MODULE$.withValidationConfig().copy$default$4();
        CipherSuites x$13 = MODULE$.withValidationConfig().copy$default$5();
        Protocols x$14 = MODULE$.withValidationConfig().copy$default$6();
        withValidation2Config = MODULE$.withValidationConfig().copy(x$9, x$10, x$11, x$12, x$13, x$14, (ApplicationProtocols)x$8);
        ApplicationProtocols.Supported x$15 = MODULE$.http2AppProtocols();
        Option x$16 = MODULE$.withoutValidationConfig().copy$default$1();
        Option x$17 = MODULE$.withoutValidationConfig().copy$default$2();
        KeyCredentials x$18 = MODULE$.withoutValidationConfig().copy$default$3();
        TrustCredentials x$19 = MODULE$.withoutValidationConfig().copy$default$4();
        CipherSuites x$20 = MODULE$.withoutValidationConfig().copy$default$5();
        Protocols x$21 = MODULE$.withoutValidationConfig().copy$default$6();
        withoutValidation2Config = MODULE$.withoutValidationConfig().copy(x$16, x$17, x$18, x$19, x$20, x$21, (ApplicationProtocols)x$15);
        withValidationContext = Netty4ClientSslConfigurations$.MODULE$.createClientContext(MODULE$.withValidationConfig(), MODULE$.forceJdk());
        withoutValidationContext = Netty4ClientSslConfigurations$.MODULE$.createClientContext(MODULE$.withoutValidationConfig(), MODULE$.forceJdk());
        withValidation2Context = Netty4ClientSslConfigurations$.MODULE$.createClientContext(MODULE$.withValidation2Config(), false);
        withoutValidation2Context = Netty4ClientSslConfigurations$.MODULE$.createClientContext(MODULE$.withoutValidation2Config(), false);
    }

    private ByteBufAllocator allocator() {
        return allocator;
    }

    private boolean forceJdk() {
        return forceJdk;
    }

    private ApplicationProtocols.Supported http2AppProtocols() {
        return http2AppProtocols;
    }

    private SslClientConfiguration withValidationConfig() {
        return withValidationConfig;
    }

    private SslClientConfiguration withoutValidationConfig() {
        return withoutValidationConfig;
    }

    private SslClientConfiguration withValidation2Config() {
        return withValidation2Config;
    }

    private SslClientConfiguration withoutValidation2Config() {
        return withoutValidation2Config;
    }

    private SslContext withValidationContext() {
        return withValidationContext;
    }

    private SslContext withoutValidationContext() {
        return withoutValidationContext;
    }

    private SslContext withValidation2Context() {
        return withValidation2Context;
    }

    private SslContext withoutValidation2Context() {
        return withoutValidation2Context;
    }

    private boolean usingHttp2(SslClientConfiguration config) {
        boolean bl;
        ApplicationProtocols applicationProtocols = config.applicationProtocols();
        if (applicationProtocols instanceof ApplicationProtocols.Supported) {
            ApplicationProtocols.Supported supported = (ApplicationProtocols.Supported)applicationProtocols;
            Seq supported2 = supported.appProtocols();
            bl = supported2.contains((Object)"h2");
        } else {
            bl = false;
        }
        return bl;
    }

    private SslContext selectContext(SslClientConfiguration config) {
        SslContext sslContext;
        TrustCredentials trustCredentials = config.trustCredentials();
        if (TrustCredentials.Unspecified$.MODULE$.equals(trustCredentials)) {
            sslContext = this.usingHttp2(config) ? this.withValidation2Context() : this.withValidationContext();
        } else if (TrustCredentials.Insecure$.MODULE$.equals(trustCredentials)) {
            sslContext = this.usingHttp2(config) ? this.withoutValidation2Context() : this.withoutValidationContext();
        } else {
            throw SslConfigurationException$.MODULE$.notSupported("Unknown TrustCredentials value", "ExternalClientEngineFactory");
        }
        return sslContext;
    }

    public Engine apply(Address address, SslClientConfiguration config) {
        SslContext context = this.selectContext(config);
        return Netty4ClientSslConfigurations$.MODULE$.createClientEngine(address, config, context, this.allocator());
    }

    private ExternalClientEngineFactory$() {
    }
}

