/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4.http;

import com.twitter.finagle.http.Chunk;
import com.twitter.finagle.http.Chunk$;
import com.twitter.finagle.http.FileElement;
import com.twitter.finagle.http.FormElement;
import com.twitter.finagle.http.MediaType$;
import com.twitter.finagle.http.Method$;
import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.RequestConfig;
import com.twitter.finagle.http.RequestConfig$;
import com.twitter.finagle.http.SimpleElement;
import com.twitter.finagle.http.exp.FormPostEncoder;
import com.twitter.finagle.netty4.ByteBufConversion$;
import com.twitter.finagle.netty4.http.Bijections$finagle$;
import com.twitter.finagle.netty4.http.Bijections$netty$;
import com.twitter.io.Buf;
import com.twitter.io.Reader;
import com.twitter.io.Reader$;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestEncoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Netty4FormPostEncoder$
implements FormPostEncoder {
    public static final Netty4FormPostEncoder$ MODULE$ = new Netty4FormPostEncoder$();
    private static final String BinaryTransferEncodingMechanism = "binary";

    private HttpRequest makeNetty4Request(RequestConfig config) {
        HttpVersion version = Bijections$finagle$.MODULE$.versionToNetty(config.version());
        HttpMethod method = Bijections$finagle$.MODULE$.methodToNetty(Method$.MODULE$.Post());
        String uri = RequestConfig$.MODULE$.resource(config);
        DefaultHttpRequest request = new DefaultHttpRequest(version, method, uri);
        config.headers().foreach((Function1 & Serializable)x0$1 -> {
            Netty4FormPostEncoder$.$anonfun$makeNetty4Request$1(request, x0$1);
            return BoxedUnit.UNIT;
        });
        return request;
    }

    public Request encode(RequestConfig config, boolean multipart) {
        Request request;
        DefaultHttpDataFactory dataFactory = new DefaultHttpDataFactory(false);
        HttpRequest netty4Request = this.makeNetty4Request(config);
        if (netty4Request instanceof FullHttpRequest) {
            throw new IllegalStateException(new StringBuilder(0).append("Unexpected state: Expected the generated request to NOT").append(new StringBuilder(19).append("be a full request: ").append(netty4Request.getClass().getSimpleName()).toString()).toString());
        }
        try (HttpPostRequestEncoder encoder = new HttpPostRequestEncoder((HttpDataFactory)dataFactory, netty4Request, multipart);){
            Request request2;
            BoxedUnit boxedUnit;
            config.formElements().foreach((Function1 & Serializable)x0$1 -> {
                Netty4FormPostEncoder$.$anonfun$encode$1(encoder, dataFactory, netty4Request, x0$1);
                return BoxedUnit.UNIT;
            });
            HttpRequest encodedReq = encoder.finalizeRequest();
            if (HttpUtil.isTransferEncodingChunked((HttpMessage)encodedReq)) {
                List encodings = encodedReq.headers().getAll("Transfer-Encoding");
                if (encodings.contains("chunked")) {
                    if (encodings.size() == 1) {
                        boxedUnit = encodedReq.headers().remove("Transfer-Encoding");
                    } else {
                        ArrayList<String> newList = new ArrayList<String>(encodings.size() - 1);
                        block6: for (String string : encodings) {
                            Object object;
                            switch (string == null ? 0 : string.hashCode()) {
                                case 757417932: {
                                    if (!"chunked".equals(string)) break;
                                    object = BoxedUnit.UNIT;
                                    continue block6;
                                }
                            }
                            object = BoxesRunTime.boxToBoolean((boolean)newList.add(string));
                        }
                        boxedUnit = encodedReq.headers().set("Transfer-Encoding", newList);
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            HttpRequest httpRequest = encodedReq;
            if (httpRequest instanceof FullHttpRequest) {
                FullHttpRequest fullHttpRequest = (FullHttpRequest)httpRequest;
                Request req = Bijections$netty$.MODULE$.fullRequestToFinagle(fullHttpRequest, new InetSocketAddress(0));
                Option option = req.contentLength();
                if (None$.MODULE$.equals(option)) {
                    req.contentLength_$eq((long)req.content().length());
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                } else if (option instanceof Some) {
                    BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)option);
                }
                request2 = req;
            } else {
                Buf body = this.collectBodyFromEncoder(encoder);
                request2 = this.chunkedReqToFinagle(httpRequest, body);
            }
            request = request2;
        }
        return request;
    }

    /*
     * WARNING - void declaration
     */
    private Request chunkedReqToFinagle(HttpRequest nettyReq, Buf body) {
        void var3_3;
        Request req = Bijections$netty$.MODULE$.chunkedRequestToFinagle(nettyReq, (Reader<Chunk>)Reader$.MODULE$.value((Object)Chunk$.MODULE$.apply(body)), new InetSocketAddress(0));
        req.setChunked(false);
        req.content_$eq(body);
        req.contentLength_$eq((long)body.length());
        return var3_3;
    }

    private Buf collectBodyFromEncoder(HttpPostRequestEncoder encoder) {
        Buf buf;
        UnpooledByteBufAllocator allocator = UnpooledByteBufAllocator.DEFAULT;
        CompositeByteBuf acc = PooledByteBufAllocator.DEFAULT.compositeHeapBuffer(Integer.MAX_VALUE);
        try {
            while (!encoder.isEndOfInput()) {
                HttpContent chunk = encoder.readChunk((ByteBufAllocator)allocator);
                acc.addComponent(true, chunk.content());
            }
            byte[] arr = new byte[acc.readableBytes()];
            acc.readBytes(arr);
            buf = Buf.ByteArray$.Owned$.MODULE$.apply(arr);
        }
        finally {
            acc.release();
        }
        return buf;
    }

    private void addBodyFileUpload(HttpPostRequestEncoder encoder, HttpDataFactory factory, HttpRequest request, String name, String filename, Buf content, String contentType, boolean isText) {
        Predef$.MODULE$.require(name != null);
        Predef$.MODULE$.require(filename != null);
        Predef$.MODULE$.require(content != null);
        String uploadContentType = contentType == null ? (isText ? MediaType$.MODULE$.PlainText() : MediaType$.MODULE$.OctetStream()) : contentType;
        String contentTransferEncoding = !isText ? this.BinaryTransferEncodingMechanism() : null;
        FileUpload fileUpload = factory.createFileUpload(request, name, filename, uploadContentType, contentTransferEncoding, null, (long)content.length());
        fileUpload.setContent(ByteBufConversion$.MODULE$.bufAsByteBuf(content));
        encoder.addBodyHttpData((InterfaceHttpData)fileUpload);
    }

    private String BinaryTransferEncodingMechanism() {
        return BinaryTransferEncodingMechanism;
    }

    public static final /* synthetic */ void $anonfun$makeNetty4Request$1(DefaultHttpRequest request$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String field = (String)tuple2._1();
        Seq values = (Seq)tuple2._2();
        values.foreach((Function1 & Serializable)v -> request$1.headers().add(field, v));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$encode$1(HttpPostRequestEncoder encoder$1, DefaultHttpDataFactory dataFactory$1, HttpRequest netty4Request$1, FormElement x0$1) {
        FormElement formElement = x0$1;
        if (formElement instanceof FileElement) {
            FileElement fileElement = (FileElement)formElement;
            String name = fileElement.name();
            Buf content = fileElement.content();
            Option contentType = fileElement.contentType();
            Option filename = fileElement.filename();
            boolean isText = fileElement.isText();
            MODULE$.addBodyFileUpload(encoder$1, (HttpDataFactory)dataFactory$1, netty4Request$1, name, (String)filename.getOrElse((Function0 & Serializable)() -> ""), content, (String)contentType.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), isText);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (formElement instanceof SimpleElement) {
            SimpleElement simpleElement = (SimpleElement)formElement;
            String name = simpleElement.name();
            String value = simpleElement.content();
            encoder$1.addBodyAttribute(name, value);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)formElement);
        }
    }

    private Netty4FormPostEncoder$() {
    }
}

