/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4.http;

import com.twitter.finagle.http.codec.ChannelBufferUsageTracker;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005]3Q!\u0003\u0006\u0001\u0015QA\u0001b\b\u0001\u0003\u0002\u0003\u0006I!\t\u0005\u0006Q\u0001!\t!\u000b\u0005\u0007[\u0001\u0001\u000b\u0015\u0002\u0018\t\u000bQ\u0002A\u0011I\u001b\t\u000b!\u0003A\u0011I%\t\u000b1\u0003A\u0011I'\t\rE\u0003\u0001\u0015\"\u0003S\u0011\u0019)\u0006\u0001)C\u0005-\nq!)\u001f;f\u0005V4W*\u00198bO\u0016\u0014(BA\u0006\r\u0003\u0011AG\u000f\u001e9\u000b\u00055q\u0011A\u00028fiRLHG\u0003\u0002\u0010!\u00059a-\u001b8bO2,'BA\t\u0013\u0003\u001d!x/\u001b;uKJT\u0011aE\u0001\u0004G>l7C\u0001\u0001\u0016!\t1R$D\u0001\u0018\u0015\tA\u0012$A\u0004dQ\u0006tg.\u001a7\u000b\u0005iY\u0012!\u00028fiRL(\"\u0001\u000f\u0002\u0005%|\u0017B\u0001\u0010\u0018\u0005Q\u0019\u0005.\u00198oK2$U\u000f\u001d7fq\"\u000bg\u000e\u001a7fe\u0006aQo]1hKR\u0013\u0018mY6fe\u000e\u0001\u0001C\u0001\u0012'\u001b\u0005\u0019#B\u0001\u0013&\u0003\u0015\u0019w\u000eZ3d\u0015\tYa\"\u0003\u0002(G\tI2\t[1o]\u0016d')\u001e4gKJ,6/Y4f)J\f7m[3s\u0003\u0019a\u0014N\\5u}Q\u0011!\u0006\f\t\u0003W\u0001i\u0011A\u0003\u0005\u0006?\t\u0001\r!I\u0001\fEV4g-\u001a:Vg\u0006<W\r\u0005\u00020e5\t\u0001GC\u00012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0004G\u0001\u0003M_:<\u0017!B<sSR,G\u0003\u0002\u001c:}\r\u0003\"aL\u001c\n\u0005a\u0002$\u0001B+oSRDQA\u000f\u0003A\u0002m\n1a\u0019;y!\t1B(\u0003\u0002>/\t)2\t[1o]\u0016d\u0007*\u00198eY\u0016\u00148i\u001c8uKb$\b\"B \u0005\u0001\u0004\u0001\u0015aA7tOB\u0011q&Q\u0005\u0003\u0005B\u00121!\u00118z\u0011\u0015!E\u00011\u0001F\u0003\u001d\u0001(o\\7jg\u0016\u0004\"A\u0006$\n\u0005\u001d;\"AD\"iC:tW\r\u001c)s_6L7/Z\u0001\fG\"\fgN\\3m%\u0016\fG\rF\u00027\u0015.CQAO\u0003A\u0002mBQaP\u0003A\u0002\u0001\u000bQa\u00197pg\u0016$2A\u000e(P\u0011\u0015Qd\u00011\u0001<\u0011\u0015\u0001f\u00011\u0001F\u0003\u00191W\u000f^;sK\u0006\u0019\u0012N\\2sK\u0006\u001cXMQ;gM\u0016\u0014Xk]1hKR\u0011ag\u0015\u0005\u0006)\u001e\u0001\rAL\u0001\u0005g&TX-\u0001\tdY\u0016\f'OQ;gM\u0016\u0014Xk]1hKR\ta\u0007")
public class ByteBufManager
extends ChannelDuplexHandler {
    private final ChannelBufferUsageTracker usageTracker;
    private long bufferUsage;

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        this.clearBufferUsage();
        super.write(ctx, msg, promise);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        Object object = msg;
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            this.increaseBufferUsage(byteBuf.capacity());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        super.channelRead(ctx, msg);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise future) {
        this.clearBufferUsage();
        super.close(ctx, future);
    }

    private void increaseBufferUsage(long size) {
        this.usageTracker.increase(size);
        this.bufferUsage += size;
    }

    private void clearBufferUsage() {
        this.usageTracker.decrease(this.bufferUsage);
        this.bufferUsage = 0L;
    }

    public ByteBufManager(ChannelBufferUsageTracker usageTracker) {
        this.usageTracker = usageTracker;
        this.bufferUsage = 0L;
    }
}

