/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.codec;

import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import scala.Predef$;
import scala.ScalaObject;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001y3A!\u0001\u0002\u0001\u001b\t\t2i\u001c8oK\u000e$\u0018n\u001c8NC:\fw-\u001a:\u000b\u0005\r!\u0011!B2pI\u0016\u001c'BA\u0003\u0007\u0003\u0011AG\u000f\u001e9\u000b\u0005\u001dA\u0011a\u00024j]\u0006<G.\u001a\u0006\u0003\u0013)\tq\u0001^<jiR,'OC\u0001\f\u0003\r\u0019w.\\\u0002\u0001'\r\u0001aB\u0006\t\u0003\u001fQi\u0011\u0001\u0005\u0006\u0003#I\tA\u0001\\1oO*\t1#\u0001\u0003kCZ\f\u0017BA\u000b\u0011\u0005\u0019y%M[3diB\u0011qCG\u0007\u00021)\t\u0011$A\u0003tG\u0006d\u0017-\u0003\u0002\u001c1\tY1kY1mC>\u0013'.Z2u\u0011\u0015i\u0002\u0001\"\u0001\u001f\u0003\u0019a\u0014N\\5u}Q\tq\u0004\u0005\u0002!\u00015\t!\u0001\u0003\u0004#\u0001\u0001\u0006KaI\u0001\fSN\\U-\u001a9BY&4X\r\u0005\u0002\u0018I%\u0011Q\u0005\u0007\u0002\b\u0005>|G.Z1o\u0011\u00199\u0003\u0001)Q\u0005G\u00051\u0011n]%eY\u0016Da!\u000b\u0001!B\u0013Q\u0013AB2ik:\\7\u000f\u0005\u0002\u0018W%\u0011A\u0006\u0007\u0002\u0004\u0013:$\b\"\u0002\u0018\u0001\t\u0003y\u0013AD8cg\u0016\u0014h/Z'fgN\fw-\u001a\u000b\u0003aM\u0002\"aF\u0019\n\u0005IB\"\u0001B+oSRDQ\u0001N\u0017A\u0002U\nq!\\3tg\u0006<W\r\u0005\u0002\u0018m%\u0011q\u0007\u0007\u0002\u0004\u0003:L\b\"B\u001d\u0001\t\u0003Q\u0014AD8cg\u0016\u0014h/\u001a*fcV,7\u000f\u001e\u000b\u0003amBQ\u0001\u0010\u001dA\u0002u\nqA]3rk\u0016\u001cH\u000f\u0005\u0002?\u00136\tqH\u0003\u0002\u0006\u0001*\u00111!\u0011\u0006\u0003\u0005\u000e\u000bq\u0001[1oI2,'O\u0003\u0002E\u000b\u0006)a.\u001a;us*\u0011aiR\u0001\u0006U\n|7o\u001d\u0006\u0002\u0011\u0006\u0019qN]4\n\u0005){$a\u0003%uiB\u0014V-];fgRDQ\u0001\u0014\u0001\u0005\u00025\u000bqb\u001c2tKJ4XMU3ta>t7/\u001a\u000b\u0003a9CQaT&A\u0002A\u000b\u0001B]3ta>t7/\u001a\t\u0003}EK!AU \u0003\u0019!#H\u000f\u001d*fgB|gn]3\t\u000bQ\u0003A\u0011A+\u0002\u0019=\u00147/\u001a:wK\u000eCWO\\6\u0015\u0005A2\u0006\"B,T\u0001\u0004A\u0016!B2ik:\\\u0007C\u0001 Z\u0013\tQvHA\u0005IiR\u00048\t[;oW\")A\f\u0001C\u0001;\u0006Y1\u000f[8vY\u0012\u001cEn\\:f)\u0005\u0019\u0003")
public class ConnectionManager
implements ScalaObject {
    private boolean isKeepAlive = false;
    private boolean isIdle = true;
    private int chunks = 0;

    public void observeMessage(Object message) {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            BoxedUnit boxedUnit;
            Object object = message;
            if (object instanceof HttpRequest) {
                this.observeRequest((HttpRequest)object);
                boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof HttpResponse) {
                this.observeResponse((HttpResponse)object);
                boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof HttpChunk) {
                this.observeChunk((HttpChunk)object);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.isKeepAlive = false;
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public void observeRequest(HttpRequest request) {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            BoxedUnit boxedUnit;
            this.isIdle = false;
            this.isKeepAlive = HttpHeaders.isKeepAlive((HttpMessage)request);
            if (request.isChunked()) {
                ++this.chunks;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public void observeResponse(HttpResponse response) {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            BoxedUnit boxedUnit;
            if (response.isChunked() || response.headers().contains("Content-Length")) {
                if (!HttpHeaders.isKeepAlive((HttpMessage)response)) {
                    this.isKeepAlive = false;
                }
            } else {
                this.isKeepAlive = false;
            }
            boolean bl = this.isIdle = !response.isChunked();
            if (response.isChunked()) {
                ++this.chunks;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public void observeChunk(HttpChunk chunk) {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            Predef$.MODULE$.require(!this.isIdle);
            if (chunk.isLast()) {
                --this.chunks;
            }
            this.isIdle = this.chunks == 0;
            return;
        }
    }

    public boolean shouldClose() {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            Boolean bl = BoxesRunTime.boxToBoolean((this.isIdle && !this.isKeepAlive ? 1 : 0) != 0);
            return BoxesRunTime.unboxToBoolean((Object)bl);
        }
    }
}

