/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.codec;

import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import scala.Predef$;
import scala.ScalaObject;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001e3A!\u0001\u0002\u0001\u001b\t\t2i\u001c8oK\u000e$\u0018n\u001c8NC:\fw-\u001a:\u000b\u0005\r!\u0011!B2pI\u0016\u001c'BA\u0003\u0007\u0003\u0011AG\u000f\u001e9\u000b\u0005\u001dA\u0011a\u00024j]\u0006<G.\u001a\u0006\u0003\u0013)\tq\u0001^<jiR,'OC\u0001\f\u0003\r\u0019w.\\\u0002\u0001'\r\u0001aB\u0006\t\u0003\u001fQi\u0011\u0001\u0005\u0006\u0003#I\tA\u0001\\1oO*\t1#\u0001\u0003kCZ\f\u0017BA\u000b\u0011\u0005\u0019y%M[3diB\u0011qCG\u0007\u00021)\t\u0011$A\u0003tG\u0006d\u0017-\u0003\u0002\u001c1\tY1kY1mC>\u0013'.Z2u\u0011\u0015i\u0002\u0001\"\u0001\u001f\u0003\u0019a\u0014N\\5u}Q\tq\u0004\u0005\u0002!\u00015\t!\u0001\u0003\u0004#\u0001\u0001\u0006KaI\u0001\fSN\\U-\u001a9BY&4X\r\u0005\u0002\u0018I%\u0011Q\u0005\u0007\u0002\b\u0005>|G.Z1o\u0011\u00199\u0003\u0001)Q\u0005G\u00051\u0011n]%eY\u0016DQ!\u000b\u0001\u0005\u0002)\nab\u001c2tKJ4X-T3tg\u0006<W\r\u0006\u0002,]A\u0011q\u0003L\u0005\u0003[a\u0011A!\u00168ji\")q\u0006\u000ba\u0001a\u00059Q.Z:tC\u001e,\u0007CA\f2\u0013\t\u0011\u0004DA\u0002B]fDQ\u0001\u000e\u0001\u0005\u0002U\nab\u001c2tKJ4XMU3rk\u0016\u001cH\u000f\u0006\u0002,m!)qg\ra\u0001q\u00059!/Z9vKN$\bCA\u001dE\u001b\u0005Q$BA\u0003<\u0015\t\u0019AH\u0003\u0002>}\u00059\u0001.\u00198eY\u0016\u0014(BA A\u0003\u0015qW\r\u001e;z\u0015\t\t%)A\u0003kE>\u001c8OC\u0001D\u0003\ry'oZ\u0005\u0003\u000bj\u00121\u0002\u0013;uaJ+\u0017/^3ti\")q\t\u0001C\u0001\u0011\u0006yqNY:feZ,'+Z:q_:\u001cX\r\u0006\u0002,\u0013\")!J\u0012a\u0001\u0017\u0006A!/Z:q_:\u001cX\r\u0005\u0002:\u0019&\u0011QJ\u000f\u0002\r\u0011R$\bOU3ta>t7/\u001a\u0005\u0006\u001f\u0002!\t\u0001U\u0001\r_\n\u001cXM\u001d<f\u0007\",hn\u001b\u000b\u0003WECQA\u0015(A\u0002M\u000bQa\u00195v].\u0004\"!\u000f+\n\u0005US$!\u0003%uiB\u001c\u0005.\u001e8l\u0011\u00159\u0006\u0001\"\u0001Y\u0003-\u0019\bn\\;mI\u000ecwn]3\u0015\u0003\r\u0002")
public class ConnectionManager
implements ScalaObject {
    private boolean isKeepAlive = false;
    private boolean isIdle = true;

    public void observeMessage(Object message) {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            BoxedUnit boxedUnit;
            Object object = message;
            if (object instanceof HttpRequest) {
                this.observeRequest((HttpRequest)object);
                boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof HttpResponse) {
                this.observeResponse((HttpResponse)object);
                boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof HttpChunk) {
                this.observeChunk((HttpChunk)object);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.isKeepAlive = false;
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public void observeRequest(HttpRequest request) {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            this.isIdle = false;
            this.isKeepAlive = HttpHeaders.isKeepAlive((HttpMessage)request);
            return;
        }
    }

    public void observeResponse(HttpResponse response) {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            if (response.isChunked() || response.headers().contains("Content-Length")) {
                if (!HttpHeaders.isKeepAlive((HttpMessage)response)) {
                    this.isKeepAlive = false;
                }
            } else {
                this.isKeepAlive = false;
            }
            this.isIdle = !response.isChunked();
            return;
        }
    }

    public void observeChunk(HttpChunk chunk) {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            Predef$.MODULE$.require(!this.isIdle);
            this.isIdle = chunk.isLast();
            return;
        }
    }

    public boolean shouldClose() {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            Boolean bl = BoxesRunTime.boxToBoolean((this.isIdle && !this.isKeepAlive ? 1 : 0) != 0);
            return BoxesRunTime.unboxToBoolean((Object)bl);
        }
    }
}

