/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.codec;

import com.twitter.finagle.http.codec.ChannelBufferUsageTracker;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.WriteCompletionEvent;
import scala.ScalaObject;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001a3A!\u0001\u0002\u0001\u001b\t!2\t[1o]\u0016d')\u001e4gKJl\u0015M\\1hKJT!a\u0001\u0003\u0002\u000b\r|G-Z2\u000b\u0005\u00151\u0011\u0001\u00025uiBT!a\u0002\u0005\u0002\u000f\u0019Lg.Y4mK*\u0011\u0011BC\u0001\bi^LG\u000f^3s\u0015\u0005Y\u0011aA2p[\u000e\u00011c\u0001\u0001\u000f5A\u0011q\u0002G\u0007\u0002!)\u0011\u0011CE\u0001\bG\"\fgN\\3m\u0015\t\u0019B#A\u0003oKR$\u0018P\u0003\u0002\u0016-\u0005)!NY8tg*\tq#A\u0002pe\u001eL!!\u0007\t\u0003)MKW\u000e\u001d7f\u0007\"\fgN\\3m\u0011\u0006tG\r\\3s!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u0011\u0005\u0002!\u0011!Q\u0001\n\t\nA\"^:bO\u0016$&/Y2lKJ\u0004\"a\t\u0013\u000e\u0003\tI!!\n\u0002\u00033\rC\u0017M\u001c8fY\n+hMZ3s+N\fw-\u001a+sC\u000e\\WM\u001d\u0005\u0006O\u0001!\t\u0001K\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005%R\u0003CA\u0012\u0001\u0011\u0015\tc\u00051\u0001#\u0011\u0019a\u0003\u0001)Q\u0005[\u0005Y!-\u001e4gKJ,6/Y4f!\tYb&\u0003\u000209\t!Aj\u001c8h\u0011\u0015\t\u0004\u0001\"\u00113\u0003=iWm]:bO\u0016\u0014VmY3jm\u0016$GcA\u001a7wA\u00111\u0004N\u0005\u0003kq\u0011A!\u00168ji\")q\u0007\ra\u0001q\u0005\u00191\r\u001e=\u0011\u0005=I\u0014B\u0001\u001e\u0011\u0005U\u0019\u0005.\u00198oK2D\u0015M\u001c3mKJ\u001cuN\u001c;fqRDQ\u0001\u0010\u0019A\u0002u\n\u0011!\u001a\t\u0003\u001fyJ!a\u0010\t\u0003\u00195+7o]1hK\u00163XM\u001c;\t\u000b\u0005\u0003A\u0011\t\"\u0002\u001b]\u0014\u0018\u000e^3D_6\u0004H.\u001a;f)\r\u00194\t\u0012\u0005\u0006o\u0001\u0003\r\u0001\u000f\u0005\u0006y\u0001\u0003\r!\u0012\t\u0003\u001f\u0019K!a\u0012\t\u0003)]\u0013\u0018\u000e^3D_6\u0004H.\u001a;j_:,e/\u001a8u\u0011\u0015I\u0005\u0001\"\u0011K\u00035\u0019\u0007.\u00198oK2\u001cEn\\:fIR\u00191g\u0013'\t\u000b]B\u0005\u0019\u0001\u001d\t\u000bqB\u0005\u0019A'\u0011\u0005=q\u0015BA(\u0011\u0005E\u0019\u0005.\u00198oK2\u001cF/\u0019;f\u000bZ,g\u000e\u001e\u0005\u0007#\u0002\u0001K\u0011\u0002*\u0002'%t7M]3bg\u0016\u0014UO\u001a4feV\u001b\u0018mZ3\u0015\u0005M\u001a\u0006\"\u0002+Q\u0001\u0004i\u0013\u0001B:ju\u0016DaA\u0016\u0001!\n\u00139\u0016\u0001E2mK\u0006\u0014()\u001e4gKJ,6/Y4f)\u0005\u0019\u0004")
public class ChannelBufferManager
extends SimpleChannelHandler
implements ScalaObject {
    private final ChannelBufferUsageTracker usageTracker;
    private long bufferUsage;

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
        Object object = e.getMessage();
        if (object instanceof ChannelBuffer) {
            this.increaseBufferUsage(((ChannelBuffer)object).capacity());
        }
        super.messageReceived(ctx, e);
    }

    public void writeComplete(ChannelHandlerContext ctx, WriteCompletionEvent e) {
        this.clearBufferUsage();
        super.writeComplete(ctx, e);
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) {
        this.clearBufferUsage();
        super.channelClosed(ctx, e);
    }

    private void increaseBufferUsage(long size) {
        this.usageTracker.increase(size);
        this.bufferUsage += size;
    }

    private void clearBufferUsage() {
        this.usageTracker.decrease(this.bufferUsage);
        this.bufferUsage = 0L;
    }

    public ChannelBufferManager(ChannelBufferUsageTracker usageTracker) {
        this.usageTracker = usageTracker;
        this.bufferUsage = 0L;
    }
}

