/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.filter;

import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Response;
import com.twitter.finagle.http.filter.LogFormatter;
import com.twitter.util.Duration;
import java.io.Serializable;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import scala.Function0;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005y3Aa\u0002\u0005\u0001'!)a\u0004\u0001C\u0001?!9\u0011\u0005\u0001b\u0001\n\u0003\u0011\u0003BB\u0017\u0001A\u0003%1\u0005C\u0003'\u0001\u0011\u0005a\u0006C\u0003N\u0001\u0011\u0005a\nC\u0003]\u0001\u0011\u0005QL\u0001\nD_6lwN\u001c'pO\u001a{'/\\1ui\u0016\u0014(BA\u0005\u000b\u0003\u00191\u0017\u000e\u001c;fe*\u00111\u0002D\u0001\u0005QR$\bO\u0003\u0002\u000e\u001d\u00059a-\u001b8bO2,'BA\b\u0011\u0003\u001d!x/\u001b;uKJT\u0011!E\u0001\u0004G>l7\u0001A\n\u0004\u0001QQ\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g\r\u0005\u0002\u001c95\t\u0001\"\u0003\u0002\u001e\u0011\taAj\\4G_Jl\u0017\r\u001e;fe\u00061A(\u001b8jiz\"\u0012\u0001\t\t\u00037\u0001\t!\u0002R1uK\u001a{'/\\1u+\u0005\u0019\u0003C\u0001\u0013,\u001b\u0005)#B\u0001\u0014(\u0003\u00191wN]7bi*\u0011\u0001&K\u0001\u0005i&lWMC\u0001+\u0003\u0011Q\u0017M^1\n\u00051*#!\u0005#bi\u0016$\u0016.\\3G_Jl\u0017\r\u001e;fe\u0006YA)\u0019;f\r>\u0014X.\u0019;!)\u0011y#\bQ#\u0011\u0005A:dBA\u00196!\t\u0011d#D\u00014\u0015\t!$#\u0001\u0004=e>|GOP\u0005\u0003mY\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001d:\u0005\u0019\u0019FO]5oO*\u0011aG\u0006\u0005\u0006w\u0011\u0001\r\u0001P\u0001\be\u0016\fX/Z:u!\tid(D\u0001\u000b\u0013\ty$BA\u0004SKF,Xm\u001d;\t\u000b\u0005#\u0001\u0019\u0001\"\u0002\u0011I,7\u000f]8og\u0016\u0004\"!P\"\n\u0005\u0011S!\u0001\u0003*fgB|gn]3\t\u000b\u0019#\u0001\u0019A$\u0002\u0019I,7\u000f]8og\u0016$\u0016.\\3\u0011\u0005![U\"A%\u000b\u0005)s\u0011\u0001B;uS2L!\u0001T%\u0003\u0011\u0011+(/\u0019;j_:\fqBZ8s[\u0006$X\t_2faRLwN\u001c\u000b\u0005_=\u00036\fC\u0003<\u000b\u0001\u0007A\bC\u0003R\u000b\u0001\u0007!+A\u0005uQJ|w/\u00192mKB\u00111\u000b\u0017\b\u0003)Zs!AM+\n\u0003]I!a\u0016\f\u0002\u000fA\f7m[1hK&\u0011\u0011L\u0017\u0002\n)\"\u0014xn^1cY\u0016T!a\u0016\f\t\u000b\u0019+\u0001\u0019A$\u0002\u001b\u0019|'/\\1ui\u0016$G)\u0019;f)\u0005y\u0003")
public class CommonLogFormatter
implements LogFormatter {
    private final DateTimeFormatter DateFormat;

    @Override
    public String escape(String s) {
        return LogFormatter.escape$(this, s);
    }

    public DateTimeFormatter DateFormat() {
        return this.DateFormat;
    }

    public String format(Request request, Response response, Duration responseTime) {
        String remoteAddr = request.remoteAddress().getHostAddress();
        int contentLength = response.length();
        String contentLengthStr = contentLength > 0 ? Integer.toString(contentLength) : "-";
        String uaStr = (String)request.userAgent().getOrElse((Function0 & Serializable)() -> "-");
        StringBuilder builder = new StringBuilder();
        builder.append(remoteAddr);
        builder.append(" - - [");
        builder.append(this.formattedDate());
        builder.append("] \"");
        builder.append(this.escape(request.method().toString()));
        builder.append(' ');
        builder.append(this.escape(request.uri()));
        builder.append(' ');
        builder.append(this.escape(request.version().toString()));
        builder.append("\" ");
        builder.append(Integer.toString(response.statusCode()));
        builder.append(' ');
        builder.append(contentLengthStr);
        builder.append(' ');
        builder.append(responseTime.inMillis());
        builder.append(" \"");
        builder.append(this.escape(uaStr));
        builder.append('\"');
        return builder.toString();
    }

    public String formatException(Request request, Throwable throwable, Duration responseTime) {
        throw new UnsupportedOperationException("Log throwables as empty 500s instead");
    }

    public String formattedDate() {
        return ZonedDateTime.now().format(this.DateFormat());
    }

    public CommonLogFormatter() {
        LogFormatter.$init$(this);
        this.DateFormat = DateTimeFormatter.ofPattern("dd/MMM/yyyy:HH:mm:ss Z").withLocale(Locale.ENGLISH).withZone(ZoneId.of("GMT"));
    }
}

