/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.codec;

import com.twitter.finagle.http.codec.ChannelBufferUsageTracker;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.WriteCompletionEvent;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001U3A!\u0001\u0002\u0001\u001b\t!2\t[1o]\u0016d')\u001e4gKJl\u0015M\\1hKJT!a\u0001\u0003\u0002\u000b\r|G-Z2\u000b\u0005\u00151\u0011\u0001\u00025uiBT!a\u0002\u0005\u0002\u000f\u0019Lg.Y4mK*\u0011\u0011BC\u0001\bi^LG\u000f^3s\u0015\u0005Y\u0011aA2p[\u000e\u00011C\u0001\u0001\u000f!\ty\u0001$D\u0001\u0011\u0015\t\t\"#A\u0004dQ\u0006tg.\u001a7\u000b\u0005M!\u0012!\u00028fiRL(BA\u000b\u0017\u0003\u0015Q'm\\:t\u0015\u00059\u0012aA8sO&\u0011\u0011\u0004\u0005\u0002\u0015'&l\u0007\u000f\\3DQ\u0006tg.\u001a7IC:$G.\u001a:\t\u0011m\u0001!\u0011!Q\u0001\nq\tA\"^:bO\u0016$&/Y2lKJ\u0004\"!\b\u0010\u000e\u0003\tI!a\b\u0002\u00033\rC\u0017M\u001c8fY\n+hMZ3s+N\fw-\u001a+sC\u000e\\WM\u001d\u0005\u0006C\u0001!\tAI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\r\"\u0003CA\u000f\u0001\u0011\u0015Y\u0002\u00051\u0001\u001d\u0011\u00191\u0003\u0001)Q\u0005O\u0005Y!-\u001e4gKJ,6/Y4f!\tA3&D\u0001*\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0005\u0011auN\\4\t\u000b9\u0002A\u0011I\u0018\u0002\u001f5,7o]1hKJ+7-Z5wK\u0012$2\u0001M\u001a9!\tA\u0013'\u0003\u00023S\t!QK\\5u\u0011\u0015!T\u00061\u00016\u0003\r\u0019G\u000f\u001f\t\u0003\u001fYJ!a\u000e\t\u0003+\rC\u0017M\u001c8fY\"\u000bg\u000e\u001a7fe\u000e{g\u000e^3yi\")\u0011(\fa\u0001u\u0005\tQ\r\u0005\u0002\u0010w%\u0011A\b\u0005\u0002\r\u001b\u0016\u001c8/Y4f\u000bZ,g\u000e\u001e\u0005\u0006}\u0001!\teP\u0001\u000eoJLG/Z\"p[BdW\r^3\u0015\u0007A\u0002\u0015\tC\u00035{\u0001\u0007Q\u0007C\u0003:{\u0001\u0007!\t\u0005\u0002\u0010\u0007&\u0011A\t\u0005\u0002\u0015/JLG/Z\"p[BdW\r^5p]\u00163XM\u001c;\t\u000b\u0019\u0003A\u0011I$\u0002\u001b\rD\u0017M\u001c8fY\u000ecwn]3e)\r\u0001\u0004*\u0013\u0005\u0006i\u0015\u0003\r!\u000e\u0005\u0006s\u0015\u0003\rA\u0013\t\u0003\u001f-K!\u0001\u0014\t\u0003#\rC\u0017M\u001c8fYN#\u0018\r^3Fm\u0016tG\u000f\u0003\u0004O\u0001\u0001&IaT\u0001\u0014S:\u001c'/Z1tK\n+hMZ3s+N\fw-\u001a\u000b\u0003aACQ!U'A\u0002\u001d\nAa]5{K\"11\u000b\u0001Q\u0005\nQ\u000b\u0001c\u00197fCJ\u0014UO\u001a4feV\u001b\u0018mZ3\u0015\u0003A\u0002")
public class ChannelBufferManager
extends SimpleChannelHandler {
    private final ChannelBufferUsageTracker usageTracker;
    private long bufferUsage;

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
        Object object = e.getMessage();
        if (object instanceof ChannelBuffer) {
            ChannelBuffer channelBuffer = (ChannelBuffer)object;
            this.increaseBufferUsage(channelBuffer.capacity());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        super.messageReceived(ctx, e);
    }

    public void writeComplete(ChannelHandlerContext ctx, WriteCompletionEvent e) {
        this.clearBufferUsage();
        super.writeComplete(ctx, e);
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) {
        this.clearBufferUsage();
        super.channelClosed(ctx, e);
    }

    private void increaseBufferUsage(long size) {
        this.usageTracker.increase(size);
        this.bufferUsage += size;
    }

    private void clearBufferUsage() {
        this.usageTracker.decrease(this.bufferUsage);
        this.bufferUsage = 0L;
    }

    public ChannelBufferManager(ChannelBufferUsageTracker usageTracker) {
        this.usageTracker = usageTracker;
        this.bufferUsage = 0L;
    }
}

