/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http;

import com.twitter.collection.RecordSchema;
import com.twitter.finagle.http.Method$;
import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Version$;
import com.twitter.io.Reader;
import com.twitter.io.Writer;
import java.net.InetSocketAddress;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.handler.codec.embedder.DecoderEmbedder;
import org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.codec.http.QueryStringEncoder;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;

public final class Request$ {
    public static final Request$ MODULE$;
    private final RecordSchema Schema;

    static {
        new Request$();
    }

    public RecordSchema Schema() {
        return this.Schema;
    }

    public Request decodeString(String s) {
        return this.decodeBytes(s.getBytes("UTF-8"));
    }

    public Request decodeBytes(byte[] b) {
        DecoderEmbedder decoder = new DecoderEmbedder(new ChannelUpstreamHandler[]{new HttpRequestDecoder(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE)});
        decoder.offer((Object)ChannelBuffers.wrappedBuffer((byte[])b));
        HttpRequest httpRequest = (HttpRequest)decoder.poll();
        Predef$.MODULE$.assert(httpRequest != null);
        return this.apply(httpRequest);
    }

    public Request.MockRequest apply(Seq<Tuple2<String, String>> params) {
        return this.apply("/", params);
    }

    public Request.MockRequest apply(String uri, Seq<Tuple2<String, String>> params) {
        QueryStringEncoder encoder = new QueryStringEncoder(uri);
        params.foreach((Function1)new Serializable(encoder){
            public static final long serialVersionUID = 0L;
            private final QueryStringEncoder encoder$1;

            public final void apply(Tuple2<String, String> x0$2) {
                Tuple2<String, String> tuple2 = x0$2;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    this.encoder$1.addParam(key, value);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.encoder$1 = encoder$1;
            }
        });
        return this.apply(Method$.MODULE$.Get(), encoder.toString());
    }

    public Request.MockRequest apply(String uri) {
        return this.apply(Method$.MODULE$.Get(), uri);
    }

    public Request.MockRequest apply(HttpMethod method, String uri) {
        return this.apply(Version$.MODULE$.Http11(), method, uri);
    }

    public Request.MockRequest apply(HttpVersion version, HttpMethod method, String uri) {
        return this.apply((HttpRequest)new DefaultHttpRequest(version, method, uri));
    }

    public Request.MockRequest apply(HttpRequest httpRequestArg) {
        Request.MockRequest mockRequest;
        HttpRequest httpRequest = httpRequestArg;
        Request.MockRequest mockRequest2 = httpRequest instanceof Request.MockRequest ? (mockRequest = (Request.MockRequest)httpRequest) : new Request.MockRequest(httpRequestArg){
            private final HttpRequest httpRequest;
            private final HttpRequest httpMessage;
            private final InetSocketAddress remoteSocketAddress;

            public HttpRequest httpRequest() {
                return this.httpRequest;
            }

            public HttpRequest httpMessage() {
                return this.httpMessage;
            }

            public InetSocketAddress remoteSocketAddress() {
                return this.remoteSocketAddress;
            }
            {
                this.httpRequest = httpRequestArg$2;
                this.httpMessage = httpRequestArg$2;
                this.remoteSocketAddress = new InetSocketAddress("127.0.0.1", 12345);
            }
        };
        return mockRequest2;
    }

    public Request apply(HttpRequest httpRequestArg, Channel channel) {
        Request request;
        HttpRequest httpRequest = httpRequestArg;
        if (httpRequest instanceof Request) {
            Request request2 = (Request)httpRequest;
            request = new Request(channel, request2){
                private final Request httpRequest;
                private final Request httpMessage;
                private final InetSocketAddress remoteSocketAddress;
                private final Reader reader;
                private final Writer writer;

                public Request httpRequest() {
                    return this.httpRequest;
                }

                public Request httpMessage() {
                    return this.httpMessage;
                }

                public InetSocketAddress remoteSocketAddress() {
                    return this.remoteSocketAddress;
                }

                public Reader reader() {
                    return this.reader;
                }

                public Writer writer() {
                    return this.writer;
                }
                {
                    this.httpRequest = x2$1;
                    this.httpMessage = x2$1;
                    this.remoteSocketAddress = (InetSocketAddress)channel$1.getRemoteAddress();
                    this.reader = x2$1.reader();
                    this.writer = x2$1.writer();
                }
            };
        } else {
            request = new Request(httpRequestArg, channel){
                private final HttpRequest httpRequest;
                private final HttpRequest httpMessage;
                private final InetSocketAddress remoteSocketAddress;

                public HttpRequest httpRequest() {
                    return this.httpRequest;
                }

                public HttpRequest httpMessage() {
                    return this.httpMessage;
                }

                public InetSocketAddress remoteSocketAddress() {
                    return this.remoteSocketAddress;
                }
                {
                    this.httpRequest = httpRequestArg$1;
                    this.httpMessage = httpRequestArg$1;
                    this.remoteSocketAddress = (InetSocketAddress)channel$1.getRemoteAddress();
                }
            };
        }
        return request;
    }

    public String queryString(String uri, Seq<Tuple2<String, String>> params) {
        QueryStringEncoder encoder = new QueryStringEncoder(uri);
        params.foreach((Function1)new Serializable(encoder){
            public static final long serialVersionUID = 0L;
            private final QueryStringEncoder encoder$2;

            public final void apply(Tuple2<String, String> x0$3) {
                Tuple2<String, String> tuple2 = x0$3;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    this.encoder$2.addParam(key, value);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.encoder$2 = encoder$2;
            }
        });
        return encoder.toString();
    }

    public String queryString(Seq<Tuple2<String, String>> params) {
        return this.queryString("", params);
    }

    public String queryString(String uri, Map<String, String> params) {
        return this.queryString(uri, (Seq<Tuple2<String, String>>)params.toSeq());
    }

    public String queryString(Map<String, String> params) {
        return this.queryString("", (Seq<Tuple2<String, String>>)params.toSeq());
    }

    private Request$() {
        MODULE$ = this;
        this.Schema = new RecordSchema();
    }
}

