/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.filter;

import com.twitter.finagle.Service;
import com.twitter.finagle.ServiceFactory;
import com.twitter.finagle.SimpleFilter;
import com.twitter.finagle.Stack;
import com.twitter.finagle.Stackable;
import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Response;
import com.twitter.finagle.tracing.Trace$;
import com.twitter.finagle.tracing.Tracing;
import com.twitter.util.Future;
import scala.Function1;
import scala.Serializable;
import scala.runtime.BoxesRunTime;

public final class HttpTracingFilter$
extends SimpleFilter<Request, Response> {
    public static final HttpTracingFilter$ MODULE$;
    private final Stack.Role Role;

    static {
        new HttpTracingFilter$();
    }

    public Stack.Role Role() {
        return this.Role;
    }

    public Future<Response> apply(Request request, Service<Request, Response> service) {
        Tracing tracing = Trace$.MODULE$.apply();
        Future rep = service.apply((Object)request);
        this.traceHttpRequest(request, tracing);
        this.traceHttpResponse((Future<Response>)rep, tracing);
        return rep;
    }

    public void traceHttpRequest(Request request, Tracing tracing) {
        if (tracing.isActivelyTracing()) {
            tracing.recordRpc(request.method().toString());
            tracing.recordBinary("http.method", (Object)request.method().toString());
            tracing.recordBinary("http.uri", (Object)this.stripParameters(request.uri()));
        }
    }

    public void traceHttpResponse(Future<Response> rep, Tracing tracing) {
        if (tracing.isActivelyTracing()) {
            rep.onSuccess((Function1)new Serializable(tracing){
                public static final long serialVersionUID = 0L;
                private final Tracing tracing$1;

                public final void apply(Response r) {
                    this.tracing$1.recordBinary("http.status_code", (Object)BoxesRunTime.boxToInteger((int)r.statusCode()));
                }
                {
                    this.tracing$1 = tracing$1;
                }
            });
        }
    }

    private String stripParameters(String uri) {
        String string;
        int n = uri.indexOf(63);
        switch (n) {
            default: {
                string = uri.substring(0, n);
                break;
            }
            case -1: {
                string = uri;
            }
        }
        return string;
    }

    public Stackable<ServiceFactory<Request, Response>> module() {
        return new Stack.Module0<ServiceFactory<Request, Response>>(){
            private final Stack.Role role;
            private final String description;

            public Stack.Role role() {
                return this.role;
            }

            public String description() {
                return this.description;
            }

            public ServiceFactory<Request, Response> make(ServiceFactory<Request, Response> next) {
                return HttpTracingFilter$.MODULE$.andThen(next);
            }
            {
                this.role = HttpTracingFilter$.MODULE$.Role();
                this.description = "Record http annotation for completed spans";
            }
        };
    }

    private HttpTracingFilter$() {
        MODULE$ = this;
        this.Role = new Stack.Role("HttpTracing");
    }
}

