/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.filter;

import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Response;
import com.twitter.finagle.http.filter.LogFormatter;
import com.twitter.finagle.http.filter.LogFormatter$class;
import com.twitter.util.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import scala.Function0;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t4A!\u0001\u0002\u0001\u001b\t\u00112i\\7n_:dun\u001a$pe6\fG\u000f^3s\u0015\t\u0019A!\u0001\u0004gS2$XM\u001d\u0006\u0003\u000b\u0019\tA\u0001\u001b;ua*\u0011q\u0001C\u0001\bM&t\u0017m\u001a7f\u0015\tI!\"A\u0004uo&$H/\u001a:\u000b\u0003-\t1aY8n\u0007\u0001\u00192\u0001\u0001\b\u0015!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011QCF\u0007\u0002\u0005%\u0011qC\u0001\u0002\r\u0019><gi\u001c:nCR$XM\u001d\u0005\u00063\u0001!\tAG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"!\u0006\u0001\t\u000fu\u0001!\u0019!C\u0001=\u0005QA)\u0019;f\r>\u0014X.\u0019;\u0016\u0003}\u0001\"\u0001I\u0014\u000e\u0003\u0005R!AI\u0012\u0002\r\u0019|'/\\1u\u0015\t!S%\u0001\u0003uS6,'\"\u0001\u0014\u0002\t)\fg/Y\u0005\u0003Q\u0005\u0012\u0011\u0003R1uKRKW.\u001a$pe6\fG\u000f^3s\u0011\u0019Q\u0003\u0001)A\u0005?\u0005YA)\u0019;f\r>\u0014X.\u0019;!\u0011\u0015\u0011\u0003\u0001\"\u0001-)\u0011i3'\u000f \u0011\u00059\nT\"A\u0018\u000b\u0005A*\u0013\u0001\u00027b]\u001eL!AM\u0018\u0003\rM#(/\u001b8h\u0011\u0015!4\u00061\u00016\u0003\u001d\u0011X-];fgR\u0004\"AN\u001c\u000e\u0003\u0011I!\u0001\u000f\u0003\u0003\u000fI+\u0017/^3ti\")!h\u000ba\u0001w\u0005A!/Z:q_:\u001cX\r\u0005\u00027y%\u0011Q\b\u0002\u0002\t%\u0016\u001c\bo\u001c8tK\")qh\u000ba\u0001\u0001\u0006a!/Z:q_:\u001cX\rV5nKB\u0011\u0011\tR\u0007\u0002\u0005*\u00111\tC\u0001\u0005kRLG.\u0003\u0002F\u0005\nAA)\u001e:bi&|g\u000eC\u0003H\u0001\u0011\u0005\u0001*A\bg_Jl\u0017\r^#yG\u0016\u0004H/[8o)\u0011Iu\n\u00150\u0011\u0005)keBA\bL\u0013\ta\u0005#\u0001\u0004Qe\u0016$WMZ\u0005\u0003e9S!\u0001\u0014\t\t\u000bQ2\u0005\u0019A\u001b\t\u000bE3\u0005\u0019\u0001*\u0002\u0013QD'o\\<bE2,\u0007CA*\\\u001d\t!\u0016L\u0004\u0002V16\taK\u0003\u0002X\u0019\u00051AH]8pizJ\u0011!E\u0005\u00035B\tq\u0001]1dW\u0006<W-\u0003\u0002];\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u00035BAQa\u0010$A\u0002\u0001CQ\u0001\u0019\u0001\u0005\u0002\u0005\fQBZ8s[\u0006$H/\u001a3ECR,G#A%")
public class CommonLogFormatter
implements LogFormatter {
    private final DateTimeFormatter DateFormat;

    @Override
    public String escape(String s) {
        return LogFormatter$class.escape(this, s);
    }

    public DateTimeFormatter DateFormat() {
        return this.DateFormat;
    }

    public String format(Request request, Response response, Duration responseTime) {
        String remoteAddr = request.remoteAddress().getHostAddress();
        int contentLength = response.length();
        String contentLengthStr = contentLength > 0 ? ((Object)BoxesRunTime.boxToInteger((int)contentLength)).toString() : "-";
        String uaStr = (String)request.userAgent().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "-";
            }
        });
        StringBuilder builder = new StringBuilder();
        builder.append(remoteAddr);
        builder.append(" - - [");
        builder.append(this.formattedDate());
        builder.append("] \"");
        builder.append(this.escape(request.method().toString()));
        builder.append(' ');
        builder.append(this.escape(request.uri()));
        builder.append(' ');
        builder.append(this.escape(request.version().toString()));
        builder.append("\" ");
        builder.append(((Object)BoxesRunTime.boxToInteger((int)response.statusCode())).toString());
        builder.append(' ');
        builder.append(contentLengthStr);
        builder.append(' ');
        builder.append(responseTime.inMillis());
        builder.append(" \"");
        builder.append(this.escape(uaStr));
        builder.append('\"');
        return builder.toString();
    }

    public String formatException(Request request, Throwable throwable, Duration responseTime) {
        throw new UnsupportedOperationException("Log throwables as empty 500s instead");
    }

    public String formattedDate() {
        return ZonedDateTime.now().format(this.DateFormat());
    }

    public CommonLogFormatter() {
        LogFormatter$class.$init$(this);
        this.DateFormat = DateTimeFormatter.ofPattern("dd/MMM/yyyy:HH:mm:ss Z").withLocale(Locale.ENGLISH).withZone(ZoneId.of("GMT"));
    }
}

