/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http2.transport.client;

import com.twitter.finagle.Service;
import com.twitter.finagle.Status;
import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Response;
import com.twitter.finagle.http.exp.StreamTransport;
import com.twitter.finagle.http2.transport.client.ClientSession;
import com.twitter.finagle.http2.transport.client.Http2ClientDispatcher;
import com.twitter.finagle.http2.transport.client.Http2Transport;
import com.twitter.finagle.netty4.http.Netty4ClientStreamTransport;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.finagle.transport.Transport;
import com.twitter.util.Future;
import com.twitter.util.Future$;
import com.twitter.util.Return;
import com.twitter.util.Throw;
import com.twitter.util.Time;
import com.twitter.util.Try;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005E4AAC\u0006\u00071!Aa\u0005\u0001B\u0001B\u0003%q\u0005\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003-\u0011!\t\u0004A!A!\u0002\u0013\u0011\u0004\"\u0002!\u0001\t\u0003\t\u0005\"\u0002$\u0001\t\u0003:\u0005\"B&\u0001\t\u0003a\u0005BB+\u0001A\u0013%a\u000bC\u0003Z\u0001\u0011\u0005#\fC\u0003e\u0001\u0011\u0005SMA\tDY&,g\u000e^*feZL7-Z%na2T!\u0001D\u0007\u0002\r\rd\u0017.\u001a8u\u0015\tqq\"A\u0005ue\u0006t7\u000f]8si*\u0011\u0001#E\u0001\u0006QR$\bO\r\u0006\u0003%M\tqAZ5oC\u001edWM\u0003\u0002\u0015+\u00059Ao^5ui\u0016\u0014(\"\u0001\f\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001I\u0002\u0003\u0002\u000e\u001c;\rj\u0011!E\u0005\u00039E\u0011qaU3sm&\u001cW\r\u0005\u0002\u001fC5\tqD\u0003\u0002!#\u0005!\u0001\u000e\u001e;q\u0013\t\u0011sDA\u0004SKF,Xm\u001d;\u0011\u0005y!\u0013BA\u0013 \u0005!\u0011Vm\u001d9p]N,\u0017aB:fgNLwN\u001c\t\u0003Q%j\u0011aC\u0005\u0003U-\u0011Qb\u00117jK:$8+Z:tS>t\u0017!B:uCR\u001c\bCA\u00170\u001b\u0005q#BA\u0016\u0012\u0013\t\u0001dFA\u0007Ti\u0006$8OU3dK&4XM]\u0001\t[>$\u0017NZ5feB!1G\u000e\u001d9\u001b\u0005!$\"A\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]\"$!\u0003$v]\u000e$\u0018n\u001c82!\u0011I4(P\u001f\u000e\u0003iR!AD\t\n\u0005qR$!\u0003+sC:\u001c\bo\u001c:u!\t\u0019d(\u0003\u0002@i\t\u0019\u0011I\\=\u0002\rqJg.\u001b;?)\u0011\u00115\tR#\u0011\u0005!\u0002\u0001\"\u0002\u0014\u0005\u0001\u00049\u0003\"B\u0016\u0005\u0001\u0004a\u0003\"B\u0019\u0005\u0001\u0004\u0011\u0014AB:uCR,8/F\u0001I!\tQ\u0012*\u0003\u0002K#\t11\u000b^1ukN\fQ!\u00199qYf$\"!T*\u0011\u00079\u000b6%D\u0001P\u0015\t\u00016#\u0001\u0003vi&d\u0017B\u0001*P\u0005\u00191U\u000f^;sK\")AK\u0002a\u0001;\u00059!/Z9vKN$\u0018!C7l'\u0016\u0014h/[2f)\tIr\u000bC\u0003Y\u000f\u0001\u0007\u0001(A\u0003ue\u0006t7/A\u0003dY>\u001cX\r\u0006\u0002\\?B\u0019a*\u0015/\u0011\u0005Mj\u0016B\u000105\u0005\u0011)f.\u001b;\t\u000b\u0001D\u0001\u0019A1\u0002\u0011\u0011,\u0017\r\u001a7j]\u0016\u0004\"A\u00142\n\u0005\r|%\u0001\u0002+j[\u0016\f\u0001\u0002^8TiJLgn\u001a\u000b\u0002MB\u0011qM\u001c\b\u0003Q2\u0004\"!\u001b\u001b\u000e\u0003)T!a[\f\u0002\rq\u0012xn\u001c;?\u0013\tiG'\u0001\u0004Qe\u0016$WMZ\u0005\u0003_B\u0014aa\u0015;sS:<'BA75\u0001")
public final class ClientServiceImpl
extends Service<Request, Response> {
    private final ClientSession session;
    private final StatsReceiver stats;
    private final Function1<Transport<Object, Object>, Transport<Object, Object>> modifier;

    public Status status() {
        return this.session.status();
    }

    public Future<Response> apply(Request request) {
        return this.session.newChildTransport().transform((Function1 & Serializable)x0$1 -> {
            Future future;
            Try try_ = x0$1;
            if (try_ instanceof Return) {
                Return return_ = (Return)try_;
                Transport trans = (Transport)return_.r();
                Service<Request, Response> svc = this.mkService((Transport<Object, Object>)trans);
                future = svc.apply((Object)request);
            } else if (try_ instanceof Throw) {
                Throw throw_ = (Throw)try_;
                future = Future$.MODULE$.const(throw_.cast());
            } else {
                throw new MatchError((Object)try_);
            }
            return future;
        });
    }

    private Service<Request, Response> mkService(Transport<Object, Object> trans) {
        Netty4ClientStreamTransport streamTransport = new Netty4ClientStreamTransport((Transport)this.modifier.apply(trans));
        Http2Transport httpTransport = new Http2Transport(streamTransport);
        return new Http2ClientDispatcher((StreamTransport<Request, Response>)httpTransport, this.stats);
    }

    public Future<BoxedUnit> close(Time deadline) {
        return this.session.close(deadline);
    }

    public String toString() {
        return new StringBuilder(2).append(this.getClass().getSimpleName()).append("(").append(this.session).append(")").toString();
    }

    public ClientServiceImpl(ClientSession session, StatsReceiver stats, Function1<Transport<Object, Object>, Transport<Object, Object>> modifier) {
        this.session = session;
        this.stats = stats;
        this.modifier = modifier;
    }
}

