/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http2.transport.client;

import com.twitter.finagle.Service;
import com.twitter.finagle.Stack;
import com.twitter.finagle.client.Transporter;
import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Response;
import com.twitter.finagle.http2.transport.client.ClientServiceImpl;
import com.twitter.finagle.http2.transport.client.ClientSession;
import com.twitter.finagle.http2.transport.client.DeferredCloseSession;
import com.twitter.finagle.http2.transport.client.H2Pool;
import com.twitter.finagle.http2.transport.client.H2Pool$OnH2ServiceParam$;
import com.twitter.finagle.http2.transport.client.SingleDispatchTransport;
import com.twitter.finagle.http2.transport.client.TlsTransporter$;
import com.twitter.finagle.netty4.ConnectionBuilder;
import com.twitter.finagle.param.Stats;
import com.twitter.finagle.param.Stats$;
import com.twitter.finagle.stats.Counter;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.finagle.transport.Transport;
import com.twitter.finagle.transport.TransportContext;
import com.twitter.util.Future;
import com.twitter.util.Future$;
import com.twitter.util.Return;
import com.twitter.util.Throw;
import com.twitter.util.Try;
import io.netty.channel.Channel;
import io.netty.handler.ssl.SslHandler;
import java.io.Serializable;
import java.net.SocketAddress;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dd!\u0002\u000b\u0016\u0001e\t\u0003\u0002C\u001b\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\t\u0011u\u0002!\u0011!Q\u0001\nyB\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\u0006\u001b\u0002!IA\u0014\u0005\u0007)\u0002\u0001\u000b\u0011B+\t\rm\u0003\u0001\u0015!\u0003]\u0011\u0019y\u0006\u0001)A\u0005A\")q\r\u0001C\u0001Q\")\u0011\u000f\u0001C\u0001e\"1\u0011\u0010\u0001Q\u0005\niD\u0001\"a\n\u0001A\u0013%\u0011\u0011F\u0004\b\u0003[)\u0002\u0012AA\u0018\r\u0019!R\u0003#\u0001\u00022!1Q*\u0004C\u0001\u0003gA\u0011\"!\u000e\u000e\u0005\u0004%I!a\u000e\t\u0011\u0005\rS\u0002)A\u0005\u0003sAq!!\u0012\u000e\t\u0003\t9\u0005C\u0004\u0002R5!I!a\u0015\t\u000f\u0005}S\u0002\"\u0003\u0002b\tqA\u000b\\:Ue\u0006t7\u000f]8si\u0016\u0014(B\u0001\f\u0018\u0003\u0019\u0019G.[3oi*\u0011\u0001$G\u0001\niJ\fgn\u001d9peRT!AG\u000e\u0002\u000b!$H\u000f\u001d\u001a\u000b\u0005qi\u0012a\u00024j]\u0006<G.\u001a\u0006\u0003=}\tq\u0001^<jiR,'OC\u0001!\u0003\r\u0019w.\\\n\u0004\u0001\tB\u0003CA\u0012'\u001b\u0005!#\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"#AB!osJ+g\rE\u0003*W5j\u0003'D\u0001+\u0015\t12$\u0003\u0002-U\tYAK]1ogB|'\u000f^3s!\t\u0019c&\u0003\u00020I\t\u0019\u0011I\\=\u0011\u0005E\u001aT\"\u0001\u001a\u000b\u0005aY\u0012B\u0001\u001b3\u0005A!&/\u00198ta>\u0014HoQ8oi\u0016DH/A\td_:tWm\u0019;j_:\u0014U/\u001b7eKJ\u001c\u0001\u0001\u0005\u00029w5\t\u0011H\u0003\u0002;7\u00051a.\u001a;usRJ!\u0001P\u001d\u0003#\r{gN\\3di&|gNQ;jY\u0012,'/\u0001\u0005n_\u0012Lg-[3s!\u0011\u0019s(Q!\n\u0005\u0001##!\u0003$v]\u000e$\u0018n\u001c82!\u0011\t$)L\u0017\n\u0005\r\u0013$!\u0003+sC:\u001c\bo\u001c:u\u0003\u0019\u0001\u0018M]1ngB\u0011aI\u0013\b\u0003\u000f\"k\u0011aG\u0005\u0003\u0013n\tQa\u0015;bG.L!a\u0013'\u0003\rA\u000b'/Y7t\u0015\tI5$\u0001\u0004=S:LGO\u0010\u000b\u0005\u001fF\u00136\u000b\u0005\u0002Q\u00015\tQ\u0003C\u00036\t\u0001\u0007q\u0007C\u0003>\t\u0001\u0007a\bC\u0003E\t\u0001\u0007Q)A\u0007ti\u0006$8OU3dK&4XM\u001d\t\u0003-fk\u0011a\u0016\u0006\u00031n\tQa\u001d;biNL!AW,\u0003\u001bM#\u0018\r^:SK\u000e,\u0017N^3s\u00039)\bo\u001a:bI\u0016\u001cu.\u001e8uKJ\u0004\"AV/\n\u0005y;&aB\"pk:$XM]\u0001\f_:D%gU3sm&\u001cW\r\u0005\u0002bI:\u0011\u0001KY\u0005\u0003GV\ta\u0001\u0013\u001aQ_>d\u0017BA3g\u0005-ye\u000e\u0013\u001aTKJ4\u0018nY3\u000b\u0005\r,\u0012!\u0004:f[>$X-\u00113ee\u0016\u001c8/F\u0001j!\tQw.D\u0001l\u0015\taW.A\u0002oKRT\u0011A\\\u0001\u0005U\u00064\u0018-\u0003\u0002qW\ni1k\\2lKR\fE\r\u001a:fgN\fQ!\u00199qYf$\u0012a\u001d\t\u0004i^\fU\"A;\u000b\u0005Yl\u0012\u0001B;uS2L!\u0001_;\u0003\r\u0019+H/\u001e:f\u0003%ygnQ8o]\u0016\u001cG\u000f\u0006\u0003tw\u00065\u0001\"\u0002?\u000b\u0001\u0004i\u0018aB2iC:tW\r\u001c\t\u0004}\u0006%Q\"A@\u000b\u0007q\f\tA\u0003\u0003\u0002\u0004\u0005\u0015\u0011!\u00028fiRL(BAA\u0004\u0003\tIw.C\u0002\u0002\f}\u0014qa\u00115b]:,G\u000eC\u0004\u0002\u0010)\u0001\r!!\u0005\u0002\u0011A\u0014x\u000e^8d_2\u0004B!a\u0005\u0002\"9!\u0011QCA\u000f!\r\t9\u0002J\u0007\u0003\u00033Q1!a\u00077\u0003\u0019a$o\\8u}%\u0019\u0011q\u0004\u0013\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019#!\n\u0003\rM#(/\u001b8h\u0015\r\ty\u0002J\u0001\u0010Q\u0006tG\r\\3IeU\u0003xM]1eKR\u00191/a\u000b\t\u000bq\\\u0001\u0019A?\u0002\u001dQc7\u000f\u0016:b]N\u0004xN\u001d;feB\u0011\u0001+D\n\u0003\u001b\t\"\"!a\f\u0002\u001f\u0011+g-Y;miB\u0013x\u000e^8d_2,\"!!\u000f\u0011\t\u0005m\u0012\u0011I\u0007\u0003\u0003{Q1!a\u0010n\u0003\u0011a\u0017M\\4\n\t\u0005\r\u0012QH\u0001\u0011\t\u00164\u0017-\u001e7u!J|Go\\2pY\u0002\nA!\\1lKR9\u0001&!\u0013\u0002N\u0005=\u0003BBA&#\u0001\u0007\u0011.\u0001\u0003bI\u0012\u0014\b\"B\u001f\u0012\u0001\u0004q\u0004\"\u0002#\u0012\u0001\u0004)\u0015AF2p]\u001aLw-\u001e:f\u0011R$\bO\r)ja\u0016d\u0017N\\3\u0015\r\u0005U\u00131LA/!\r\u0001\u0016qK\u0005\u0004\u00033*\"!D\"mS\u0016tGoU3tg&|g\u000eC\u0003}%\u0001\u0007Q\u0010C\u0003E%\u0001\u0007Q)\u0001\fd_:4\u0017nZ;sK\"#H\u000f]\u0019QSB,G.\u001b8f)\u0015\t\u00151MA3\u0011\u0015a8\u00031\u0001~\u0011\u0015!5\u00031\u0001F\u0001")
public class TlsTransporter
implements Transporter<Object, Object, TransportContext> {
    private final ConnectionBuilder connectionBuilder;
    private final Function1<Transport<Object, Object>, Transport<Object, Object>> modifier;
    private final Stack.Params params;
    private final StatsReceiver statsReceiver;
    private final Counter upgradeCounter;
    private final Function1<Service<Request, Response>, BoxedUnit> onH2Service;

    public static Transporter<Object, Object, TransportContext> make(SocketAddress socketAddress, Function1<Transport<Object, Object>, Transport<Object, Object>> function1, Stack.Params params) {
        return TlsTransporter$.MODULE$.make(socketAddress, function1, params);
    }

    public SocketAddress remoteAddress() {
        return this.connectionBuilder.remoteAddress();
    }

    public Future<Transport<Object, Object>> apply() {
        return this.connectionBuilder.build((Function1 & Serializable)channel -> {
            SslHandler sslHandler = (SslHandler)channel.pipeline().get(SslHandler.class);
            String proto = sslHandler.applicationProtocol();
            return this.onConnect((Channel)channel, proto == null ? TlsTransporter$.MODULE$.com$twitter$finagle$http2$transport$client$TlsTransporter$$DefaultProtocol() : proto);
        });
    }

    private Future<Transport<Object, Object>> onConnect(Channel channel, String protocol) {
        Future future;
        String string = protocol;
        if ("h2".equals(string)) {
            future = this.handleH2Upgrade(channel);
        } else if ("http/1.1".equals(string)) {
            future = Future$.MODULE$.value(TlsTransporter$.MODULE$.com$twitter$finagle$http2$transport$client$TlsTransporter$$configureHttp1Pipeline(channel, this.params));
        } else {
            channel.close();
            throw new IllegalStateException(new StringBuilder(18).append("unknown protocol: ").append(protocol).toString());
        }
        return future;
    }

    /*
     * WARNING - void declaration
     */
    private Future<Transport<Object, Object>> handleH2Upgrade(Channel channel) {
        void var3_3;
        this.upgradeCounter.incr();
        ClientSession session = TlsTransporter$.MODULE$.com$twitter$finagle$http2$transport$client$TlsTransporter$$configureHttp2Pipeline(channel, this.params);
        Future childTransport = session.newChildTransport().map((Function1 & Serializable)x$1 -> new SingleDispatchTransport((Transport<Object, Object>)x$1));
        childTransport.respond((Function1 & Serializable)x0$1 -> {
            TlsTransporter.$anonfun$handleH2Upgrade$2(this, session, x0$1);
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    public static final /* synthetic */ void $anonfun$handleH2Upgrade$2(TlsTransporter $this, ClientSession session$1, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Return) {
            Return return_ = (Return)try_;
            SingleDispatchTransport t = (SingleDispatchTransport)((Object)return_.r());
            DeferredCloseSession dSession = new DeferredCloseSession(session$1, (Future<BoxedUnit>)t.onClose().unit());
            BoxedUnit boxedUnit = (BoxedUnit)$this.onH2Service.apply((Object)new ClientServiceImpl(dSession, $this.statsReceiver, $this.modifier));
        } else if (try_ instanceof Throw) {
            session$1.close();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public TlsTransporter(ConnectionBuilder connectionBuilder, Function1<Transport<Object, Object>, Transport<Object, Object>> modifier, Stack.Params params) {
        Function1 s;
        this.connectionBuilder = connectionBuilder;
        this.modifier = modifier;
        this.params = params;
        this.statsReceiver = ((Stats)params.apply(Stats$.MODULE$.param())).statsReceiver();
        this.upgradeCounter = this.statsReceiver.scope("upgrade").counter((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"success"}));
        Option<Function1<Service<Request, Response>, BoxedUnit>> option = ((H2Pool.OnH2ServiceParam)params.apply(H2Pool$OnH2ServiceParam$.MODULE$.param())).onH2Service();
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalStateException(new StringBuilder(23).append("params are missing the ").append(Function1.class.getSimpleName()).toString());
            }
            throw new MatchError(option);
        }
        Some some = (Some)option;
        Function1 function1 = s = (Function1)some.value();
        this.onH2Service = function1;
    }
}

