/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http2.transport;

import com.twitter.finagle.http2.transport.Http2ClientDowngrader;
import com.twitter.finagle.http2.transport.Http2ClientDowngrader$Ping$;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.Http2EventAdapter;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.HttpConversionUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import scala.math.package$;

public final class Http2ClientDowngrader$
extends Http2EventAdapter {
    public static final Http2ClientDowngrader$ MODULE$;
    private final ByteBuf HeaderTooLargeBytes;

    static {
        new Http2ClientDowngrader$();
    }

    public ByteBuf HeaderTooLargeBytes() {
        return this.HeaderTooLargeBytes;
    }

    public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) {
        int length = data.readableBytes();
        data.retain();
        DefaultLastHttpContent msg = endOfStream ? new DefaultLastHttpContent(data) : new DefaultHttpContent(data);
        ctx.fireChannelRead((Object)new Http2ClientDowngrader.Message((HttpObject)msg, streamId));
        return length + padding;
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endOfStream) {
        FullHttpResponse fullHttpResponse;
        if (endOfStream) {
            fullHttpResponse = HttpConversionUtil.toHttpResponse((int)streamId, (Http2Headers)headers, (ByteBufAllocator)ctx.alloc(), (boolean)false);
        } else {
            HttpResponseStatus status = HttpConversionUtil.parseStatus((CharSequence)headers.status());
            DefaultHttpResponse msg = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status, false);
            HttpConversionUtil.addHttp2ToHttpHeaders((int)streamId, (Http2Headers)headers, (HttpHeaders)msg.headers(), (HttpVersion)HttpVersion.HTTP_1_1, (boolean)false, (boolean)false);
            fullHttpResponse = msg;
        }
        FullHttpResponse msg = fullHttpResponse;
        ctx.fireChannelRead((Object)new Http2ClientDowngrader.Message((HttpObject)msg, streamId));
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers newHeaders, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) {
        this.onHeadersRead(ctx, streamId, newHeaders, padding, endOfStream);
    }

    public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) {
        ctx.fireChannelRead((Object)new Http2ClientDowngrader.Rst(streamId, errorCode));
    }

    public void onGoAwayRead(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debug) {
        ByteBuf sliced;
        int idx = debug.readerIndex();
        ByteBuf byteBuf = sliced = debug.slice(idx, package$.MODULE$.min(idx + this.HeaderTooLargeBytes().readableBytes(), idx + debug.readableBytes()));
        ByteBuf byteBuf2 = this.HeaderTooLargeBytes();
        HttpResponseStatus status = !(byteBuf != null ? !byteBuf.equals(byteBuf2) : byteBuf2 != null) ? HttpResponseStatus.REQUEST_HEADER_FIELDS_TOO_LARGE : HttpResponseStatus.BAD_REQUEST;
        DefaultFullHttpResponse rep = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status);
        ctx.fireChannelRead((Object)new Http2ClientDowngrader.GoAway((HttpObject)rep, lastStreamId, errorCode));
    }

    public void onPingAckRead(ChannelHandlerContext ctx, ByteBuf data) {
        ctx.fireChannelRead((Object)Http2ClientDowngrader$Ping$.MODULE$);
    }

    private Http2ClientDowngrader$() {
        MODULE$ = this;
        this.HeaderTooLargeBytes = Unpooled.copiedBuffer((CharSequence)"Header size exceeded max allowed bytes", (Charset)StandardCharsets.UTF_8);
    }
}

