/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http2.transport;

import com.twitter.finagle.http2.transport.Http2ClientDowngrader;
import com.twitter.finagle.http2.transport.Http2ClientDowngrader$Ping$;
import com.twitter.logging.Logger;
import com.twitter.logging.Logger$;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandler;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001U4Q!\u0001\u0002\u0001\t1\u0011\u0001EU5dQ\"#H\u000f\u001d+p\u0011R$\bOM\"p]:,7\r^5p]\"\u000bg\u000e\u001a7fe*\u00111\u0001B\u0001\niJ\fgn\u001d9peRT!!\u0002\u0004\u0002\u000b!$H\u000f\u001d\u001a\u000b\u0005\u001dA\u0011a\u00024j]\u0006<G.\u001a\u0006\u0003\u0013)\tq\u0001^<jiR,'OC\u0001\f\u0003\r\u0019w.\\\n\u0003\u00015\u0001\"A\u0004\r\u000e\u0003=Q!!\u0002\t\u000b\u0005E\u0011\u0012!B2pI\u0016\u001c'BA\n\u0015\u0003\u001dA\u0017M\u001c3mKJT!!\u0006\f\u0002\u000b9,G\u000f^=\u000b\u0003]\t!![8\n\u0005ey!\u0001\b%uiB$v\u000e\u0013;uaJ\u001auN\u001c8fGRLwN\u001c%b]\u0012dWM\u001d\u0005\t7\u0001\u0011\t\u0011)A\u0005;\u0005\u0019A-Z2\u0004\u0001A\u0011aBH\u0005\u0003?=\u0011a\u0003\u0013;uaJ\u001auN\u001c8fGRLwN\u001c#fG>$WM\u001d\u0005\tC\u0001\u0011\t\u0011)A\u0005E\u0005\u0019QM\\2\u0011\u00059\u0019\u0013B\u0001\u0013\u0010\u0005YAE\u000f\u001e93\u0007>tg.Z2uS>tWI\\2pI\u0016\u0014\b\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\u0002\u001f%t\u0017\u000e^5bYN+G\u000f^5oON\u0004\"A\u0004\u0015\n\u0005%z!!\u0004%uiB\u00144+\u001a;uS:<7\u000f\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003-\u0003!yg.Q2uSZ,\u0007cA\u00171e5\taFC\u00010\u0003\u0015\u00198-\u00197b\u0013\t\tdFA\u0005Gk:\u001cG/[8oaA\u0011QfM\u0005\u0003i9\u0012A!\u00168ji\")a\u0007\u0001C\u0001o\u00051A(\u001b8jiz\"R\u0001\u000f\u001e<yu\u0002\"!\u000f\u0001\u000e\u0003\tAQaG\u001bA\u0002uAQ!I\u001bA\u0002\tBQAJ\u001bA\u0002\u001dBQaK\u001bA\u00021Baa\u0010\u0001!\u0002\u0013\u0001\u0015a\u00017pOB\u0011\u0011\tR\u0007\u0002\u0005*\u00111\tC\u0001\bY><w-\u001b8h\u0013\t)%I\u0001\u0004M_\u001e<WM\u001d\u0005\u0007\u000f\u0002\u0001K\u0011\u0002%\u0002\u001b!\fg\u000e\u001a7f\u001b\u0016\u001c8/Y4f)\u0015\u0011\u0014*\u0015,_\u0011\u0015Qe\t1\u0001L\u0003\r\u0019G\u000f\u001f\t\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001dR\tqa\u00195b]:,G.\u0003\u0002Q\u001b\n)2\t[1o]\u0016d\u0007*\u00198eY\u0016\u00148i\u001c8uKb$\b\"\u0002*G\u0001\u0004\u0019\u0016a\u00029s_6L7/\u001a\t\u0003\u0019RK!!V'\u0003\u001d\rC\u0017M\u001c8fYB\u0013x.\\5tK\")qK\u0012a\u00011\u0006\u0019Qn]4\u0011\u0005ecV\"\u0001.\u000b\u0005m\u0003\u0012\u0001\u00025uiBL!!\u0018.\u0003\u0015!#H\u000f](cU\u0016\u001cG\u000fC\u0003`\r\u0002\u0007\u0001-\u0001\u0005tiJ,\u0017-\\%e!\ti\u0013-\u0003\u0002c]\t\u0019\u0011J\u001c;\t\u000b\u0011\u0004A\u0011I3\u0002\u000b]\u0014\u0018\u000e^3\u0015\tI2w\r\u001d\u0005\u0006\u0015\u000e\u0004\ra\u0013\u0005\u0006/\u000e\u0004\r\u0001\u001b\t\u0003S:l\u0011A\u001b\u0006\u0003W2\fA\u0001\\1oO*\tQ.\u0001\u0003kCZ\f\u0017BA8k\u0005\u0019y%M[3di\")!k\u0019a\u0001'\")!\u000f\u0001C!g\u0006a\u0001.\u00198eY\u0016\u0014\u0018\t\u001a3fIR\u0011!\u0007\u001e\u0005\u0006\u0015F\u0004\ra\u0013")
public class RichHttpToHttp2ConnectionHandler
extends HttpToHttp2ConnectionHandler {
    private final Function0<BoxedUnit> onActive;
    private final Logger log;

    private void handleMessage(ChannelHandlerContext ctx, ChannelPromise promise, HttpObject msg, int streamId) {
        try {
            BoxedUnit boxedUnit;
            PromiseCombiner combiner = new PromiseCombiner();
            HttpObject httpObject = msg;
            if (httpObject instanceof HttpRequest) {
                FullHttpRequest fullHttpRequest;
                HttpRequest httpRequest = (HttpRequest)httpObject;
                Http2Headers headers = HttpConversionUtil.toHttp2Headers((HttpMessage)httpRequest, (boolean)false);
                HttpRequest httpRequest2 = httpRequest;
                boolean bl = httpRequest2 instanceof FullHttpRequest && !(fullHttpRequest = (FullHttpRequest)httpRequest2).content().isReadable();
                boolean endStream = bl;
                ChannelPromise p = ctx.newPromise();
                combiner.add((Promise)p);
                HttpHeaders http1Headers = httpRequest.headers();
                int dependencyId = http1Headers.getInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_DEPENDENCY_ID.text(), 0);
                short weight = http1Headers.getShort((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_WEIGHT.text(), (short)16);
                this.encoder().writeHeaders(ctx, streamId, headers, dependencyId, weight, false, 0, endStream, p);
                if (p.isDone() && !p.isSuccess()) {
                    throw p.cause();
                }
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
            }
            HttpObject httpObject2 = msg;
            if (httpObject2 instanceof HttpContent) {
                BoxedUnit boxedUnit4;
                HttpContent httpContent = (HttpContent)httpObject2;
                ByteBuf data = httpContent.content();
                boolean endStream = httpContent instanceof LastHttpContent;
                if (data.isReadable() || endStream && !(httpContent instanceof HttpRequest)) {
                    ChannelPromise p = ctx.newPromise();
                    combiner.add((Promise)p);
                    boxedUnit4 = this.encoder().writeData(ctx, streamId, data, 0, endStream, p);
                } else {
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit4;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            combiner.finish((Promise)promise);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof Http2Exception) {
                Http2Exception http2Exception = (Http2Exception)throwable2;
                HttpResponseStatus status = http2Exception instanceof Http2Exception.HeaderListSizeException ? HttpResponseStatus.REQUEST_HEADER_FIELDS_TOO_LARGE : HttpResponseStatus.BAD_REQUEST;
                DefaultFullHttpResponse rep = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status);
                ctx.fireChannelRead((Object)new Http2ClientDowngrader.Message((HttpObject)rep, streamId));
                promise.trySuccess();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            promise.setFailure(e);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        Object object = msg;
        if (object instanceof Http2ClientDowngrader.Message) {
            Http2ClientDowngrader.Message message = (Http2ClientDowngrader.Message)object;
            HttpObject obj = message.obj();
            int streamId = message.streamId();
            this.handleMessage(ctx, promise, obj, streamId);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Http2ClientDowngrader.Rst) {
            Http2ClientDowngrader.Rst rst = (Http2ClientDowngrader.Rst)object;
            int streamId = rst.streamId();
            long errorCode = rst.errorCode();
            this.encoder().writeRstStream(ctx, streamId, errorCode, promise);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (Http2ClientDowngrader$Ping$.MODULE$.equals(object)) {
            this.encoder().writePing(ctx, false, Http2CodecUtil.emptyPingBuf(), promise);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Http2ClientDowngrader.GoAway) {
            Http2ClientDowngrader.GoAway goAway = (Http2ClientDowngrader.GoAway)object;
            int streamId = goAway.lastStreamId();
            long errorCode = goAway.errorCode();
            this.encoder().writeGoAway(ctx, streamId, errorCode, Unpooled.EMPTY_BUFFER, promise);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            IllegalArgumentException wrongType = new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected a Message, got ", " instead."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{msg.getClass().getName()})));
            this.log.error((Throwable)wrongType, "Tried to write the wrong type to the http2 client pipeline", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            promise.setFailure((Throwable)wrongType);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        super.handlerAdded(ctx);
        this.onActive.apply$mcV$sp();
    }

    public RichHttpToHttp2ConnectionHandler(Http2ConnectionDecoder dec, Http2ConnectionEncoder enc, Http2Settings initialSettings, Function0<BoxedUnit> onActive) {
        this.onActive = onActive;
        super(dec, enc, initialSettings, false);
        this.log = Logger$.MODULE$.get(((Object)((Object)this)).getClass().getName());
    }
}

