/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http2.transport;

import com.twitter.finagle.http2.transport.H2ServerFilter$;
import com.twitter.finagle.http2.transport.H2ServerFilter$$anonfun$1$;
import com.twitter.util.Time;
import com.twitter.util.Time$;
import com.twitter.util.Timer;
import com.twitter.util.TimerTask;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.DefaultHttp2GoAwayFrame;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Frame;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Ea!B\u0001\u0003\u0005\u0011a!A\u0004%3'\u0016\u0014h/\u001a:GS2$XM\u001d\u0006\u0003\u0007\u0011\t\u0011\u0002\u001e:b]N\u0004xN\u001d;\u000b\u0005\u00151\u0011!\u00025uiB\u0014$BA\u0004\t\u0003\u001d1\u0017N\\1hY\u0016T!!\u0003\u0006\u0002\u000fQ<\u0018\u000e\u001e;fe*\t1\"A\u0002d_6\u001c\"\u0001A\u0007\u0011\u00059)R\"A\b\u000b\u0005A\t\u0012aB2iC:tW\r\u001c\u0006\u0003%M\tQA\\3uifT\u0011\u0001F\u0001\u0003S>L!AF\b\u0003)\rC\u0017M\u001c8fY\u0012+\b\u000f\\3y\u0011\u0006tG\r\\3s\u0011!A\u0002A!A!\u0002\u0013Q\u0012!\u0002;j[\u0016\u00148\u0001\u0001\t\u00037yi\u0011\u0001\b\u0006\u0003;!\tA!\u001e;jY&\u0011q\u0004\b\u0002\u0006)&lWM\u001d\u0005\u0006C\u0001!\tAI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\r*\u0003C\u0001\u0013\u0001\u001b\u0005\u0011\u0001\"\u0002\r!\u0001\u0004Q\u0002BB\u0014\u0001A\u0003&\u0001&A\u0007dY>\u001cX\rR3bI2Lg.\u001a\t\u00037%J!A\u000b\u000f\u0003\tQKW.\u001a\u0015\u0003M1\u0002\"!\f\u0019\u000e\u00039R\u0011aL\u0001\u0006g\u000e\fG.Y\u0005\u0003c9\u0012\u0001B^8mCRLG.\u001a\u0005\u0006g\u0001!\t\u0001N\u0001\fg\u0016$H)Z1eY&tW\r\u0006\u00026qA\u0011QFN\u0005\u0003o9\u0012A!\u00168ji\")\u0011H\ra\u0001Q\u0005AA-Z1eY&tW\rC\u0003<\u0001\u0011\u0005C(A\u0006dQ\u0006tg.\u001a7SK\u0006$GcA\u001b>\u0005\")aH\u000fa\u0001\u007f\u0005\u00191\r\u001e=\u0011\u00059\u0001\u0015BA!\u0010\u0005U\u0019\u0005.\u00198oK2D\u0015M\u001c3mKJ\u001cuN\u001c;fqRDQa\u0011\u001eA\u0002\u0011\u000b1!\\:h!\t)%*D\u0001G\u0015\t9\u0005*\u0001\u0003mC:<'\"A%\u0002\t)\fg/Y\u0005\u0003\u0017\u001a\u0013aa\u00142kK\u000e$\b\"B'\u0001\t\u0003r\u0015aD3yG\u0016\u0004H/[8o\u0007\u0006,x\r\u001b;\u0015\u0007Uz\u0005\u000bC\u0003?\u0019\u0002\u0007q\bC\u0003R\u0019\u0002\u0007!+A\u0003dCV\u001cX\r\u0005\u0002T7:\u0011A+\u0017\b\u0003+bk\u0011A\u0016\u0006\u0003/f\ta\u0001\u0010:p_Rt\u0014\"A\u0018\n\u0005is\u0013a\u00029bG.\fw-Z\u0005\u00039v\u0013\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0005is\u0003\"B0\u0001\t\u0003\u0002\u0017!B2m_N,GcA\u001bbE\")aH\u0018a\u0001\u007f!)1M\u0018a\u0001I\u00069\u0001O]8nSN,\u0007C\u0001\bf\u0013\t1wB\u0001\bDQ\u0006tg.\u001a7Qe>l\u0017n]3\b\r!\u0014\u0001\u0012\u0001\u0003j\u00039A%gU3sm\u0016\u0014h)\u001b7uKJ\u0004\"\u0001\n6\u0007\r\u0005\u0011\u0001\u0012\u0001\u0003l'\tQG\u000e\u0005\u0002.[&\u0011aN\f\u0002\u0007\u0003:L(+\u001a4\t\u000b\u0005RG\u0011\u00019\u0015\u0003%DqA\u001d6C\u0002\u0013%1/\u0001\u0004m_\u001e<WM]\u000b\u0002iB\u0011Q\u000f_\u0007\u0002m*\u0011q\u000fC\u0001\bY><w-\u001b8h\u0013\tIhO\u0001\u0004M_\u001e<WM\u001d\u0005\u0007w*\u0004\u000b\u0011\u0002;\u0002\u000f1|wmZ3sA!9QP\u001bb\u0001\n\u0003q\u0018a\u0003%b]\u0012dWM\u001d(b[\u0016,\u0012a \t\u0005\u0003\u0003\t9AD\u0002.\u0003\u0007I1!!\u0002/\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011BA\u0006\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\u0001\u0018\t\u000f\u0005=!\u000e)A\u0005\u007f\u0006a\u0001*\u00198eY\u0016\u0014h*Y7fA\u0001")
public final class H2ServerFilter
extends ChannelDuplexHandler {
    private final Timer timer;
    private volatile Time closeDeadline;

    public static String HandlerName() {
        return H2ServerFilter$.MODULE$.HandlerName();
    }

    public void setDeadline(Time deadline) {
        this.closeDeadline = deadline;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        Object object = msg;
        if (object instanceof Http2Frame) {
            Http2Frame http2Frame = (Http2Frame)object;
            ReferenceCountUtil.release((Object)http2Frame);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            super.channelRead(ctx, msg);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) {
        Http2ConnectionHandler connectionHandler = (Http2ConnectionHandler)ctx.pipeline().get(Http2ConnectionHandler.class);
        if (connectionHandler == null) {
            String message = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found H2ServerFilter in a pipeline without a Http2ConnectionHandler. "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Pipeline: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ctx.pipeline()}))).toString();
            IllegalStateException ex = new IllegalStateException(message);
            H2ServerFilter$.MODULE$.com$twitter$finagle$http2$transport$H2ServerFilter$$logger().error((Throwable)ex, message, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            ctx.close(promise);
        } else {
            Time deadline = this.closeDeadline;
            Time now = Time$.MODULE$.now();
            if (deadline.$less$eq((Object)now)) {
                connectionHandler.gracefulShutdownTimeoutMillis(0L);
                H2ServerFilter$.MODULE$.com$twitter$finagle$http2$transport$H2ServerFilter$$logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deadline already passed (", " <= ", "). Closing now."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{deadline, now})), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                super.close(ctx, promise);
            } else {
                H2ServerFilter$.MODULE$.com$twitter$finagle$http2$transport$H2ServerFilter$$logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Closing h2 session with deadline ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{deadline})), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                DefaultHttp2GoAwayFrame goawayFrame = new DefaultHttp2GoAwayFrame(Http2Error.NO_ERROR);
                goawayFrame.setExtraStreamIds(Integer.MAX_VALUE);
                AtomicBoolean promiseOnce = new AtomicBoolean();
                ctx.writeAndFlush((Object)goawayFrame).addListener((GenericFutureListener)new ChannelFutureListener(this, ctx, promise, promiseOnce){
                    private final ChannelHandlerContext ctx$1;
                    private final ChannelPromise promise$1;
                    private final AtomicBoolean promiseOnce$1;

                    public void operationComplete(ChannelFuture future) {
                        if (!future.isSuccess() && this.promiseOnce$1.compareAndSet(false, true)) {
                            this.ctx$1.close(this.promise$1);
                        }
                    }
                    {
                        this.ctx$1 = ctx$1;
                        this.promise$1 = promise$1;
                        this.promiseOnce$1 = promiseOnce$1;
                    }
                });
                TimerTask closeTask = this.timer.schedule(deadline, (Function0)new Serializable(this, ctx, promise, promiseOnce){
                    public static final long serialVersionUID = 0L;
                    public final ChannelHandlerContext ctx$1;
                    public final ChannelPromise promise$1;
                    private final AtomicBoolean promiseOnce$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        if (this.promiseOnce$1.compareAndSet(false, true)) {
                            this.ctx$1.channel().eventLoop().execute(new Runnable(this){
                                private final /* synthetic */ $anonfun$1 $outer;

                                public void run() {
                                    H2ServerFilter$.MODULE$.com$twitter$finagle$http2$transport$H2ServerFilter$$logger().info("Graceful draining period lapsed. Sending final GOAWAY and closing the connection.", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                                    this.$outer.ctx$1.writeAndFlush((Object)new DefaultHttp2GoAwayFrame(Http2Error.NO_ERROR)).addListener((GenericFutureListener)new ChannelFutureListener(this){
                                        private final /* synthetic */ $anonfun$1$$anon$4 $outer;

                                        public void operationComplete(ChannelFuture future) {
                                            this.$outer.com$twitter$finagle$http2$transport$H2ServerFilter$$anonfun$$anon$$$outer().ctx$1.close(this.$outer.com$twitter$finagle$http2$transport$H2ServerFilter$$anonfun$$anon$$$outer().promise$1);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                }

                                public /* synthetic */ $anonfun$1 com$twitter$finagle$http2$transport$H2ServerFilter$$anonfun$$anon$$$outer() {
                                    return this.$outer;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }
                    }
                    {
                        this.ctx$1 = ctx$1;
                        this.promise$1 = promise$1;
                        this.promiseOnce$1 = promiseOnce$1;
                    }
                });
                ctx.channel().closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(this, promise, promiseOnce, closeTask){
                    private final ChannelPromise promise$1;
                    private final AtomicBoolean promiseOnce$1;
                    private final TimerTask closeTask$1;

                    public void operationComplete(ChannelFuture future) {
                        this.closeTask$1.cancel();
                        if (this.promiseOnce$1.compareAndSet(false, true)) {
                            H2ServerFilter$.MODULE$.com$twitter$finagle$http2$transport$H2ServerFilter$$logger().info("Channel closed, session terminated.", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                            this.promise$1.setSuccess();
                        }
                    }
                    {
                        this.promise$1 = promise$1;
                        this.promiseOnce$1 = promiseOnce$1;
                        this.closeTask$1 = closeTask$1;
                    }
                });
            }
        }
    }

    public H2ServerFilter(Timer timer) {
        this.timer = timer;
        this.closeDeadline = Time$.MODULE$.Bottom();
    }
}

