/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http2;

import com.twitter.finagle.Stack;
import com.twitter.finagle.http2.ExceptionTrackingFrameListener;
import com.twitter.finagle.http2.LoggerPerFrameTypeLogger;
import com.twitter.finagle.http2.MultiplexCodecBuilder$ClosePushedStreamsInitializer$;
import com.twitter.finagle.http2.Settings$;
import com.twitter.finagle.http2.param.EncoderIgnoreMaxHeaderListSize;
import com.twitter.finagle.http2.param.EncoderIgnoreMaxHeaderListSize$;
import com.twitter.finagle.http2.param.FrameLoggerNamePrefix;
import com.twitter.finagle.http2.param.FrameLoggerNamePrefix$;
import com.twitter.finagle.http2.param.HeaderSensitivity;
import com.twitter.finagle.http2.param.HeaderSensitivity$;
import com.twitter.finagle.http2.trackH2SessionExceptions$;
import com.twitter.finagle.param.Stats;
import com.twitter.finagle.param.Stats$;
import com.twitter.finagle.stats.Gauge;
import com.twitter.finagle.stats.StatsReceiver;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2HeadersEncoder;
import io.netty.handler.codec.http2.Http2MultiplexCodec;
import io.netty.handler.codec.http2.Http2MultiplexCodecBuilder;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class MultiplexCodecBuilder$ {
    public static final MultiplexCodecBuilder$ MODULE$;

    static {
        new MultiplexCodecBuilder$();
    }

    public void addStreamsGauge(StatsReceiver statsReceiver, Http2MultiplexCodec http2MultiplexCodec, Channel channel) {
        Gauge streams = statsReceiver.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"streams"}), (Function0)new Serializable(http2MultiplexCodec){
            public static final long serialVersionUID = 0L;
            private final Http2MultiplexCodec http2MultiplexCodec$1;

            public final float apply() {
                return this.apply$mcF$sp();
            }

            public float apply$mcF$sp() {
                return this.http2MultiplexCodec$1.connection().numActiveStreams();
            }
            {
                this.http2MultiplexCodec$1 = http2MultiplexCodec$1;
            }
        });
        channel.attr(AttributeKey.valueOf((String)"streams_gauge")).set((Object)streams);
        channel.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(streams){
            private final Gauge streams$1;

            public void operationComplete(ChannelFuture f) {
                this.streams$1.remove();
            }
            {
                this.streams$1 = streams$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public Http2MultiplexCodec serverMultiplexCodec(Stack.Params params, ChannelHandler inboundInitializer) {
        void var3_3;
        Http2MultiplexCodec codec = this.newMultiplexCodec(params, inboundInitializer, true).build();
        if (BoxesRunTime.unboxToBoolean((Object)trackH2SessionExceptions$.MODULE$.apply())) {
            Http2FrameListener oldListener = codec.decoder().frameListener();
            StatsReceiver statsReceiver = ((Stats)params.apply(Stats$.MODULE$.param())).statsReceiver();
            codec.decoder().frameListener((Http2FrameListener)new ExceptionTrackingFrameListener(statsReceiver, oldListener));
        }
        return var3_3;
    }

    public Http2MultiplexCodec clientMultiplexCodec(Stack.Params params, Option<ChannelHandler> upgradeHandler) {
        Option<ChannelHandler> option;
        block4: {
            Http2MultiplexCodecBuilder builder;
            block3: {
                BoxedUnit boxedUnit;
                block2: {
                    builder = this.newMultiplexCodec(params, (ChannelHandler)MultiplexCodecBuilder$ClosePushedStreamsInitializer$.MODULE$, false);
                    option = upgradeHandler;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    ChannelHandler handler = (ChannelHandler)some.x();
                    boxedUnit = builder.withUpgradeStreamHandler(handler);
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                boxedUnit = BoxedUnit.UNIT;
            }
            return builder.build();
        }
        throw new MatchError(option);
    }

    private Http2MultiplexCodecBuilder newMultiplexCodec(Stack.Params params, ChannelHandler inboundInitializer, boolean isServer) {
        LoggerPerFrameTypeLogger logger = new LoggerPerFrameTypeLogger(((FrameLoggerNamePrefix)params.apply(FrameLoggerNamePrefix$.MODULE$.param())).loggerNamePrefix());
        Http2Settings initialSettings = Settings$.MODULE$.fromParams(params, isServer);
        Http2MultiplexCodecBuilder builder = isServer ? Http2MultiplexCodecBuilder.forServer((ChannelHandler)inboundInitializer) : Http2MultiplexCodecBuilder.forClient((ChannelHandler)inboundInitializer);
        return builder.frameLogger((Http2FrameLogger)logger).initialSettings(initialSettings).encoderIgnoreMaxHeaderListSize(((EncoderIgnoreMaxHeaderListSize)params.apply(EncoderIgnoreMaxHeaderListSize$.MODULE$.param())).ignoreMaxHeaderListSize()).headerSensitivityDetector(this.detector(params));
    }

    private Http2HeadersEncoder.SensitivityDetector detector(Stack.Params params) {
        return new Http2HeadersEncoder.SensitivityDetector(params){
            private final Function2<CharSequence, CharSequence, Object> sensitivityDetector;

            public boolean isSensitive(CharSequence name, CharSequence value) {
                return BoxesRunTime.unboxToBoolean((Object)this.sensitivityDetector.apply((Object)name, (Object)value));
            }
            {
                this.sensitivityDetector = ((HeaderSensitivity)params$1.apply(HeaderSensitivity$.MODULE$.param())).sensitivityDetector();
            }
        };
    }

    private MultiplexCodecBuilder$() {
        MODULE$ = this;
    }
}

