/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http2.transport;

import com.twitter.finagle.http2.transport.StreamMessage;
import com.twitter.finagle.http2.transport.StreamMessage$Ping$;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2EventAdapter;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.HttpConversionUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005-a!B\u0001\u0003\u0005\u0011a!!\u0006%uiB\u00144\t\\5f]R$un\u001e8he\u0006$WM\u001d\u0006\u0003\u0007\u0011\t\u0011\u0002\u001e:b]N\u0004xN\u001d;\u000b\u0005\u00151\u0011!\u00025uiB\u0014$BA\u0004\t\u0003\u001d1\u0017N\\1hY\u0016T!!\u0003\u0006\u0002\u000fQ<\u0018\u000e\u001e;fe*\t1\"A\u0002d_6\u001c\"\u0001A\u0007\u0011\u00059AR\"A\b\u000b\u0005\u0015\u0001\"BA\t\u0013\u0003\u0015\u0019w\u000eZ3d\u0015\t\u0019B#A\u0004iC:$G.\u001a:\u000b\u0005U1\u0012!\u00028fiRL(\"A\f\u0002\u0005%|\u0017BA\r\u0010\u0005EAE\u000f\u001e93\u000bZ,g\u000e^!eCB$XM\u001d\u0005\t7\u0001\u0011\t\u0011)A\u0005;\u0005Q1m\u001c8oK\u000e$\u0018n\u001c8\u0004\u0001A\u0011aBH\u0005\u0003?=\u0011q\u0002\u0013;uaJ\u001auN\u001c8fGRLwN\u001c\u0005\u0006C\u0001!\tAI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\r*\u0003C\u0001\u0013\u0001\u001b\u0005\u0011\u0001\"B\u000e!\u0001\u0004i\u0002bB\u0014\u0001\u0005\u0004%I\u0001K\u0001\u0014\u0011\u0016\fG-\u001a:U_>d\u0015M]4f\u0005f$Xm]\u000b\u0002SA\u0011!&L\u0007\u0002W)\u0011A\u0006F\u0001\u0007EV4g-\u001a:\n\u00059Z#a\u0002\"zi\u0016\u0014UO\u001a\u0005\u0007a\u0001\u0001\u000b\u0011B\u0015\u0002)!+\u0017\rZ3s)>|G*\u0019:hK\nKH/Z:!\u0011\u0015\u0011\u0004\u0001\"\u00114\u0003)yg\u000eR1uCJ+\u0017\r\u001a\u000b\u0007ii\u0012EI\u0012%\u0011\u0005UBT\"\u0001\u001c\u000b\u0003]\nQa]2bY\u0006L!!\u000f\u001c\u0003\u0007%sG\u000fC\u0003<c\u0001\u0007A(A\u0002dib\u0004\"!\u0010!\u000e\u0003yR!a\u0010\u000b\u0002\u000f\rD\u0017M\u001c8fY&\u0011\u0011I\u0010\u0002\u0016\u0007\"\fgN\\3m\u0011\u0006tG\r\\3s\u0007>tG/\u001a=u\u0011\u0015\u0019\u0015\u00071\u00015\u0003!\u0019HO]3b[&#\u0007\"B#2\u0001\u0004I\u0013\u0001\u00023bi\u0006DQaR\u0019A\u0002Q\nq\u0001]1eI&tw\rC\u0003Jc\u0001\u0007!*A\u0006f]\u0012|em\u0015;sK\u0006l\u0007CA\u001bL\u0013\taeGA\u0004C_>dW-\u00198\t\u000b9\u0003A\u0011I(\u0002\u001b=t\u0007*Z1eKJ\u001c(+Z1e)\u0019\u00016\u000bV+[7B\u0011Q'U\u0005\u0003%Z\u0012A!\u00168ji\")1(\u0014a\u0001y!)1)\u0014a\u0001i!)a+\u0014a\u0001/\u00069\u0001.Z1eKJ\u001c\bC\u0001\bY\u0013\tIvB\u0001\u0007IiR\u0004(\u0007S3bI\u0016\u00148\u000fC\u0003H\u001b\u0002\u0007A\u0007C\u0003J\u001b\u0002\u0007!\nC\u0003O\u0001\u0011\u0005S\fF\u0005Q=~\u0003'\rZ5lY\")1\b\u0018a\u0001y!)1\t\u0018a\u0001i!)\u0011\r\u0018a\u0001/\u0006Qa.Z<IK\u0006$WM]:\t\u000b\rd\u0006\u0019\u0001\u001b\u0002!M$(/Z1n\t\u0016\u0004XM\u001c3f]\u000eL\b\"B3]\u0001\u00041\u0017AB<fS\u001eDG\u000f\u0005\u00026O&\u0011\u0001N\u000e\u0002\u0006'\"|'\u000f\u001e\u0005\u0006Ur\u0003\rAS\u0001\nKb\u001cG.^:jm\u0016DQa\u0012/A\u0002QBQ!\u0013/A\u0002)CQA\u001c\u0001\u0005B=\fqb\u001c8SgR\u001cFO]3b[J+\u0017\r\u001a\u000b\u0005!B\f(\u000fC\u0003<[\u0002\u0007A\bC\u0003D[\u0002\u0007A\u0007C\u0003t[\u0002\u0007A/A\u0005feJ|'oQ8eKB\u0011Q'^\u0005\u0003mZ\u0012A\u0001T8oO\")\u0001\u0010\u0001C!s\u0006aqN\\$p\u0003^\f\u0017PU3bIR)\u0001K_>~}\")1h\u001ea\u0001y!)Ap\u001ea\u0001i\u0005aA.Y:u'R\u0014X-Y7JI\")1o\u001ea\u0001i\")qp\u001ea\u0001S\u0005)A-\u001a2vO\"9\u00111\u0001\u0001\u0005B\u0005\u0015\u0011!D8o!&tw-Q2l%\u0016\fG\rF\u0003Q\u0003\u000f\tI\u0001\u0003\u0004<\u0003\u0003\u0001\r\u0001\u0010\u0005\u0007\u000b\u0006\u0005\u0001\u0019\u0001;")
public final class Http2ClientDowngrader
extends Http2EventAdapter {
    private final Http2Connection connection;
    private final ByteBuf HeaderTooLargeBytes;

    private ByteBuf HeaderTooLargeBytes() {
        return this.HeaderTooLargeBytes;
    }

    public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) {
        int length = data.readableBytes();
        data.retain();
        DefaultLastHttpContent msg = endOfStream ? new DefaultLastHttpContent(data) : new DefaultHttpContent(data);
        ctx.fireChannelRead((Object)new StreamMessage.Message((HttpObject)msg, streamId));
        return length + padding;
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endOfStream) {
        if (HttpResponseStatus.CONTINUE.codeAsText().contentEquals(headers.status())) {
            FullHttpResponse msg = HttpConversionUtil.toFullHttpResponse((int)streamId, (Http2Headers)headers, (ByteBufAllocator)ctx.alloc(), (boolean)false);
            ctx.fireChannelRead((Object)new StreamMessage.Message((HttpObject)msg, streamId));
        } else if (endOfStream) {
            if (this.connection.stream(streamId).isTrailersReceived()) {
                DefaultLastHttpContent msg = new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER, false);
                HttpConversionUtil.addHttp2ToHttpHeaders((int)streamId, (Http2Headers)headers, (HttpHeaders)msg.trailingHeaders(), (HttpVersion)HttpVersion.HTTP_1_1, (boolean)true, (boolean)false);
                ctx.fireChannelRead((Object)new StreamMessage.Message((HttpObject)msg, streamId));
            } else {
                FullHttpResponse msg = HttpConversionUtil.toFullHttpResponse((int)streamId, (Http2Headers)headers, (ByteBufAllocator)ctx.alloc(), (boolean)false);
                ctx.fireChannelRead((Object)new StreamMessage.Message((HttpObject)msg, streamId));
            }
        } else {
            HttpResponseStatus status = HttpConversionUtil.parseStatus((CharSequence)headers.status());
            DefaultHttpResponse msg = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status, false);
            HttpConversionUtil.addHttp2ToHttpHeaders((int)streamId, (Http2Headers)headers, (HttpHeaders)msg.headers(), (HttpVersion)HttpVersion.HTTP_1_1, (boolean)false, (boolean)false);
            ctx.fireChannelRead((Object)new StreamMessage.Message((HttpObject)msg, streamId));
        }
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers newHeaders, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) {
        this.onHeadersRead(ctx, streamId, newHeaders, padding, endOfStream);
    }

    public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) {
        ctx.fireChannelRead((Object)new StreamMessage.Rst(streamId, errorCode));
    }

    public void onGoAwayRead(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debug) {
        ByteBuf sliced;
        int idx = debug.readerIndex();
        ByteBuf byteBuf = sliced = debug.slice(idx, package$.MODULE$.min(idx + this.HeaderTooLargeBytes().readableBytes(), idx + debug.readableBytes()));
        ByteBuf byteBuf2 = this.HeaderTooLargeBytes();
        HttpResponseStatus status = !(byteBuf != null ? !byteBuf.equals(byteBuf2) : byteBuf2 != null) ? HttpResponseStatus.REQUEST_HEADER_FIELDS_TOO_LARGE : HttpResponseStatus.BAD_REQUEST;
        DefaultFullHttpResponse rep = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status);
        ctx.fireChannelRead((Object)new StreamMessage.GoAway((HttpObject)rep, lastStreamId, errorCode));
    }

    public void onPingAckRead(ChannelHandlerContext ctx, long data) {
        ctx.fireChannelRead((Object)StreamMessage$Ping$.MODULE$);
    }

    public Http2ClientDowngrader(Http2Connection connection) {
        this.connection = connection;
        this.HeaderTooLargeBytes = Unpooled.copiedBuffer((CharSequence)"Header size exceeded max allowed bytes", (Charset)StandardCharsets.UTF_8);
    }
}

