/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http2.transport;

import com.twitter.finagle.http2.transport.H2Filter$;
import com.twitter.finagle.http2.transport.H2Filter$$anonfun$1$;
import com.twitter.util.Time;
import com.twitter.util.Time$;
import com.twitter.util.Timer;
import com.twitter.util.TimerTask;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.DefaultHttp2GoAwayFrame;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Frame;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Ea!B\u0001\u0003\u0005\u0011a!\u0001\u0003%3\r&dG/\u001a:\u000b\u0005\r!\u0011!\u0003;sC:\u001c\bo\u001c:u\u0015\t)a!A\u0003iiR\u0004(G\u0003\u0002\b\u0011\u00059a-\u001b8bO2,'BA\u0005\u000b\u0003\u001d!x/\u001b;uKJT\u0011aC\u0001\u0004G>l7C\u0001\u0001\u000e!\tqQ#D\u0001\u0010\u0015\t\u0001\u0012#A\u0004dQ\u0006tg.\u001a7\u000b\u0005I\u0019\u0012!\u00028fiRL(\"\u0001\u000b\u0002\u0005%|\u0017B\u0001\f\u0010\u0005Q\u0019\u0005.\u00198oK2$U\u000f\u001d7fq\"\u000bg\u000e\u001a7fe\"A\u0001\u0004\u0001B\u0001B\u0003%!$A\u0003uS6,'o\u0001\u0001\u0011\u0005mqR\"\u0001\u000f\u000b\u0005uA\u0011\u0001B;uS2L!a\b\u000f\u0003\u000bQKW.\u001a:\t\u000b\u0005\u0002A\u0011\u0001\u0012\u0002\rqJg.\u001b;?)\t\u0019S\u0005\u0005\u0002%\u00015\t!\u0001C\u0003\u0019A\u0001\u0007!\u0004\u0003\u0004(\u0001\u0001\u0006K\u0001K\u0001\u000eG2|7/\u001a#fC\u0012d\u0017N\\3\u0011\u0005mI\u0013B\u0001\u0016\u001d\u0005\u0011!\u0016.\\3)\u0005\u0019b\u0003CA\u00171\u001b\u0005q#\"A\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Er#\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u000bM\u0002A\u0011\u0001\u001b\u0002\u0017M,G\u000fR3bI2Lg.\u001a\u000b\u0003ka\u0002\"!\f\u001c\n\u0005]r#\u0001B+oSRDQ!\u000f\u001aA\u0002!\n\u0001\u0002Z3bI2Lg.\u001a\u0005\u0006w\u0001!\t\u0005P\u0001\fG\"\fgN\\3m%\u0016\fG\rF\u00026{\tCQA\u0010\u001eA\u0002}\n1a\u0019;y!\tq\u0001)\u0003\u0002B\u001f\t)2\t[1o]\u0016d\u0007*\u00198eY\u0016\u00148i\u001c8uKb$\b\"B\";\u0001\u0004!\u0015aA7tOB\u0011QIS\u0007\u0002\r*\u0011q\tS\u0001\u0005Y\u0006twMC\u0001J\u0003\u0011Q\u0017M^1\n\u0005-3%AB(cU\u0016\u001cG\u000fC\u0003N\u0001\u0011\u0005c*A\bfq\u000e,\u0007\u000f^5p]\u000e\u000bWo\u001a5u)\r)t\n\u0015\u0005\u0006}1\u0003\ra\u0010\u0005\u0006#2\u0003\rAU\u0001\u0006G\u0006,8/\u001a\t\u0003'ns!\u0001V-\u000f\u0005UCV\"\u0001,\u000b\u0005]K\u0012A\u0002\u001fs_>$h(C\u00010\u0013\tQf&A\u0004qC\u000e\\\u0017mZ3\n\u0005qk&!\u0003+ie><\u0018M\u00197f\u0015\tQf\u0006C\u0003`\u0001\u0011\u0005\u0003-A\u0003dY>\u001cX\rF\u00026C\nDQA\u00100A\u0002}BQa\u00190A\u0002\u0011\fq\u0001\u001d:p[&\u001cX\r\u0005\u0002\u000fK&\u0011am\u0004\u0002\u000f\u0007\"\fgN\\3m!J|W.[:f\u000f\u0019A'\u0001#\u0001\u0005S\u0006A\u0001J\r$jYR,'\u000f\u0005\u0002%U\u001a1\u0011A\u0001E\u0001\t-\u001c\"A\u001b7\u0011\u00055j\u0017B\u00018/\u0005\u0019\te.\u001f*fM\")\u0011E\u001bC\u0001aR\t\u0011\u000eC\u0004sU\n\u0007I\u0011B:\u0002\r1|wmZ3s+\u0005!\bCA;y\u001b\u00051(BA<\t\u0003\u001dawnZ4j]\u001eL!!\u001f<\u0003\r1{wmZ3s\u0011\u0019Y(\u000e)A\u0005i\u00069An\\4hKJ\u0004\u0003bB?k\u0005\u0004%\tA`\u0001\f\u0011\u0006tG\r\\3s\u001d\u0006lW-F\u0001\u0000!\u0011\t\t!a\u0002\u000f\u00075\n\u0019!C\u0002\u0002\u00069\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0005\u0003\u0017\u0011aa\u0015;sS:<'bAA\u0003]!9\u0011q\u00026!\u0002\u0013y\u0018\u0001\u0004%b]\u0012dWM\u001d(b[\u0016\u0004\u0003")
public final class H2Filter
extends ChannelDuplexHandler {
    private final Timer timer;
    private volatile Time closeDeadline;

    public static String HandlerName() {
        return H2Filter$.MODULE$.HandlerName();
    }

    public void setDeadline(Time deadline) {
        this.closeDeadline = deadline;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        Object object = msg;
        if (object instanceof Http2Frame) {
            Http2Frame http2Frame = (Http2Frame)object;
            ReferenceCountUtil.release((Object)http2Frame);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            super.channelRead(ctx, msg);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) {
        Http2ConnectionHandler connectionHandler = (Http2ConnectionHandler)ctx.pipeline().get(Http2ConnectionHandler.class);
        if (connectionHandler == null) {
            String message = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found H2Filter in a pipeline without a Http2ConnectionHandler. "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Pipeline: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ctx.pipeline()}))).toString();
            IllegalStateException ex = new IllegalStateException(message);
            H2Filter$.MODULE$.com$twitter$finagle$http2$transport$H2Filter$$logger().error((Throwable)ex, message, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            ctx.close(promise);
        } else {
            Time deadline = this.closeDeadline;
            Time now = Time$.MODULE$.now();
            if (deadline.$less$eq((Object)now)) {
                connectionHandler.gracefulShutdownTimeoutMillis(0L);
                H2Filter$.MODULE$.com$twitter$finagle$http2$transport$H2Filter$$logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deadline already passed (", " <= ", "). Closing now."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{deadline, now})), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                super.close(ctx, promise);
            } else {
                H2Filter$.MODULE$.com$twitter$finagle$http2$transport$H2Filter$$logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Closing h2 session with deadline ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{deadline})), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                DefaultHttp2GoAwayFrame goawayFrame = new DefaultHttp2GoAwayFrame(Http2Error.NO_ERROR);
                goawayFrame.setExtraStreamIds(Integer.MAX_VALUE);
                AtomicBoolean promiseOnce = new AtomicBoolean();
                ctx.writeAndFlush((Object)goawayFrame).addListener((GenericFutureListener)new ChannelFutureListener(this, ctx, promise, promiseOnce){
                    private final ChannelHandlerContext ctx$1;
                    private final ChannelPromise promise$1;
                    private final AtomicBoolean promiseOnce$1;

                    public void operationComplete(ChannelFuture future) {
                        if (!future.isSuccess() && this.promiseOnce$1.compareAndSet(false, true)) {
                            this.ctx$1.close(this.promise$1);
                        }
                    }
                    {
                        this.ctx$1 = ctx$1;
                        this.promise$1 = promise$1;
                        this.promiseOnce$1 = promiseOnce$1;
                    }
                });
                TimerTask closeTask = this.timer.schedule(deadline, (Function0)new Serializable(this, ctx, promise, promiseOnce){
                    public static final long serialVersionUID = 0L;
                    public final ChannelHandlerContext ctx$1;
                    public final ChannelPromise promise$1;
                    private final AtomicBoolean promiseOnce$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        if (this.promiseOnce$1.compareAndSet(false, true)) {
                            this.ctx$1.channel().eventLoop().execute(new Runnable(this){
                                private final /* synthetic */ $anonfun$1 $outer;

                                public void run() {
                                    H2Filter$.MODULE$.com$twitter$finagle$http2$transport$H2Filter$$logger().info("Graceful draining period lapsed. Sending final GOAWAY and closing the connection.", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                                    this.$outer.ctx$1.writeAndFlush((Object)new DefaultHttp2GoAwayFrame(Http2Error.NO_ERROR)).addListener((GenericFutureListener)new ChannelFutureListener(this){
                                        private final /* synthetic */ $anonfun$1$$anon$4 $outer;

                                        public void operationComplete(ChannelFuture future) {
                                            this.$outer.com$twitter$finagle$http2$transport$H2Filter$$anonfun$$anon$$$outer().ctx$1.close(this.$outer.com$twitter$finagle$http2$transport$H2Filter$$anonfun$$anon$$$outer().promise$1);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                }

                                public /* synthetic */ $anonfun$1 com$twitter$finagle$http2$transport$H2Filter$$anonfun$$anon$$$outer() {
                                    return this.$outer;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }
                    }
                    {
                        this.ctx$1 = ctx$1;
                        this.promise$1 = promise$1;
                        this.promiseOnce$1 = promiseOnce$1;
                    }
                });
                ctx.channel().closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(this, promise, promiseOnce, closeTask){
                    private final ChannelPromise promise$1;
                    private final AtomicBoolean promiseOnce$1;
                    private final TimerTask closeTask$1;

                    public void operationComplete(ChannelFuture future) {
                        this.closeTask$1.cancel();
                        if (this.promiseOnce$1.compareAndSet(false, true)) {
                            H2Filter$.MODULE$.com$twitter$finagle$http2$transport$H2Filter$$logger().info("Channel closed, session terminated.", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                            this.promise$1.setSuccess();
                        }
                    }
                    {
                        this.promise$1 = promise$1;
                        this.promiseOnce$1 = promiseOnce$1;
                        this.closeTask$1 = closeTask$1;
                    }
                });
            }
        }
    }

    public H2Filter(Timer timer) {
        this.timer = timer;
        this.closeDeadline = Time$.MODULE$.Bottom();
    }
}

