/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http2.transport;

import com.twitter.finagle.http2.transport.Http2ClientDowngrader;
import com.twitter.finagle.http2.transport.Http2ClientDowngrader$Ping$;
import com.twitter.logging.Logger;
import com.twitter.logging.Logger$;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandler;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005-b!B\u0001\u0003\u0001\u0011a!\u0001\t*jG\"DE\u000f\u001e9U_\"#H\u000f\u001d\u001aD_:tWm\u0019;j_:D\u0015M\u001c3mKJT!a\u0001\u0003\u0002\u0013Q\u0014\u0018M\\:q_J$(BA\u0003\u0007\u0003\u0015AG\u000f\u001e93\u0015\t9\u0001\"A\u0004gS:\fw\r\\3\u000b\u0005%Q\u0011a\u0002;xSR$XM\u001d\u0006\u0002\u0017\u0005\u00191m\\7\u0014\u0005\u0001i\u0001C\u0001\b\u0019\u001b\u0005y!BA\u0003\u0011\u0015\t\t\"#A\u0003d_\u0012,7M\u0003\u0002\u0014)\u00059\u0001.\u00198eY\u0016\u0014(BA\u000b\u0017\u0003\u0015qW\r\u001e;z\u0015\u00059\u0012AA5p\u0013\tIrB\u0001\u000fIiR\u0004Hk\u001c%uiB\u00144i\u001c8oK\u000e$\u0018n\u001c8IC:$G.\u001a:\t\u0011m\u0001!\u0011!Q\u0001\nu\t1\u0001Z3d\u0007\u0001\u0001\"A\u0004\u0010\n\u0005}y!A\u0006%uiB\u00144i\u001c8oK\u000e$\u0018n\u001c8EK\u000e|G-\u001a:\t\u0011\u0005\u0002!\u0011!Q\u0001\n\t\n1!\u001a8d!\tq1%\u0003\u0002%\u001f\t1\u0002\n\u001e;qe\r{gN\\3di&|g.\u00128d_\u0012,'\u000f\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003(\u0003=Ig.\u001b;jC2\u001cV\r\u001e;j]\u001e\u001c\bC\u0001\b)\u0013\tIsBA\u0007IiR\u0004(gU3ui&twm\u001d\u0005\tW\u0001\u0011\t\u0011)A\u0005Y\u0005AqN\\!di&4X\rE\u0002.aIj\u0011A\f\u0006\u0002_\u0005)1oY1mC&\u0011\u0011G\f\u0002\n\rVt7\r^5p]B\u0002\"!L\u001a\n\u0005Qr#\u0001B+oSRDQA\u000e\u0001\u0005\u0002]\na\u0001P5oSRtD#\u0002\u001d;wqj\u0004CA\u001d\u0001\u001b\u0005\u0011\u0001\"B\u000e6\u0001\u0004i\u0002\"B\u00116\u0001\u0004\u0011\u0003\"\u0002\u00146\u0001\u00049\u0003\"B\u00166\u0001\u0004a\u0003BB \u0001A\u0003%\u0001)A\u0002m_\u001e\u0004\"!\u0011#\u000e\u0003\tS!a\u0011\u0005\u0002\u000f1|wmZ5oO&\u0011QI\u0011\u0002\u0007\u0019><w-\u001a:\t\r\u001d\u0003\u0001\u0015\"\u0003I\u00035A\u0017M\u001c3mK6+7o]1hKR)!'S)W=\")!J\u0012a\u0001\u0017\u0006\u00191\r\u001e=\u0011\u00051{U\"A'\u000b\u00059#\u0012aB2iC:tW\r\\\u0005\u0003!6\u0013Qc\u00115b]:,G\u000eS1oI2,'oQ8oi\u0016DH\u000fC\u0003S\r\u0002\u00071+A\u0004qe>l\u0017n]3\u0011\u00051#\u0016BA+N\u00059\u0019\u0005.\u00198oK2\u0004&o\\7jg\u0016DQa\u0016$A\u0002a\u000b1!\\:h!\tIF,D\u0001[\u0015\tY\u0006#\u0001\u0003iiR\u0004\u0018BA/[\u0005)AE\u000f\u001e9PE*,7\r\u001e\u0005\u0006?\u001a\u0003\r\u0001Y\u0001\tgR\u0014X-Y7JIB\u0011Q&Y\u0005\u0003E:\u00121!\u00138u\u0011\u0015!\u0007\u0001\"\u0011f\u0003\u00159(/\u001b;f)\u0011\u0011dm\u001a9\t\u000b)\u001b\u0007\u0019A&\t\u000b]\u001b\u0007\u0019\u00015\u0011\u0005%tW\"\u00016\u000b\u0005-d\u0017\u0001\u00027b]\u001eT\u0011!\\\u0001\u0005U\u00064\u0018-\u0003\u0002pU\n1qJ\u00196fGRDQAU2A\u0002MCQA\u001d\u0001\u0005BM\fA\u0002[1oI2,'/\u00113eK\u0012$\"A\r;\t\u000b)\u000b\b\u0019A&\t\u000bY\u0004A\u0011I<\u0002\u001b=t7\u000b\u001e:fC6,%O]8s)\u0019\u0011\u00040\u001f@\u0002\u001a!)!*\u001ea\u0001\u0017\")!0\u001ea\u0001w\u0006Aq.\u001e;c_VtG\r\u0005\u0002.y&\u0011QP\f\u0002\b\u0005>|G.Z1o\u0011\u0019yX\u000f1\u0001\u0002\u0002\u0005)1-Y;tKB!\u00111AA\n\u001d\u0011\t)!a\u0004\u000f\t\u0005\u001d\u0011QB\u0007\u0003\u0003\u0013Q1!a\u0003\u001d\u0003\u0019a$o\\8u}%\tq&C\u0002\u0002\u00129\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0016\u0005]!!\u0003+ie><\u0018M\u00197f\u0015\r\t\tB\f\u0005\b\u00037)\b\u0019AA\u000f\u0003\u001dAG\u000f\u001e93\u000bb\u0004B!a\b\u0002&9\u0019a\"!\t\n\u0007\u0005\rr\"\u0001\bIiR\u0004('\u0012=dKB$\u0018n\u001c8\n\t\u0005\u001d\u0012\u0011\u0006\u0002\u0010'R\u0014X-Y7Fq\u000e,\u0007\u000f^5p]*\u0019\u00111E\b")
public class RichHttpToHttp2ConnectionHandler
extends HttpToHttp2ConnectionHandler {
    private final Function0<BoxedUnit> onActive;
    private final Logger log;

    private void handleMessage(ChannelHandlerContext ctx, ChannelPromise promise, HttpObject msg, int streamId) {
        try {
            BoxedUnit boxedUnit;
            PromiseCombiner combiner = new PromiseCombiner();
            HttpObject httpObject = msg;
            if (httpObject instanceof HttpRequest) {
                FullHttpRequest fullHttpRequest;
                HttpRequest httpRequest = (HttpRequest)httpObject;
                Http2Headers headers = HttpConversionUtil.toHttp2Headers((HttpMessage)httpRequest, (boolean)false);
                HttpRequest httpRequest2 = httpRequest;
                boolean bl = httpRequest2 instanceof FullHttpRequest && !(fullHttpRequest = (FullHttpRequest)httpRequest2).content().isReadable();
                boolean endStream = bl;
                ChannelPromise p = ctx.newPromise();
                combiner.add((Promise)p);
                HttpHeaders http1Headers = httpRequest.headers();
                int dependencyId = http1Headers.getInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_DEPENDENCY_ID.text(), 0);
                short weight = http1Headers.getShort((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_WEIGHT.text(), (short)16);
                this.encoder().writeHeaders(ctx, streamId, headers, dependencyId, weight, false, 0, endStream, p);
                if (p.isDone() && !p.isSuccess()) {
                    throw p.cause();
                }
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
            }
            HttpObject httpObject2 = msg;
            if (httpObject2 instanceof HttpContent) {
                BoxedUnit boxedUnit4;
                HttpContent httpContent = (HttpContent)httpObject2;
                ByteBuf data = httpContent.content();
                boolean endStream = httpContent instanceof LastHttpContent;
                if (data.isReadable() || endStream && !(httpContent instanceof HttpRequest)) {
                    ChannelPromise p = ctx.newPromise();
                    combiner.add((Promise)p);
                    boxedUnit4 = this.encoder().writeData(ctx, streamId, data, 0, endStream, p);
                } else {
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit4;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            combiner.finish((Promise)promise);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof Http2Exception) {
                Http2Exception http2Exception = (Http2Exception)throwable2;
                HttpResponseStatus status = http2Exception instanceof Http2Exception.HeaderListSizeException ? HttpResponseStatus.REQUEST_HEADER_FIELDS_TOO_LARGE : HttpResponseStatus.BAD_REQUEST;
                DefaultFullHttpResponse rep = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status);
                ctx.fireChannelRead((Object)new Http2ClientDowngrader.Message((HttpObject)rep, streamId));
                promise.trySuccess();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            promise.setFailure(e);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        Object object = msg;
        if (object instanceof Http2ClientDowngrader.Message) {
            Http2ClientDowngrader.Message message = (Http2ClientDowngrader.Message)object;
            HttpObject obj = message.obj();
            int streamId = message.streamId();
            this.handleMessage(ctx, promise, obj, streamId);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Http2ClientDowngrader.Rst) {
            Http2ClientDowngrader.Rst rst = (Http2ClientDowngrader.Rst)object;
            int streamId = rst.streamId();
            long errorCode = rst.errorCode();
            this.encoder().writeRstStream(ctx, streamId, errorCode, promise);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (Http2ClientDowngrader$Ping$.MODULE$.equals(object)) {
            this.encoder().writePing(ctx, false, 0L, promise);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Http2ClientDowngrader.GoAway) {
            Http2ClientDowngrader.GoAway goAway = (Http2ClientDowngrader.GoAway)object;
            HttpObject obj = goAway.obj();
            int streamId = goAway.lastStreamId();
            long errorCode = goAway.errorCode();
            ReferenceCountUtil.release((Object)obj);
            this.encoder().writeGoAway(ctx, streamId, errorCode, Unpooled.EMPTY_BUFFER, promise);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            IllegalArgumentException wrongType = new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected a Message, got ", " instead."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{msg.getClass().getName()})));
            ReferenceCountUtil.release((Object)msg);
            this.log.error((Throwable)wrongType, "Tried to write the wrong type to the http2 client pipeline", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            promise.setFailure((Throwable)wrongType);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        super.handlerAdded(ctx);
        this.onActive.apply$mcV$sp();
    }

    public void onStreamError(ChannelHandlerContext ctx, boolean outbound, Throwable cause, Http2Exception.StreamException http2Ex) {
        BoxedUnit boxedUnit;
        if (outbound) {
            boxedUnit = BoxedUnit.UNIT;
        } else {
            Http2Exception.HeaderListSizeException headerListSizeException;
            Http2Exception.StreamException streamException = http2Ex;
            Object object = streamException instanceof Http2Exception.HeaderListSizeException && (headerListSizeException = (Http2Exception.HeaderListSizeException)streamException).duringDecode() ? ctx.fireChannelRead((Object)new Http2ClientDowngrader.StreamException(headerListSizeException, headerListSizeException.streamId())) : BoxedUnit.UNIT;
            boxedUnit = object;
        }
        super.onStreamError(ctx, outbound, cause, http2Ex);
    }

    public RichHttpToHttp2ConnectionHandler(Http2ConnectionDecoder dec, Http2ConnectionEncoder enc, Http2Settings initialSettings, Function0<BoxedUnit> onActive) {
        this.onActive = onActive;
        super(dec, enc, initialSettings, false);
        this.log = Logger$.MODULE$.get(((Object)((Object)this)).getClass().getName());
    }
}

