/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http2;

import com.twitter.finagle.Stack;
import com.twitter.finagle.http2.LoggerPerFrameTypeLogger;
import com.twitter.finagle.http2.Settings$;
import com.twitter.finagle.http2.param.EncoderIgnoreMaxHeaderListSize;
import com.twitter.finagle.http2.param.EncoderIgnoreMaxHeaderListSize$;
import com.twitter.finagle.http2.param.FrameLoggerNamePrefix;
import com.twitter.finagle.http2.param.FrameLoggerNamePrefix$;
import com.twitter.finagle.http2.param.HeaderSensitivity;
import com.twitter.finagle.http2.param.HeaderSensitivity$;
import com.twitter.finagle.stats.Gauge;
import com.twitter.finagle.stats.StatsReceiver;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2HeadersEncoder;
import io.netty.handler.codec.http2.Http2MultiplexCodec;
import io.netty.handler.codec.http2.Http2MultiplexCodecBuilder;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import scala.Function0;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;

public final class ServerCodec$ {
    public static final ServerCodec$ MODULE$;

    static {
        new ServerCodec$();
    }

    public Http2MultiplexCodec multiplexCodec(Stack.Params params, Http2MultiplexCodecBuilder builder) {
        LoggerPerFrameTypeLogger logger = new LoggerPerFrameTypeLogger(((FrameLoggerNamePrefix)params.apply(FrameLoggerNamePrefix$.MODULE$.param())).loggerNamePrefix());
        Http2Settings initialSettings = Settings$.MODULE$.fromParams(params, true);
        boolean ignoreMaxHeaderListSize = ((EncoderIgnoreMaxHeaderListSize)params.apply(EncoderIgnoreMaxHeaderListSize$.MODULE$.param())).ignoreMaxHeaderListSize();
        Http2HeadersEncoder.SensitivityDetector sensitivityDetector = this.detector(params);
        return builder.frameLogger((Http2FrameLogger)logger).initialSettings(initialSettings).encoderIgnoreMaxHeaderListSize(ignoreMaxHeaderListSize).headerSensitivityDetector(sensitivityDetector).build();
    }

    public void addStreamsGauge(StatsReceiver statsReceiver, Http2MultiplexCodec http2MultiplexCodec, Channel channel) {
        Gauge streams = statsReceiver.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"streams"}), (Function0)new Serializable(http2MultiplexCodec){
            public static final long serialVersionUID = 0L;
            private final Http2MultiplexCodec http2MultiplexCodec$1;

            public final float apply() {
                return this.apply$mcF$sp();
            }

            public float apply$mcF$sp() {
                return this.http2MultiplexCodec$1.connection().numActiveStreams();
            }
            {
                this.http2MultiplexCodec$1 = http2MultiplexCodec$1;
            }
        });
        channel.attr(AttributeKey.valueOf((String)"streams_gauge")).set((Object)streams);
        channel.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(streams){
            private final Gauge streams$1;

            public void operationComplete(ChannelFuture f) {
                this.streams$1.remove();
            }
            {
                this.streams$1 = streams$1;
            }
        });
    }

    private Http2HeadersEncoder.SensitivityDetector detector(Stack.Params params) {
        return new Http2HeadersEncoder.SensitivityDetector(params){
            private final Function2<CharSequence, CharSequence, Object> sensitivityDetector;

            public boolean isSensitive(CharSequence name, CharSequence value) {
                return BoxesRunTime.unboxToBoolean((Object)this.sensitivityDetector.apply((Object)name, (Object)value));
            }
            {
                this.sensitivityDetector = ((HeaderSensitivity)params$1.apply(HeaderSensitivity$.MODULE$.param())).sensitivityDetector();
            }
        };
    }

    private ServerCodec$() {
        MODULE$ = this;
    }
}

