/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.codec.context;

import com.twitter.finagle.context.Context;
import com.twitter.finagle.context.Contexts$;
import com.twitter.finagle.http.HeaderMap;
import com.twitter.finagle.http.Message;
import com.twitter.finagle.http.codec.context.HttpBackupRequest$;
import com.twitter.finagle.http.codec.context.HttpContext;
import com.twitter.finagle.http.codec.context.HttpDeadline$;
import com.twitter.finagle.http.codec.context.HttpRequeues$;
import com.twitter.finagle.http.codec.context.LoadableHttpContext;
import com.twitter.finagle.util.LoadService$;
import com.twitter.logging.Level;
import com.twitter.logging.Logger;
import com.twitter.logging.Logger$;
import com.twitter.util.Return;
import com.twitter.util.Throw;
import com.twitter.util.Try;
import java.io.Serializable;
import java.util.logging.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.SetOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Growable;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

public final class HttpContext$ {
    public static final HttpContext$ MODULE$ = new HttpContext$();
    private static final Logger log = Logger$.MODULE$.apply(MODULE$.getClass().getName());
    private static final String Prefix = "Finagle-Ctx-";
    private static final HttpContext[] knownContextTypes = (HttpContext[])((Object[])new HttpContext[]{HttpDeadline$.MODULE$, HttpRequeues$.MODULE$, HttpBackupRequest$.MODULE$});
    private static final HttpContext[] loadedContextTypes;
    private static final HttpContext[] allContextTypes;

    static {
        ArrayBuffer loaded = ArrayBuffer$.MODULE$.empty();
        Set ctxKeys = (Set)((SetOps)Set$.MODULE$.empty()).$plus$plus((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])knownContextTypes), (Function1 & Serializable)x$1 -> x$1.headerKey(), ClassTag$.MODULE$.apply(String.class))).toSet());
        LoadService$.MODULE$.apply(ClassTag$.MODULE$.apply(LoadableHttpContext.class)).foreach((Function1 & Serializable)httpCtx -> {
            Growable growable;
            if (ctxKeys.contains((Object)httpCtx.headerKey())) {
                MODULE$.log().warning(new StringBuilder(43).append("skipping duplicate http header context key ").append(httpCtx.headerKey()).toString(), (Seq)Nil$.MODULE$);
                growable = BoxedUnit.UNIT;
            } else {
                ctxKeys.$plus$eq((Object)httpCtx.headerKey());
                growable = loaded.$plus$eq(httpCtx);
            }
            return growable;
        });
        loadedContextTypes = (HttpContext[])loaded.toArray(ClassTag$.MODULE$.apply(HttpContext.class));
        allContextTypes = (HttpContext[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])knownContextTypes), (Object)loadedContextTypes, ClassTag$.MODULE$.apply(HttpContext.class));
    }

    private Logger log() {
        return log;
    }

    public String Prefix() {
        return Prefix;
    }

    public void removeDeadline(Message msg) {
        msg.headerMap().remove(HttpDeadline$.MODULE$.headerKey());
    }

    public <R> R read(Message msg, Function0<R> fn) {
        Nil$ ctxValues = package$.MODULE$.Nil();
        for (int i = 0; i < allContextTypes.length; ++i) {
            BoxedUnit boxedUnit;
            HttpContext contextType = allContextTypes[i];
            Option<String> option = msg.headerMap().get(contextType.headerKey());
            if (option instanceof Some) {
                BoxedUnit boxedUnit2;
                Some some = (Some)option;
                String header = (String)some.value();
                Try<Object> try_ = contextType.fromHeader(header);
                if (try_ instanceof Return) {
                    Return return_ = (Return)try_;
                    Object ctxVal = return_.r();
                    Context.KeyValuePair keyValuePair = new Context.KeyValuePair((Context)Contexts$.MODULE$.broadcast(), contextType.key(), ctxVal);
                    ctxValues = ctxValues.$colon$colon((Object)keyValuePair);
                    boxedUnit2 = BoxedUnit.UNIT;
                } else if (try_ instanceof Throw) {
                    BoxedUnit boxedUnit3;
                    if (this.log().isLoggable((Level)Level.DEBUG$.MODULE$)) {
                        this.log().debug(new StringBuilder(42).append("could not unmarshal ").append(contextType.key()).append(" from the header value").toString(), (Seq)Nil$.MODULE$);
                        boxedUnit3 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit3 = BoxedUnit.UNIT;
                    }
                    boxedUnit2 = boxedUnit3;
                } else {
                    throw new MatchError(try_);
                }
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (None$.MODULE$.equals(option)) {
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            throw new MatchError(option);
        }
        return (R)Contexts$.MODULE$.broadcast().let((Iterable)ctxValues, fn);
    }

    public void write(Message msg) {
        int i;
        for (i = 0; i < knownContextTypes.length; ++i) {
            HttpContext contextType = knownContextTypes[i];
            this.writeToHeader(contextType, msg.headerMap(), true);
        }
        for (i = 0; i < loadedContextTypes.length; ++i) {
            HttpContext contextType = loadedContextTypes[i];
            this.writeToHeader(contextType, msg.headerMap(), false);
        }
    }

    private void writeToHeader(HttpContext contextType, HeaderMap headerMap, boolean isSafe) {
        Option option = Contexts$.MODULE$.broadcast().get(contextType.key());
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            Object ctxVal = some.value();
            if (isSafe) {
                headerMap.setUnsafe(contextType.headerKey(), contextType.toHeader(ctxVal));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                try {
                    headerMap.set(contextType.headerKey(), contextType.toHeader(ctxVal));
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    BoxedUnit boxedUnit2;
                    Option option2;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option2 = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        if (this.log().isLoggable((Level)Level.DEBUG$.MODULE$)) {
                            this.log().debug(new StringBuilder(28).append("unable to add ").append(contextType.key()).append(" to the header").toString(), (Seq)Nil$.MODULE$);
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                    } else {
                        throw throwable;
                    }
                    BoxedUnit boxedUnit3 = boxedUnit2;
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            BoxedUnit boxedUnit4 = boxedUnit;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    private HttpContext$() {
    }
}

