/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.filter;

import com.twitter.finagle.FailureFlags$;
import com.twitter.finagle.ServiceFactory;
import com.twitter.finagle.SimpleFilter;
import com.twitter.finagle.Stack;
import com.twitter.finagle.Stackable;
import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Response;
import com.twitter.finagle.http.Status;
import com.twitter.finagle.http.Status$;
import com.twitter.finagle.http.filter.HttpNackFilter;
import com.twitter.finagle.param.Stats;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.io.Buf;
import scala.MatchError;
import scala.Option;
import scala.Some;

public final class HttpNackFilter$ {
    public static final HttpNackFilter$ MODULE$ = new HttpNackFilter$();
    private static final Stack.Role role = new Stack.Role("HttpNack");
    private static final String RetryableNackHeader = "finagle-http-nack";
    private static final String NonRetryableNackHeader = "finagle-http-nonretryable-nack";
    private static final String RetryableRequestHeader = "finagle-http-retryable-request";
    private static final Status ResponseStatus = Status$.MODULE$.ServiceUnavailable();
    private static final Buf com$twitter$finagle$http$filter$HttpNackFilter$$RetryableNackBody = Buf.Utf8$.MODULE$.apply("Request was not processed by the server due to an error and is safe to retry");
    private static final Buf com$twitter$finagle$http$filter$HttpNackFilter$$NonRetryableNackBody = Buf.Utf8$.MODULE$.apply("Request was not processed by the server and should not be retried");
    private static final long com$twitter$finagle$http$filter$HttpNackFilter$$NonRetryableNackFlags = FailureFlags$.MODULE$.Rejected() | FailureFlags$.MODULE$.NonRetryable();
    private static final long com$twitter$finagle$http$filter$HttpNackFilter$$RetryableNackFlags = FailureFlags$.MODULE$.Rejected() | FailureFlags$.MODULE$.Retryable();

    public Stack.Role role() {
        return role;
    }

    public String RetryableNackHeader() {
        return RetryableNackHeader;
    }

    public String NonRetryableNackHeader() {
        return NonRetryableNackHeader;
    }

    public String RetryableRequestHeader() {
        return RetryableRequestHeader;
    }

    public Status ResponseStatus() {
        return ResponseStatus;
    }

    public Buf com$twitter$finagle$http$filter$HttpNackFilter$$RetryableNackBody() {
        return com$twitter$finagle$http$filter$HttpNackFilter$$RetryableNackBody;
    }

    public Buf com$twitter$finagle$http$filter$HttpNackFilter$$NonRetryableNackBody() {
        return com$twitter$finagle$http$filter$HttpNackFilter$$NonRetryableNackBody;
    }

    public long com$twitter$finagle$http$filter$HttpNackFilter$$NonRetryableNackFlags() {
        return com$twitter$finagle$http$filter$HttpNackFilter$$NonRetryableNackFlags;
    }

    public long com$twitter$finagle$http$filter$HttpNackFilter$$RetryableNackFlags() {
        return com$twitter$finagle$http$filter$HttpNackFilter$$RetryableNackFlags;
    }

    private boolean containsRetryAfter0(Response rep) {
        Some some;
        String string;
        Option<String> option = rep.headerMap().get("Retry-After");
        boolean bl = option instanceof Some && "0".equals(string = (String)(some = (Some)option).value());
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isRetryableNack(Response rep) {
        Status status = rep.status();
        Status status2 = this.ResponseStatus();
        if (status == null) {
            if (status2 != null) {
                return false;
            }
        } else if (!((Object)status).equals(status2)) return false;
        if (rep.headerMap().contains(this.RetryableNackHeader())) return true;
        if (!this.containsRetryAfter0(rep)) return false;
        return true;
    }

    public boolean isNonRetryableNack(Response rep) {
        Status status = rep.status();
        Status status2 = this.ResponseStatus();
        return !(status != null ? !((Object)status).equals(status2) : status2 != null) && rep.headerMap().contains(this.NonRetryableNackHeader());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isNack(Response rep) {
        Status status = rep.status();
        Status status2 = this.ResponseStatus();
        if (status == null) {
            if (status2 != null) {
                return false;
            }
        } else if (!((Object)status).equals(status2)) return false;
        if (rep.headerMap().contains(this.RetryableNackHeader())) return true;
        if (!rep.headerMap().contains(this.NonRetryableNackHeader())) return false;
        return true;
    }

    public Stackable<ServiceFactory<Request, Response>> module() {
        return new Stack.Module1<Stats, ServiceFactory<Request, Response>>(){
            private final Stack.Role role;
            private final String description;

            public Stack.Role role() {
                return this.role;
            }

            public String description() {
                return this.description;
            }

            public ServiceFactory<Request, Response> make(Stats _stats, ServiceFactory<Request, Response> next) {
                StatsReceiver stats;
                Stats stats2 = _stats;
                if (stats2 == null) {
                    throw new MatchError((Object)stats2);
                }
                StatsReceiver statsReceiver = stats = stats2.statsReceiver();
                StatsReceiver stats3 = statsReceiver;
                return new HttpNackFilter(stats3).andThen(next);
            }
            {
                this.role = HttpNackFilter$.MODULE$.role();
                this.description = "Convert rejected requests to 503s, respecting retryability";
            }
        };
    }

    public SimpleFilter<Request, Response> newFilter(StatsReceiver statsReceiver) {
        return new HttpNackFilter(statsReceiver);
    }

    public boolean com$twitter$finagle$http$filter$HttpNackFilter$$retryableRequest(Request req) {
        return !req.isChunked() && (req.content().isEmpty() || req.headerMap().contains(this.RetryableRequestHeader()));
    }

    private HttpNackFilter$() {
    }
}

