/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.codec.context;

import com.twitter.finagle.context.Context;
import com.twitter.finagle.context.Contexts$;
import com.twitter.finagle.http.HeaderMap;
import com.twitter.finagle.http.Message;
import com.twitter.finagle.http.codec.context.HttpBackupRequest$;
import com.twitter.finagle.http.codec.context.HttpContext;
import com.twitter.finagle.http.codec.context.HttpDeadline$;
import com.twitter.finagle.http.codec.context.HttpRetries$;
import com.twitter.finagle.http.codec.context.LoadableHttpContext;
import com.twitter.finagle.util.LoadService$;
import com.twitter.logging.Level;
import com.twitter.logging.Logger;
import com.twitter.logging.Logger$;
import com.twitter.util.Return;
import com.twitter.util.Throw;
import com.twitter.util.Try;
import java.util.logging.Level;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

public final class HttpContext$ {
    public static final HttpContext$ MODULE$;
    private final Logger com$twitter$finagle$http$codec$context$HttpContext$$log;
    private final String Prefix;
    private final HttpContext[] knownContextTypes;
    private final HttpContext[] loadedContextTypes;
    private final HttpContext[] allContextTypes;

    static {
        new HttpContext$();
    }

    public Logger com$twitter$finagle$http$codec$context$HttpContext$$log() {
        return this.com$twitter$finagle$http$codec$context$HttpContext$$log;
    }

    public String Prefix() {
        return this.Prefix;
    }

    public void removeDeadline(Message msg) {
        msg.headerMap().remove(HttpDeadline$.MODULE$.headerKey());
    }

    public <R> R read(Message msg, Function0<R> fn) {
        Nil$ ctxValues = Nil$.MODULE$;
        for (int i = 0; i < this.allContextTypes.length; ++i) {
            BoxedUnit boxedUnit;
            Option<String> option;
            block7: {
                Try<Object> try_;
                block10: {
                    block9: {
                        BoxedUnit boxedUnit2;
                        BoxedUnit boxedUnit3;
                        HttpContext contextType;
                        block8: {
                            contextType = this.allContextTypes[i];
                            option = msg.headerMap().get(contextType.headerKey());
                            if (!(option instanceof Some)) break block7;
                            Some some = (Some)option;
                            String header = (String)some.x();
                            try_ = contextType.fromHeader(header);
                            if (!(try_ instanceof Return)) break block8;
                            Return return_ = (Return)try_;
                            Object ctxVal = return_.r();
                            Context.KeyValuePair keyValuePair = new Context.KeyValuePair((Context)Contexts$.MODULE$.broadcast(), contextType.key(), ctxVal);
                            ctxValues = ctxValues.$colon$colon((Object)keyValuePair);
                            boxedUnit3 = BoxedUnit.UNIT;
                            break block9;
                        }
                        if (!(try_ instanceof Throw)) break block10;
                        if (this.com$twitter$finagle$http$codec$context$HttpContext$$log().isLoggable((Level)Level.DEBUG$.MODULE$)) {
                            this.com$twitter$finagle$http$codec$context$HttpContext$$log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"could not unmarshal ", " from the header value"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{contextType.key()})), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                        boxedUnit3 = boxedUnit2;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw new MatchError(try_);
            }
            if (None$.MODULE$.equals(option)) {
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            throw new MatchError(option);
        }
        return (R)Contexts$.MODULE$.broadcast().let((Iterable)ctxValues, fn);
    }

    public void write(Message msg) {
        int i;
        for (i = 0; i < this.knownContextTypes.length; ++i) {
            HttpContext contextType = this.knownContextTypes[i];
            this.writeToHeader(contextType, msg.headerMap(), true);
        }
        for (i = 0; i < this.loadedContextTypes.length; ++i) {
            HttpContext contextType = this.loadedContextTypes[i];
            this.writeToHeader(contextType, msg.headerMap(), false);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeToHeader(HttpContext contextType, HeaderMap headerMap, boolean isSafe) {
        BoxedUnit boxedUnit;
        Option option = Contexts$.MODULE$.broadcast().get(contextType.key());
        if (!(option instanceof Some)) {
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            return;
        }
        Some some = (Some)option;
        Object ctxVal = some.x();
        if (isSafe) {
            headerMap.setUnsafe(contextType.headerKey(), contextType.toHeader(ctxVal));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            try {
                headerMap.set(contextType.headerKey(), contextType.toHeader(ctxVal));
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable throwable) {
                BoxedUnit boxedUnit3;
                Throwable throwable2 = throwable;
                Option option2 = NonFatal$.MODULE$.unapply(throwable2);
                if (option2.isEmpty()) {
                    throw throwable;
                }
                if (this.com$twitter$finagle$http$codec$context$HttpContext$$log().isLoggable((Level)Level.DEBUG$.MODULE$)) {
                    this.com$twitter$finagle$http$codec$context$HttpContext$$log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unable to add ", " to the header"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{contextType.key()})), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit4 = boxedUnit3;
                boxedUnit = BoxedUnit.UNIT;
            }
        }
        BoxedUnit boxedUnit5 = boxedUnit;
    }

    private HttpContext$() {
        MODULE$ = this;
        this.com$twitter$finagle$http$codec$context$HttpContext$$log = Logger$.MODULE$.apply(this.getClass().getName());
        this.Prefix = "Finagle-Ctx-";
        this.knownContextTypes = (HttpContext[])((Object[])new HttpContext[]{HttpDeadline$.MODULE$, HttpRetries$.MODULE$, HttpBackupRequest$.MODULE$});
        ArrayBuffer loaded = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        Set ctxKeys = Set$.MODULE$.empty().$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.knownContextTypes).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(HttpContext x$1) {
                return x$1.headerKey();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet());
        LoadService$.MODULE$.apply(ClassTag$.MODULE$.apply(LoadableHttpContext.class)).foreach((Function1)new Serializable(loaded, ctxKeys){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer loaded$1;
            private final Set ctxKeys$1;

            public final Object apply(LoadableHttpContext httpCtx) {
                ArrayBuffer arrayBuffer;
                if (this.ctxKeys$1.contains((Object)httpCtx.headerKey())) {
                    HttpContext$.MODULE$.com$twitter$finagle$http$codec$context$HttpContext$$log().warning(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"skipping duplicate http header context key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{httpCtx.headerKey()})), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                    arrayBuffer = BoxedUnit.UNIT;
                } else {
                    this.ctxKeys$1.$plus$eq((Object)httpCtx.headerKey());
                    arrayBuffer = this.loaded$1.$plus$eq((Object)httpCtx);
                }
                return arrayBuffer;
            }
            {
                this.loaded$1 = loaded$1;
                this.ctxKeys$1 = ctxKeys$1;
            }
        });
        this.loadedContextTypes = (HttpContext[])loaded.toArray(ClassTag$.MODULE$.apply(HttpContext.class));
        this.allContextTypes = (HttpContext[])Predef$.MODULE$.refArrayOps((Object[])this.knownContextTypes).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])this.loadedContextTypes), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(HttpContext.class)));
    }
}

