/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.codec;

import com.twitter.finagle.context.BackupRequest;
import com.twitter.finagle.context.BackupRequest$;
import com.twitter.finagle.context.Context;
import com.twitter.finagle.context.Contexts$;
import com.twitter.finagle.context.Deadline;
import com.twitter.finagle.context.Deadline$;
import com.twitter.finagle.context.Retries;
import com.twitter.finagle.context.Retries$;
import com.twitter.finagle.http.Message;
import com.twitter.logging.Level;
import com.twitter.logging.Logger;
import com.twitter.logging.Logger$;
import com.twitter.util.Time$;
import java.util.logging.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class HttpContext$ {
    public static final HttpContext$ MODULE$;
    private final String Prefix;
    private final String DeadlineHeaderKey;
    private final String RetriesHeaderKey;
    private final String BackupRequestHeaderKey;
    private final Logger com$twitter$finagle$http$codec$HttpContext$$log;
    private final Function1<String, Option<Deadline>> unmarshalDeadline;
    private final Function1<String, Option<Retries>> unmarshalRetries;
    private final BackupRequest backupRequest;

    static {
        new HttpContext$();
    }

    public Logger com$twitter$finagle$http$codec$HttpContext$$log() {
        return this.com$twitter$finagle$http$codec$HttpContext$$log;
    }

    public void removeDeadline(Message msg) {
        msg.headerMap().remove(this.DeadlineHeaderKey);
    }

    private String marshalDeadline(Deadline deadline) {
        return new StringBuilder().append(deadline.timestamp().inNanoseconds()).append((Object)" ").append((Object)BoxesRunTime.boxToLong((long)deadline.deadline().inNanoseconds())).toString();
    }

    private String marshalRetries(Retries retries) {
        return ((Object)BoxesRunTime.boxToInteger((int)retries.attempt())).toString();
    }

    private String marshalledBackupRequest() {
        return "1";
    }

    public <R> R read(Message msg, Function0<R> fn) {
        Option option;
        block7: {
            Option option2;
            block10: {
                Some some;
                String string;
                Nil$ ctxValues;
                block9: {
                    block8: {
                        block6: {
                            block5: {
                                ctxValues = Nil$.MODULE$;
                                option = msg.headerMap().get(this.DeadlineHeaderKey).flatMap(this.unmarshalDeadline);
                                if (!(option instanceof Some)) break block5;
                                Some some2 = (Some)option;
                                Deadline deadline = (Deadline)some2.x();
                                Context.KeyValuePair keyValuePair = new Context.KeyValuePair((Context)Contexts$.MODULE$.broadcast(), (Object)Deadline$.MODULE$, (Object)deadline);
                                ctxValues = ctxValues.$colon$colon((Object)keyValuePair);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block6;
                            }
                            if (!None$.MODULE$.equals(option)) break block7;
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        option2 = msg.headerMap().get(this.RetriesHeaderKey).flatMap(this.unmarshalRetries);
                        if (!(option2 instanceof Some)) break block8;
                        Some some3 = (Some)option2;
                        Retries retries = (Retries)some3.x();
                        Context.KeyValuePair keyValuePair = new Context.KeyValuePair((Context)Contexts$.MODULE$.broadcast(), (Object)Retries$.MODULE$, (Object)retries);
                        ctxValues = ctxValues.$colon$colon((Object)keyValuePair);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block9;
                    }
                    if (!None$.MODULE$.equals(option2)) break block10;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                Option<String> option3 = msg.headerMap().get(this.BackupRequestHeaderKey);
                if (option3 instanceof Some && "1".equals(string = (String)(some = (Some)option3).x())) {
                    Context.KeyValuePair keyValuePair = new Context.KeyValuePair((Context)Contexts$.MODULE$.broadcast(), (Object)BackupRequest$.MODULE$.Ctx(), (Object)this.backupRequest);
                    ctxValues = ctxValues.$colon$colon((Object)keyValuePair);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                return (R)Contexts$.MODULE$.broadcast().let((Iterable)ctxValues, fn);
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError((Object)option);
    }

    public void write(Message msg) {
        Option option;
        block6: {
            Option option2;
            block9: {
                block8: {
                    Object object;
                    block7: {
                        block5: {
                            Object object2;
                            block4: {
                                option = Deadline$.MODULE$.current();
                                if (!(option instanceof Some)) break block4;
                                Some some = (Some)option;
                                Deadline deadline = (Deadline)some.x();
                                object2 = msg.headerMap().setUnsafe(this.DeadlineHeaderKey, this.marshalDeadline(deadline));
                                break block5;
                            }
                            if (!None$.MODULE$.equals(option)) break block6;
                            object2 = BoxedUnit.UNIT;
                        }
                        option2 = Retries$.MODULE$.current();
                        if (!(option2 instanceof Some)) break block7;
                        Some some = (Some)option2;
                        Retries retries = (Retries)some.x();
                        object = msg.headerMap().setUnsafe(this.RetriesHeaderKey, this.marshalRetries(retries));
                        break block8;
                    }
                    if (!None$.MODULE$.equals(option2)) break block9;
                    object = BoxedUnit.UNIT;
                }
                if (BackupRequest$.MODULE$.wasInitiated()) {
                    msg.headerMap().setUnsafe(this.BackupRequestHeaderKey, this.marshalledBackupRequest());
                }
                return;
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError((Object)option);
    }

    private HttpContext$() {
        MODULE$ = this;
        this.Prefix = "Finagle-Ctx-";
        this.DeadlineHeaderKey = new StringBuilder().append((Object)this.Prefix).append((Object)Deadline$.MODULE$.id()).toString();
        this.RetriesHeaderKey = new StringBuilder().append((Object)this.Prefix).append((Object)Retries$.MODULE$.id()).toString();
        this.BackupRequestHeaderKey = new StringBuilder().append((Object)this.Prefix).append((Object)BackupRequest$.MODULE$.ContextId()).toString();
        this.com$twitter$finagle$http$codec$HttpContext$$log = Logger$.MODULE$.apply(this.getClass().getName());
        this.unmarshalDeadline = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<Deadline> apply(String header) {
                None$ none$;
                try {
                    String[] values = new StringOps(Predef$.MODULE$.augmentString(header)).split(' ');
                    long timestamp = new StringOps(Predef$.MODULE$.augmentString(values[0])).toLong();
                    long deadline = new StringOps(Predef$.MODULE$.augmentString(values[1])).toLong();
                    none$ = new Some((Object)new Deadline(Time$.MODULE$.fromNanoseconds(timestamp), Time$.MODULE$.fromNanoseconds(deadline)));
                }
                catch (Throwable throwable) {
                    None$ none$2;
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    if (HttpContext$.MODULE$.com$twitter$finagle$http$codec$HttpContext$$log().isLoggable((Level)Level.DEBUG$.MODULE$)) {
                        HttpContext$.MODULE$.com$twitter$finagle$http$codec$HttpContext$$log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not unmarshal Deadline from header value: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{header})), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                    }
                    none$ = none$2 = None$.MODULE$;
                }
                return none$;
            }
        };
        this.unmarshalRetries = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<Retries> apply(String header) {
                Some some;
                try {
                    some = new Some((Object)new Retries(new StringOps(Predef$.MODULE$.augmentString(header)).toInt()));
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    if (HttpContext$.MODULE$.com$twitter$finagle$http$codec$HttpContext$$log().isLoggable((Level)Level.DEBUG$.MODULE$)) {
                        HttpContext$.MODULE$.com$twitter$finagle$http$codec$HttpContext$$log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not unmarshal Retries from header value: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{header})), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                    }
                    None$ none$ = None$.MODULE$;
                    some = none$;
                }
                return some;
            }
        };
        this.backupRequest = new BackupRequest();
    }
}

