/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.codec;

import com.twitter.finagle.http.Message;
import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Response;
import com.twitter.finagle.http.Status;
import com.twitter.finagle.http.Status$;
import com.twitter.finagle.http.Status$Informational$;
import com.twitter.util.Future;
import com.twitter.util.Promise;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u000114Q!\u0001\u0002\u0001\r1\u0011a\u0003\u0013;uaF\u001auN\u001c8fGRLwN\\'b]\u0006<WM\u001d\u0006\u0003\u0007\u0011\tQaY8eK\u000eT!!\u0002\u0004\u0002\t!$H\u000f\u001d\u0006\u0003\u000f!\tqAZ5oC\u001edWM\u0003\u0002\n\u0015\u00059Ao^5ui\u0016\u0014(\"A\u0006\u0002\u0007\r|Wn\u0005\u0002\u0001\u001bA\u0011a\"E\u0007\u0002\u001f)\t\u0001#A\u0003tG\u0006d\u0017-\u0003\u0002\u0013\u001f\t1\u0011I\\=SK\u001aDQ\u0001\u0006\u0001\u0005\u0002Y\ta\u0001P5oSRt4\u0001\u0001\u000b\u0002/A\u0011\u0001\u0004A\u0007\u0002\u0005!1!\u0004\u0001Q!\nm\t1\"[:LK\u0016\u0004\u0018\t\\5wKB\u0011a\u0002H\u0005\u0003;=\u0011qAQ8pY\u0016\fg\u000e\u0003\u0004 \u0001\u0001\u0006KaG\u0001\u0007SNLE\r\\3\t\r\u0005\u0002\u0001\u0015)\u0003#\u00035\t7\r^5wKN#(/Z1ngB\u0011abI\u0005\u0003I=\u00111!\u00138u\u0011\u00191\u0003\u0001)Q\u0005E\u0005\u0001\u0002/\u001a8eS:<'+Z:q_:\u001cXm\u001d\u0005\u0007Q\u0001\u0001\u000b\u0011B\u0015\u0002\r\rdwn]3Q!\rQSfL\u0007\u0002W)\u0011A\u0006C\u0001\u0005kRLG.\u0003\u0002/W\t9\u0001K]8nSN,\u0007C\u0001\b1\u0013\t\ttB\u0001\u0003V]&$\b\"B\u001a\u0001\t\u0003!\u0014AD8cg\u0016\u0014h/Z'fgN\fw-\u001a\u000b\u0004_UZ\u0004\"\u0002\u001c3\u0001\u00049\u0014aB7fgN\fw-\u001a\t\u0003qej\u0011\u0001B\u0005\u0003u\u0011\u0011q!T3tg\u0006<W\rC\u0003=e\u0001\u0007Q(\u0001\u0005p]\u001aKg.[:i!\rQchL\u0005\u0003\u007f-\u0012aAR;ukJ,\u0007BB!\u0001A\u0013%!)\u0001\bpEN,'O^3SKF,Xm\u001d;\u0015\u0007=\u001a\u0005\nC\u0003E\u0001\u0002\u0007Q)A\u0004sKF,Xm\u001d;\u0011\u0005a2\u0015BA$\u0005\u0005\u001d\u0011V-];fgRDQ\u0001\u0010!A\u0002uBaA\u0013\u0001!\n\u0013Y\u0015aD8cg\u0016\u0014h/\u001a*fgB|gn]3\u0015\u0007=b\u0015\u000bC\u0003N\u0013\u0002\u0007a*\u0001\u0005sKN\u0004xN\\:f!\tAt*\u0003\u0002Q\t\tA!+Z:q_:\u001cX\rC\u0003=\u0013\u0002\u0007Q\b\u0003\u0004T\u0001\u0001&I\u0001V\u0001\u000fQ\u0006tG\r\\3JMN#(/Z1n)\tyS\u000bC\u0003=%\u0002\u0007Q\b\u0003\u0004X\u0001\u0001&I\u0001W\u0001\nK:$7\u000b\u001e:fC6$\u0012a\f\u0005\u00065\u0002!\taW\u0001\fg\"|W\u000f\u001c3DY>\u001cX-F\u0001\u001c\u0011\u0015i\u0006\u0001\"\u0001_\u0003\u001dygn\u00117pg\u0016,\u0012!\u0010\u0005\u0007A\u0002\u0001K\u0011B1\u0002#5,8\u000f^\"m_N,wJ\u001c$j]&\u001c\b\u000e\u0006\u0002\u001cE\")1m\u0018a\u0001\u001d\u0006!!/Z:q\u0011\u0019)\u0007\u0001)C\u0005M\u0006qQ.Y=ICZ,7i\u001c8uK:$HCA\u000eh\u0011\u0015AG\r1\u0001j\u0003\u0019\u0019H/\u0019;vgB\u0011\u0001H[\u0005\u0003W\u0012\u0011aa\u0015;biV\u001c\b")
public class Http1ConnectionManager {
    private boolean isKeepAlive = true;
    private boolean isIdle = true;
    private int activeStreams = 0;
    private int pendingResponses = 0;
    public final Promise<BoxedUnit> com$twitter$finagle$http$codec$Http1ConnectionManager$$closeP = new Promise();

    public synchronized void observeMessage(Message message, Future<BoxedUnit> onFinish) {
        Message message2 = message;
        if (message2 instanceof Request) {
            Request request = (Request)message2;
            this.observeRequest(request, onFinish);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (message2 instanceof Response) {
            Response response = (Response)message2;
            this.observeResponse(response, onFinish);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.isKeepAlive = false;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private synchronized void observeRequest(Request request, Future<BoxedUnit> onFinish) {
        ++this.pendingResponses;
        this.isIdle = false;
        this.isKeepAlive = request.keepAlive();
        this.handleIfStream(onFinish);
    }

    private synchronized void observeResponse(Response response, Future<BoxedUnit> onFinish) {
        --this.pendingResponses;
        if (!this.isKeepAlive || this.mustCloseOnFinish(response) || !response.keepAlive()) {
            response.headerMap().setUnsafe("Connection", "close");
            this.isKeepAlive = false;
        }
        this.isIdle = !response.isChunked();
        this.handleIfStream(onFinish);
    }

    private void handleIfStream(Future<BoxedUnit> onFinish) {
        if (onFinish.isDefined()) {
            if (this.shouldClose()) {
                this.com$twitter$finagle$http$codec$Http1ConnectionManager$$closeP.setDone(Predef$.MODULE$.$conforms());
            }
        } else {
            ++this.activeStreams;
            onFinish.ensure((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Http1ConnectionManager $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.com$twitter$finagle$http$codec$Http1ConnectionManager$$endStream();
                    if (this.$outer.shouldClose()) {
                        this.$outer.com$twitter$finagle$http$codec$Http1ConnectionManager$$closeP.setDone(Predef$.MODULE$.$conforms());
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
    }

    public synchronized void com$twitter$finagle$http$codec$Http1ConnectionManager$$endStream() {
        --this.activeStreams;
        this.isIdle = this.activeStreams == 0 && this.pendingResponses == 0;
    }

    public synchronized boolean shouldClose() {
        return this.isIdle && !this.isKeepAlive;
    }

    public Future<BoxedUnit> onClose() {
        return this.com$twitter$finagle$http$codec$Http1ConnectionManager$$closeP;
    }

    private boolean mustCloseOnFinish(Response resp) {
        return this.mayHaveContent(resp.status()) && !resp.isChunked() && !resp.headerMap().contains("Content-Length");
    }

    private boolean mayHaveContent(Status status) {
        boolean bl;
        Status status2 = status;
        Option<Status> option = Status$Informational$.MODULE$.unapply(status2);
        if (option.isEmpty()) {
            Status status3 = Status$.MODULE$.NoContent();
            Status status4 = status2;
            if (!(status3 != null ? !((Object)status3).equals(status4) : status4 != null)) {
                bl = false;
            } else {
                Status status5 = Status$.MODULE$.NotModified();
                Status status6 = status2;
                bl = status5 != null ? !((Object)status5).equals(status6) : status6 != null;
            }
        } else {
            bl = false;
        }
        return bl;
    }
}

