/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.codec;

import com.twitter.finagle.Service;
import com.twitter.finagle.SimpleFilter;
import com.twitter.finagle.http.Method;
import com.twitter.finagle.http.Method$;
import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Response;
import com.twitter.finagle.http.Status;
import com.twitter.finagle.http.Status$;
import com.twitter.finagle.http.Version;
import com.twitter.finagle.http.Version$;
import com.twitter.logging.Logger;
import com.twitter.logging.Logger$;
import com.twitter.util.Future;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;

public final class ResponseConformanceFilter$
extends SimpleFilter<Request, Response> {
    public static final ResponseConformanceFilter$ MODULE$;
    private final Logger logger;

    static {
        new ResponseConformanceFilter$();
    }

    public Future<Response> apply(Request request, Service<Request, Response> service) {
        return service.apply((Object)request).map((Function1)new Serializable(request){
            public static final long serialVersionUID = 0L;
            private final Request request$1;

            public final Response apply(Response rep) {
                ResponseConformanceFilter$.MODULE$.com$twitter$finagle$http$codec$ResponseConformanceFilter$$validate(this.request$1, rep);
                return rep;
            }
            {
                this.request$1 = request$1;
            }
        });
    }

    public void com$twitter$finagle$http$codec$ResponseConformanceFilter$$validate(Request req, Response rep) {
        Method method = req.method();
        Method method2 = Method$.MODULE$.Head();
        if (!(method != null ? !((Object)method).equals(method2) : method2 != null)) {
            this.handleHeadResponse(req, rep);
        } else if (this.mustNotIncludeMessageBody(rep.status())) {
            this.handleNoMessageResponse(rep);
        } else if (rep.isChunked()) {
            this.handleChunkedResponse(rep);
        } else {
            this.handleFullyBufferedResponse(rep);
        }
    }

    private void handleNoMessageResponse(Response rep) {
        int contentLength2 = rep.length();
        if (contentLength2 > 0) {
            rep.clearContent();
            this.logger.info("Response with a status code of %d must not have a body-message but it has a %d-byte payload, thus the content has been removed.", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)rep.statusCode()), BoxesRunTime.boxToInteger((int)contentLength2)}));
        }
        Status status = rep.status();
        Status status2 = Status$.MODULE$.NotModified();
        if ((status == null ? status2 != null : !((Object)status).equals(status2)) && rep.contentLength().isDefined()) {
            long contentLength3 = rep.contentLengthOrElse(-1L);
            rep.headerMap().remove("Content-Length");
            this.logger.info("Response with a status code of %d must not have a Content-Length header field thus the field has been removed. Content-Length: %d", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)rep.statusCode()), BoxesRunTime.boxToLong((long)contentLength3)}));
        }
    }

    private boolean mustNotIncludeMessageBody(Status status) {
        boolean bl;
        Status status2 = status;
        Status status3 = Status$.MODULE$.NoContent();
        Status status4 = status2;
        if (!(status3 != null ? !((Object)status3).equals(status4) : status4 != null)) {
            bl = true;
        } else {
            Status status5 = Status$.MODULE$.NotModified();
            Status status6 = status2;
            bl = !(status5 != null ? !((Object)status5).equals(status6) : status6 != null);
        }
        boolean bl2 = bl ? true : 100 <= status.code() && status.code() < 200;
        return bl2;
    }

    private void handleFullyBufferedResponse(Response rep) {
        if (rep.contentLength().isEmpty()) {
            rep.contentLength_$eq(rep.content().length());
        }
    }

    private void handleChunkedResponse(Response rep) {
        Version version = rep.version();
        Version version2 = Version$.MODULE$.Http10();
        if (!(version != null ? !((Object)version).equals(version2) : version2 != null)) {
            rep.headerMap().remove("Transfer-Encoding");
        } else if (rep.headerMap().getAll("Transfer-Encoding").contains((Object)"chunked")) {
            rep.headerMap().remove("Content-Length");
        } else if (!rep.headerMap().contains("Content-Length")) {
            rep.headerMap().addUnsafe("Transfer-Encoding", "chunked");
        }
    }

    private void handleHeadResponse(Request request, Response response) {
        response.headerMap().remove("Transfer-Encoding");
        if (response.isChunked()) {
            response.reader().discard();
            response.setChunked(false);
        }
        if (!response.content().isEmpty()) {
            this.logger.info("Received response to HEAD request (%s) that contained a static body of length %d. Discarding body. If this is desired behavior, consider adding HeadFilter to your service", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{request.toString(), BoxesRunTime.boxToInteger((int)response.content().length())}));
            if (response.contentLength().isEmpty()) {
                response.contentLength_$eq(response.content().length());
            }
            response.clearContent();
        }
    }

    private ResponseConformanceFilter$() {
        MODULE$ = this;
        this.logger = Logger$.MODULE$.get(((Object)((Object)this)).getClass().getName());
    }
}

