/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http;

import com.twitter.finagle.http.DefaultHeaderMap;
import com.twitter.finagle.http.HeaderMap;
import com.twitter.logging.Logger;
import com.twitter.logging.Logger$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class DefaultHeaderMap$ {
    public static final DefaultHeaderMap$ MODULE$;
    private final Logger logger;
    private final Regex ObsFoldRegex;

    static {
        new DefaultHeaderMap$();
    }

    public Regex ObsFoldRegex() {
        return this.ObsFoldRegex;
    }

    private final char MaxValueChar() {
        return '\u00ff';
    }

    public void com$twitter$finagle$http$DefaultHeaderMap$$validateName(String s) {
        if (s == null) {
            throw new NullPointerException("Header names cannot be null");
        }
        block3: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c > '\u007f') {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Header '", "': name cannot contain non-ASCII characters: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s, BoxesRunTime.boxToCharacter((char)c)})));
            }
            char c2 = c;
            switch (c2) {
                default: {
                    continue block3;
                }
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': 
                case ',': 
                case ':': 
                case ';': 
                case '=': 
            }
            throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Header '", "': name cannot contain the following prohibited characters: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s}))).append((Object)"=,;: \\t\\r\\n\\v\\f ").toString());
        }
    }

    public String com$twitter$finagle$http$DefaultHeaderMap$$foldReplacingValidateValue(String name, String value) {
        String string;
        if (value == null) {
            throw new NullPointerException("Header values cannot be null");
        }
        int state = 0;
        boolean foldDetected = false;
        block9: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c > this.MaxValueChar()) {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Header '", "': value contains illegal character '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, BoxesRunTime.boxToCharacter((char)c)})));
            }
            char c2 = c;
            switch (c2) {
                default: {
                    int n = state;
                    switch (n) {
                        default: {
                            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                        }
                        case 2: {
                            if (c == '\t' || c == ' ') {
                                foldDetected = true;
                                state = 0;
                                continue block9;
                            }
                            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Header '", "': only ' ' and '\\\\t' are allowed after '\\\\n' in value"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
                        }
                        case 1: {
                            if (c == '\n') {
                                state = 2;
                                continue block9;
                            }
                            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Header '", "': only '\\\\n' is allowed after '\\\\r' in value"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
                        }
                        case 0: {
                            if (c == '\r') {
                                state = 1;
                                continue block9;
                            }
                            if (c != '\n') continue block9;
                            state = 2;
                        }
                    }
                    continue block9;
                }
                case '\f': {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Header '", "': value contains a prohibited character '\\\\f'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
                }
                case '\u000b': 
            }
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Header '", "': value contains a prohibited character '\\\\v'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
        }
        if (state != 0) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Header '", "': value must not end with '\\\\r' or '\\\\n'. Observed: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name}))).append((Object)(state == 1 ? "\\r" : "\\n")).toString());
        }
        if (foldDetected) {
            this.logger.debug("`obs-fold` sequence replaced.", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            string = this.ObsFoldRegex().replaceAllIn((CharSequence)value, " ");
        } else {
            string = value;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public HeaderMap apply(Seq<Tuple2<String, String>> headers) {
        void var2_2;
        DefaultHeaderMap result = new DefaultHeaderMap();
        headers.foreach((Function1)new Serializable(result){
            public static final long serialVersionUID = 0L;
            private final DefaultHeaderMap result$1;

            public final HeaderMap apply(Tuple2<String, String> t) {
                return this.result$1.add((String)t._1(), (String)t._2());
            }
            {
                this.result$1 = result$1;
            }
        });
        return var2_2;
    }

    private DefaultHeaderMap$() {
        MODULE$ = this;
        this.logger = Logger$.MODULE$.get(DefaultHeaderMap.class);
        this.ObsFoldRegex = new StringOps(Predef$.MODULE$.augmentString("\r?\n[\t ]+")).r();
    }
}

