/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.netty4;

import com.twitter.conversions.time$;
import com.twitter.finagle.http.Cookie;
import com.twitter.finagle.http.Cookie$;
import com.twitter.finagle.http.CookieCodec;
import com.twitter.finagle.http.CookieMap$;
import com.twitter.finagle.http.cookie.SameSite;
import com.twitter.finagle.http.cookie.SameSiteCodec$;
import com.twitter.util.Duration;
import io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import java.util.BitSet;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;

public final class Netty4CookieCodec$
extends CookieCodec {
    public static final Netty4CookieCodec$ MODULE$;
    private final ClientCookieEncoder clientEncoder;
    private final ServerCookieEncoder serverEncoder;
    private final ClientCookieDecoder clientDecoder;
    private final ServerCookieDecoder serverDecoder;
    private final BitSet ShouldWrapCharsBitSet;
    private final Function1<Cookie, io.netty.handler.codec.http.cookie.Cookie> cookieToNetty;
    private final Function1<io.netty.handler.codec.http.cookie.Cookie, Cookie> cookieToFinagle;

    static {
        new Netty4CookieCodec$();
    }

    @Override
    public String encodeClient(Iterable<Cookie> cookies) {
        return cookies.isEmpty() ? "" : this.clientEncoder.encode((java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter((Iterable)cookies.map(this.cookieToNetty(), Iterable$.MODULE$.canBuildFrom())).asJava());
    }

    @Override
    public String encodeServer(Cookie cookie) {
        String encoded = this.serverEncoder.encode((io.netty.handler.codec.http.cookie.Cookie)this.cookieToNetty().apply((Object)cookie));
        return CookieMap$.MODULE$.includeSameSite() ? SameSiteCodec$.MODULE$.encodeSameSite(cookie, encoded) : encoded;
    }

    @Override
    public Option<Iterable<Cookie>> decodeClient(String header) {
        None$ none$;
        io.netty.handler.codec.http.cookie.Cookie cookie = this.clientDecoder.decode(header);
        if (cookie == null) {
            none$ = None$.MODULE$;
        } else {
            Cookie decoded = (Cookie)this.cookieToFinagle().apply((Object)cookie);
            Cookie finagleCookie = CookieMap$.MODULE$.includeSameSite() ? SameSiteCodec$.MODULE$.decodeSameSite(header, decoded) : decoded;
            none$ = new Some((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Cookie[]{finagleCookie})));
        }
        return none$;
    }

    @Override
    public Option<Iterable<Cookie>> decodeServer(String header) {
        Set cookies = (Set)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(this.serverDecoder.decode(header)).asScala()).map(this.cookieToFinagle(), Set$.MODULE$.canBuildFrom());
        return cookies.isEmpty() ? None$.MODULE$ : new Some((Object)cookies);
    }

    public boolean com$twitter$finagle$http$netty4$Netty4CookieCodec$$shouldWrap(Cookie cookie) {
        return Cookie$.MODULE$.stringContains(cookie.value(), this.ShouldWrapCharsBitSet);
    }

    public Function1<Cookie, io.netty.handler.codec.http.cookie.Cookie> cookieToNetty() {
        return this.cookieToNetty;
    }

    public Function1<io.netty.handler.codec.http.cookie.Cookie, Cookie> cookieToFinagle() {
        return this.cookieToFinagle;
    }

    /*
     * WARNING - void declaration
     */
    private Netty4CookieCodec$() {
        void var1_1;
        MODULE$ = this;
        this.clientEncoder = ClientCookieEncoder.STRICT;
        this.serverEncoder = ServerCookieEncoder.STRICT;
        this.clientDecoder = ClientCookieDecoder.STRICT;
        this.serverDecoder = ServerCookieDecoder.STRICT;
        BitSet bs = new BitSet();
        new StringOps(Predef$.MODULE$.augmentString("()/:<?@[]=>{}")).foreach((Function1)new Serializable(bs){
            public static final long serialVersionUID = 0L;
            private final BitSet bs$1;

            public final void apply(char x$1) {
                this.bs$1.set(x$1);
            }
            {
                this.bs$1 = bs$1;
            }
        });
        this.ShouldWrapCharsBitSet = var1_1;
        this.cookieToNetty = new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             */
            public final DefaultCookie apply(Cookie c) {
                void var2_2;
                DefaultCookie nc = new DefaultCookie(c.name(), c.value());
                nc.setDomain(c.domain());
                nc.setPath(c.path());
                Duration duration = c.maxAge();
                Duration duration2 = Cookie$.MODULE$.DefaultMaxAge();
                if (duration == null ? duration2 != null : !duration.equals(duration2)) {
                    nc.setMaxAge((long)c.maxAge().inSeconds());
                }
                nc.setSecure(c.secure());
                nc.setHttpOnly(c.httpOnly());
                if (Netty4CookieCodec$.MODULE$.com$twitter$finagle$http$netty4$Netty4CookieCodec$$shouldWrap(c)) {
                    nc.setWrap(true);
                }
                return var2_2;
            }
        };
        this.cookieToFinagle = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Cookie apply(io.netty.handler.codec.http.cookie.Cookie nc) {
                String x$2 = nc.name();
                String x$3 = nc.value();
                Option x$4 = Option$.MODULE$.apply((Object)nc.domain());
                Option x$5 = Option$.MODULE$.apply((Object)nc.path());
                boolean x$6 = nc.isSecure();
                boolean x$7 = nc.isHttpOnly();
                Option<Duration> x$8 = Cookie$.MODULE$.$lessinit$greater$default$5();
                SameSite x$9 = Cookie$.MODULE$.$lessinit$greater$default$8();
                Cookie cookie = new Cookie(x$2, x$3, (Option<String>)x$4, (Option<String>)x$5, x$8, x$6, x$7, x$9);
                return nc.maxAge() != Long.MIN_VALUE ? cookie.maxAge((Option<Duration>)new Some((Object)time$.MODULE$.longToTimeableNumber(nc.maxAge()).seconds())) : cookie;
            }
        };
    }
}

