/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http;

import com.twitter.finagle.http.Cookie;
import com.twitter.finagle.http.CookieMap;
import com.twitter.finagle.http.HeaderMap;
import com.twitter.finagle.http.Message$;
import com.twitter.finagle.http.Method;
import com.twitter.finagle.http.Version;
import com.twitter.finagle.http.Version$;
import com.twitter.finagle.http.util.StringUtil$;
import com.twitter.io.Buf;
import com.twitter.io.Buf$;
import com.twitter.io.BufInputStream;
import com.twitter.util.Closable;
import com.twitter.util.Duration;
import com.twitter.util.Future;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Iterator;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0011=e!B\u0001\u0003\u0003\u0003Y!aB'fgN\fw-\u001a\u0006\u0003\u0007\u0011\tA\u0001\u001b;ua*\u0011QAB\u0001\bM&t\u0017m\u001a7f\u0015\t9\u0001\"A\u0004uo&$H/\u001a:\u000b\u0003%\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\u0007\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g\u0011\u0015\u0019\u0002\u0001\"\u0001\u0015\u0003\u0019a\u0014N\\5u}Q\tQ\u0003\u0005\u0002\u0017\u00015\t!\u0001\u0003\u0004\u0019\u0001\u0001\u0006K!G\u0001\t?\u000e|g\u000e^3oiB\u0011!$H\u0007\u00027)\u0011ADB\u0001\u0003S>L!AH\u000e\u0003\u0007\t+h\r\u0003\u0004!\u0001\u0001\u0006K!I\u0001\t?Z,'o]5p]B\u0011aCI\u0005\u0003G\t\u0011qAV3sg&|g\u000e\u0003\u0004&\u0001\u0001\u0006KAJ\u0001\t?\u000eDWO\\6fIB\u0011QbJ\u0005\u0003Q9\u0011qAQ8pY\u0016\fg\u000eC\u0003+\u0001\u0019\u00051&\u0001\u0004sK\u0006$WM]\u000b\u0002YA\u0019!$L\r\n\u00059Z\"A\u0002*fC\u0012,'\u000fC\u00031\u0001\u0019\u0005\u0011'\u0001\u0004xe&$XM]\u000b\u0002eI\u00191'\u000e\u001d\u0007\tQ\u0002\u0001A\r\u0002\ryI,g-\u001b8f[\u0016tGO\u0010\t\u00045YJ\u0012BA\u001c\u001c\u0005\u00199&/\u001b;feB\u0011\u0011\bP\u0007\u0002u)\u00111HB\u0001\u0005kRLG.\u0003\u0002>u\tA1\t\\8tC\ndW\rC\u0003@\u0001\u0019\u0005\u0001)A\u0005jgJ+\u0017/^3tiV\ta\u0005C\u0003C\u0001\u0011\u0005\u0001)\u0001\u0006jgJ+7\u000f]8og\u0016DQ\u0001\u0012\u0001\u0005\u0002\u0015\u000bqaY8oi\u0016tG/F\u0001\u001a\u0011\u00159\u0005\u0001\"\u0001I\u0003-\u0019wN\u001c;f]R|F%Z9\u0015\u0005%c\u0005CA\u0007K\u0013\tYeB\u0001\u0003V]&$\b\"\u0002#G\u0001\u0004I\u0002f\u0001$O3B\u0019QbT)\n\u0005As!A\u0002;ie><8\u000f\u0005\u0002S/6\t1K\u0003\u0002U+\u0006!A.\u00198h\u0015\u00051\u0016\u0001\u00026bm\u0006L!\u0001W*\u0003+%cG.Z4bYN#\u0018\r^3Fq\u000e,\u0007\u000f^5p]F\"aDW1{!\tYfL\u0004\u0002\u000e9&\u0011QLD\u0001\u0007!J,G-\u001a4\n\u0005}\u0003'AB*ue&twM\u0003\u0002^\u001dE*1E\u00194vOV\u00111\rZ\u000b\u00025\u0012)QM\u0003b\u0001U\n\tA+\u0003\u0002hQ\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIER!!\u001b\b\u0002\rQD'o\\<t#\tYg\u000e\u0005\u0002\u000eY&\u0011QN\u0004\u0002\b\u001d>$\b.\u001b8h!\ty'O\u0004\u0002\u000ea&\u0011\u0011OD\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0019HOA\u0005UQJ|w/\u00192mK*\u0011\u0011OD\u0019\u0006GY<\b0\u001b\b\u0003\u001b]L!!\u001b\b2\t\tja\"\u001f\u0002\u0006g\u000e\fG.Y\u0019\u0003MECQ\u0001\u0012\u0001\u0005\u0006q$\"! @\u000e\u0003\u0001AQ\u0001R>A\u0002eACa\u001f(\u0002\u0002E2aDWA\u0002\u0003\u0013\tda\t2g\u0003\u000b9\u0017GB\u0012wo\u0006\u001d\u0011.\r\u0003#\u001b9I\u0018G\u0001\u0014R\u0011\u001d\ti\u0001\u0001C\u0001\u0003\u001f\tqA^3sg&|g.F\u0001\"\u0011\u001d\t\u0019\u0002\u0001C\u0001\u0003+\t1B^3sg&|gn\u0018\u0013fcR\u0019\u0011*a\u0006\t\u000f\u00055\u0011\u0011\u0003a\u0001C!9\u0011Q\u0002\u0001\u0005\u0006\u0005mAcA?\u0002\u001e!9\u0011QBA\r\u0001\u0004\t\u0003BBA\u0011\u0001\u0011\u0005\u0001)A\u0005jg\u000eCWO\\6fI\"9\u0011Q\u0005\u0001\u0005\u0002\u0005\u001d\u0012AC:fi\u000eCWO\\6fIR\u0019\u0011*!\u000b\t\u000f\u0005-\u00121\u0005a\u0001M\u000591\r[;oW\u0016$\u0007bBA\u0018\u0001\u0019\u0005\u0011\u0011G\u0001\nQ\u0016\fG-\u001a:NCB,\"!a\r\u0011\u0007Y\t)$C\u0002\u00028\t\u0011\u0011\u0002S3bI\u0016\u0014X*\u00199\t\u0015\u0005m\u0002\u0001#b\u0001\n\u0003\ti$A\u0004d_>\\\u0017.Z:\u0016\u0005\u0005}\u0002c\u0001\f\u0002B%\u0019\u00111\t\u0002\u0003\u0013\r{wn[5f\u001b\u0006\u0004\bBCA$\u0001!\u0005\t\u0015)\u0003\u0002@\u0005A1m\\8lS\u0016\u001c\b\u0005C\u0004\u0002L\u0001!\t!!\u0014\u0002\u0015\u001d,GoQ8pW&,7\u000f\u0006\u0002\u0002PA1\u0011\u0011KA+\u00033j!!a\u0015\u000b\u0005m*\u0016\u0002BA,\u0003'\u0012\u0001\"\u0013;fe\u0006$xN\u001d\t\u0004-\u0005m\u0013bAA/\u0005\t11i\\8lS\u0016Dq!!\u0019\u0001\t\u0003\t\u0019'A\u0005bI\u0012\u001cun\\6jKR\u0019\u0011*!\u001a\t\u0011\u0005\u001d\u0014q\fa\u0001\u00033\naaY8pW&,\u0007bBA6\u0001\u0011\u0005\u0011QN\u0001\re\u0016lwN^3D_>\\\u0017.\u001a\u000b\u0004\u0013\u0006=\u0004bBA9\u0003S\u0002\rAW\u0001\u0005]\u0006lW\rC\u0004\u0002v\u0001!\t!a\u001e\u0002\r\u0005\u001c7-\u001a9u+\t\tI\bE\u0003\u0002|\u0005\u001d%LD\u0002\u0002~AtA!a \u0002\u00066\u0011\u0011\u0011\u0011\u0006\u0004\u0003\u0007S\u0011A\u0002\u001fs_>$h(C\u0001\u0010\u0013\r\tI\t\u001e\u0002\u0004'\u0016\f\bbBAG\u0001\u0011\u0005\u0011qR\u0001\u000bC\u000e\u001cW\r\u001d;`I\u0015\fHcA%\u0002\u0012\"9\u00111SAF\u0001\u0004Q\u0016!\u0002<bYV,\u0007bBAG\u0001\u0011\u0005\u0011q\u0013\u000b\u0004\u0013\u0006e\u0005\u0002CAN\u0003+\u0003\r!!(\u0002\rY\fG.^3t!\u0015\tY(a([\u0013\r\t\t\u000b\u001e\u0002\t\u0013R,'/\u00192mK\"9\u0011Q\u0015\u0001\u0005\u0002\u0005]\u0014\u0001E1dG\u0016\u0004H/T3eS\u0006$\u0016\u0010]3t\u0011\u001d\tI\u000b\u0001C\u0001\u0003W\u000bQ!\u00197m_^,\"!!,\u0011\t5\tyKW\u0005\u0004\u0003cs!AB(qi&|g\u000eC\u0004\u00026\u0002!\t!a.\u0002\u0013\u0005dGn\\<`I\u0015\fHcA%\u0002:\"9\u00111SAZ\u0001\u0004Q\u0006bBA[\u0001\u0011\u0005\u0011Q\u0018\u000b\u0004\u0013\u0006}\u0006\u0002CAN\u0003w\u0003\r!!1\u0011\r\u0005m\u0014qTAb!\r1\u0012QY\u0005\u0004\u0003\u000f\u0014!AB'fi\"|G\rC\u0004\u0002L\u0002!\t!a+\u0002\u001b\u0005,H\u000f[8sSj\fG/[8o\u0011\u001d\ty\r\u0001C\u0001\u0003#\f\u0011#Y;uQ>\u0014\u0018N_1uS>tw\fJ3r)\rI\u00151\u001b\u0005\b\u0003'\u000bi\r1\u0001[\u0011\u001d\t9\u000e\u0001C\u0001\u0003W\u000bAbY1dQ\u0016\u001cuN\u001c;s_2Dq!a7\u0001\t\u0003\ti.\u0001\tdC\u000eDWmQ8oiJ|Gn\u0018\u0013fcR\u0019\u0011*a8\t\u000f\u0005M\u0015\u0011\u001ca\u00015\"9\u00111\u001c\u0001\u0005\u0002\u0005\rHcA%\u0002f\"A\u0011q]Aq\u0001\u0004\tI/\u0001\u0004nCb\fu-\u001a\t\u0004s\u0005-\u0018bAAwu\tAA)\u001e:bi&|g\u000eC\u0004\u0002r\u0002!\t!a+\u0002\u000f\rD\u0017M]:fi\"9\u0011Q\u001f\u0001\u0005\u0002\u0005]\u0018aC2iCJ\u001cX\r^0%KF$2!SA}\u0011\u001d\t\u0019*a=A\u0002iCq!!@\u0001\t\u0003\ty0A\u0007d_:$XM\u001c;MK:<G\u000f[\u000b\u0003\u0005\u0003\u0001R!DAX\u0005\u0007\u00012!\u0004B\u0003\u0013\r\u00119A\u0004\u0002\u0005\u0019>tw\rC\u0004\u0003\f\u0001!)A!\u0004\u0002'\r|g\u000e^3oi2+gn\u001a;i\u001fJ,En]3\u0015\t\t\r!q\u0002\u0005\t\u0005#\u0011I\u00011\u0001\u0003\u0004\u00059A-\u001a4bk2$\bb\u0002B\u000b\u0001\u0011\u0005!qC\u0001\u0012G>tG/\u001a8u\u0019\u0016tw\r\u001e5`I\u0015\fHcA%\u0003\u001a!A\u00111\u0013B\n\u0001\u0004\u0011\u0019\u0001C\u0004\u0002~\u0002!)A!\b\u0015\u0007u\u0014y\u0002\u0003\u0005\u0002\u0014\nm\u0001\u0019\u0001B\u0002\u0011\u001d\u0011\u0019\u0003\u0001C\u0001\u0003W\u000b1bY8oi\u0016tG\u000fV=qK\"9!q\u0005\u0001\u0005\u0002\t%\u0012aD2p]R,g\u000e\u001e+za\u0016|F%Z9\u0015\u0007%\u0013Y\u0003C\u0004\u0002\u0014\n\u0015\u0002\u0019\u0001.\t\u000f\t=\u0002\u0001\"\u0001\u00032\u0005q1/\u001a;D_:$XM\u001c;UsB,G#B%\u00034\t]\u0002b\u0002B\u001b\u0005[\u0001\rAW\u0001\n[\u0016$\u0017.\u0019+za\u0016D\u0011\"!=\u0003.A\u0005\t\u0019\u0001.\t\u000f\tm\u0002\u0001\"\u0001\u0003>\u0005\u00112/\u001a;D_:$XM\u001c;UsB,'j]8o)\u0005I\u0005b\u0002B!\u0001\u0011\u0005\u00111V\u0001\u0005I\u0006$X\rC\u0004\u0003F\u0001!\tAa\u0012\u0002\u0011\u0011\fG/Z0%KF$2!\u0013B%\u0011\u001d\t\u0019Ja\u0011A\u0002iCqA!\u0012\u0001\t\u0003\u0011i\u0005F\u0002J\u0005\u001fB\u0001\"a%\u0003L\u0001\u0007!\u0011\u000b\t\u0005\u0003#\u0012\u0019&\u0003\u0003\u0003V\u0005M#\u0001\u0002#bi\u0016DqA!\u0017\u0001\t\u0003\tY+A\u0004fqBL'/Z:\t\u000f\tu\u0003\u0001\"\u0001\u0003`\u0005YQ\r\u001f9je\u0016\u001cx\fJ3r)\rI%\u0011\r\u0005\b\u0003'\u0013Y\u00061\u0001[\u0011\u001d\u0011i\u0006\u0001C\u0001\u0005K\"2!\u0013B4\u0011!\t\u0019Ja\u0019A\u0002\tE\u0003b\u0002B6\u0001\u0011\u0005\u00111V\u0001\u0005Q>\u001cH\u000fC\u0004\u0003p\u0001!\tA!\u001d\u0002\u0011!|7\u000f^0%KF$2!\u0013B:\u0011\u001d\t\u0019J!\u001cA\u0002iCqAa\u001b\u0001\t\u000b\u00119\bF\u0002~\u0005sBq!a%\u0003v\u0001\u0007!\fC\u0004\u0003~\u0001!\t!a+\u0002\u00191\f7\u000f^'pI&4\u0017.\u001a3\t\u000f\t\u0005\u0005\u0001\"\u0001\u0003\u0004\u0006\u0001B.Y:u\u001b>$\u0017NZ5fI~#S-\u001d\u000b\u0004\u0013\n\u0015\u0005bBAJ\u0005\u007f\u0002\rA\u0017\u0005\b\u0005\u0003\u0003A\u0011\u0001BE)\rI%1\u0012\u0005\t\u0003'\u00139\t1\u0001\u0003R!9!q\u0012\u0001\u0005\u0002\u0005-\u0016\u0001\u00037pG\u0006$\u0018n\u001c8\t\u000f\tM\u0005\u0001\"\u0001\u0003\u0016\u0006aAn\\2bi&|gn\u0018\u0013fcR\u0019\u0011Ja&\t\u000f\u0005M%\u0011\u0013a\u00015\"9!Q\u0007\u0001\u0005\u0002\u0005-\u0006b\u0002BO\u0001\u0011\u0005!qT\u0001\u000e[\u0016$\u0017.\u0019+za\u0016|F%Z9\u0015\u0007%\u0013\t\u000bC\u0004\u0002\u0014\nm\u0005\u0019\u0001.\t\u000f\t\u0015\u0006\u0001\"\u0001\u0002,\u00069!/\u001a4fe\u0016\u0014\bb\u0002BU\u0001\u0011\u0005!1V\u0001\fe\u00164WM]3s?\u0012*\u0017\u000fF\u0002J\u0005[Cq!a%\u0003(\u0002\u0007!\fC\u0004\u00032\u0002!\t!a+\u0002\u0015I,GO]=BMR,'\u000fC\u0004\u00036\u0002!\tAa.\u0002\u001dI,GO]=BMR,'o\u0018\u0013fcR\u0019\u0011J!/\t\u000f\u0005M%1\u0017a\u00015\"9!Q\u0017\u0001\u0005\u0002\tuFcA%\u0003@\"A\u00111\u0013B^\u0001\u0004\u0011\u0019\u0001C\u0004\u0003D\u0002!\t!a+\u0002\rM,'O^3s\u0011\u001d\u00119\r\u0001C\u0001\u0005\u0013\f!b]3sm\u0016\u0014x\fJ3r)\rI%1\u001a\u0005\b\u0003'\u0013)\r1\u0001[\u0011\u001d\u0011y\r\u0001C\u0001\u0003W\u000b\u0011\"^:fe\u0006;WM\u001c;\t\u000f\tM\u0007\u0001\"\u0001\u0003V\u0006iQo]3s\u0003\u001e,g\u000e^0%KF$2!\u0013Bl\u0011\u001d\t\u0019J!5A\u0002iCqAa7\u0001\t\u0003\tY+A\bxo^\fU\u000f\u001e5f]RL7-\u0019;f\u0011\u001d\u0011y\u000e\u0001C\u0001\u0005C\f1c^<x\u0003V$\b.\u001a8uS\u000e\fG/Z0%KF$2!\u0013Br\u0011\u001d\t\u0019J!8A\u0002iCqAa:\u0001\t\u0003\tY+A\u0007y\r>\u0014x/\u0019:eK\u00124uN\u001d\u0005\b\u0005W\u0004A\u0011\u0001Bw\u0003EAhi\u001c:xCJ$W\r\u001a$pe~#S-\u001d\u000b\u0004\u0013\n=\bbBAJ\u0005S\u0004\rA\u0017\u0005\u0007\u0005g\u0004A\u0011\u0001!\u0002!%\u001c\b,\u001c7IiR\u0004(+Z9vKN$\bb\u0002B|\u0001\u0011\u0015!\u0011`\u0001\u0007Y\u0016tw\r\u001e5\u0016\u0005\tm\bcA\u0007\u0003~&\u0019!q \b\u0003\u0007%sG\u000fC\u0004\u0004\u0004\u0001!)a!\u0002\u0002\u0013\u001d,G\u000fT3oORDGC\u0001B~\u0011\u0019\u0019I\u0001\u0001C\u0001G\u0006i1m\u001c8uK:$8\u000b\u001e:j]\u001eDqa!\u0004\u0001\t\u0003\u0019y!\u0001\thKR\u001cuN\u001c;f]R\u001cFO]5oOR\t!\fC\u0004\u0004\u0014\u0001!\ta!\u0006\u0002#\r|g\u000e^3oiN#(/\u001b8h?\u0012*\u0017\u000fF\u0002J\u0007/Aq!a%\u0004\u0012\u0001\u0007!\fC\u0004\u0004\u001c\u0001!)a!\b\u0002!M,GoQ8oi\u0016tGo\u0015;sS:<GcA%\u0004 !9\u00111SB\r\u0001\u0004Q\u0006bBB\u0012\u0001\u0011\u00051QE\u0001\u0010o&$\b.\u00138qkR\u001cFO]3b[V!1qEB\u0017)\u0011\u0019Ica\u000e\u0011\t\r-2Q\u0006\u0007\u0001\t\u001d)7\u0011\u0005b\u0001\u0007_\t2a[B\u0019!\ri11G\u0005\u0004\u0007kq!aA!os\"A1\u0011HB\u0011\u0001\u0004\u0019Y$A\u0001g!\u001di1QHB!\u0007SI1aa\u0010\u000f\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u0004D\r\u001dSBAB#\u0015\taR+\u0003\u0003\u0004J\r\u0015#aC%oaV$8\u000b\u001e:fC6Dqa!\u0014\u0001\t\u000b\u0019y%\u0001\bhKRLe\u000e];u'R\u0014X-Y7\u0015\u0005\r\u0005\u0003bBB*\u0001\u0011\u00151QK\u0001\u000bo&$\bNU3bI\u0016\u0014X\u0003BB,\u00077\"Ba!\u0017\u0004^A!11FB.\t\u001d)7\u0011\u000bb\u0001\u0007_A\u0001b!\u000f\u0004R\u0001\u00071q\f\t\b\u001b\ru2\u0011MB-!\u0011\u0019\u0019ea\u0019\n\u00079\u001a)\u0005C\u0004\u0004h\u0001!)a!\u001b\u0002\u0013\u001d,GOU3bI\u0016\u0014HCAB1\u0011\u001d\u0019i\u0007\u0001C\u0003\u0007_\nQa\u001e:ji\u0016$2!SB9\u0011\u001d\u0019\u0019ha\u001bA\u0002i\u000baa\u001d;sS:<\u0007&BB6\u001d\u000e]4%A)\t\u000f\r5\u0004\u0001\"\u0002\u0004|Q\u0019\u0011j! \t\u000f\r}4\u0011\u0010a\u00013\u0005\u0019!-\u001e4)\u000b\redja\u001e\t\u000f\r5\u0004\u0001\"\u0002\u0004\u0006R\u0019\u0011ja\"\t\u0011\r%51\u0011a\u0001\u0007\u0017\u000bQAY=uKN\u0004R!DBG\u0007#K1aa$\u000f\u0005\u0015\t%O]1z!\ri11S\u0005\u0004\u0007+s!\u0001\u0002\"zi\u0016DSaa!O\u0007oBqaa'\u0001\t\u000b\u0019i*\u0001\txSRDw*\u001e;qkR\u001cFO]3b[V!1qTBR)\u0011\u0019\tk!*\u0011\t\r-21\u0015\u0003\bK\u000ee%\u0019AB\u0018\u0011!\u0019Id!'A\u0002\r\u001d\u0006cB\u0007\u0004>\r%6\u0011\u0015\t\u0005\u0007\u0007\u001aY+\u0003\u0003\u0004.\u000e\u0015#\u0001D(viB,Ho\u0015;sK\u0006l\u0007&BBM\u001d\u000e]\u0004bBBZ\u0001\u0011\u00151QW\u0001\u000bo&$\bn\u0016:ji\u0016\u0014X\u0003BB\\\u0007w#Ba!/\u0004>B!11FB^\t\u001d)7\u0011\u0017b\u0001\u0007_A\u0001b!\u000f\u00042\u0002\u00071q\u0018\t\b\u001b\ru2\u0011YB]!\u0011\u0019\u0019ea1\n\u0007]\u001a)\u0005K\u0003\u00042:\u001b9\bC\u0004\u0004J\u0002!)A!\u0010\u0002\u0019\rdW-\u0019:D_:$XM\u001c;\t\u000f\r5\u0007\u0001\"\u0001\u0004P\u0006)1\r\\8tKR\u00111\u0011\u001b\t\u0005s\rM\u0017*C\u0002\u0004Vj\u0012aAR;ukJ,\u0007bBBm\u0001\u0011\u001511\\\u0001\nW\u0016,\u0007/\u00117jm\u0016$2!`Bo\u0011\u001d\u0019Ina6A\u0002\u0019Baa!7\u0001\t\u000b\u0001\u0005\"CBr\u0001E\u0005I\u0011ABs\u0003a\u0019X\r^\"p]R,g\u000e\u001e+za\u0016$C-\u001a4bk2$HEM\u000b\u0003\u0007OT3AWBuW\t\u0019Y\u000f\u0005\u0003\u0004n\u000e]XBABx\u0015\u0011\u0019\tpa=\u0002\u0013Ut7\r[3dW\u0016$'bAB{\u001d\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\re8q\u001e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,waBB\u007f\u0005!\u00051q`\u0001\b\u001b\u0016\u001c8/Y4f!\r1B\u0011\u0001\u0004\u0007\u0003\tA\t\u0001b\u0001\u0014\u0007\u0011\u0005A\u0002C\u0004\u0014\t\u0003!\t\u0001b\u0002\u0015\u0005\r}ha\u0002C\u0006\t\u00031AQ\u0002\u0002\u0010\u0005V4w*\u001e;qkR\u001cFO]3b[N!A\u0011\u0002C\b!\u0011\u0019\u0019\u0005\"\u0005\n\t\u0011M1Q\t\u0002\u0016\u0005f$X-\u0011:sCf|U\u000f\u001e9viN#(/Z1n\u0011-!9\u0002\"\u0003\u0003\u0002\u0003\u0006IAa?\u0002\u0017%t\u0017\u000e^5bYNK'0\u001a\u0005\b'\u0011%A\u0011\u0001C\u000e)\u0011!i\u0002\"\t\u0011\t\u0011}A\u0011B\u0007\u0003\t\u0003A\u0001\u0002b\u0006\u0005\u001a\u0001\u0007!1 \u0005\b\tK!I\u0001\"\u0001F\u00035\u0019wN\u001c;f]R\u001c\u0018i\u001d\"vM\"YA\u0011\u0006C\u0001\u0005\u0004%\tA\u0001C\u0016\u0003\u0011)FO\u001a\u001d\u0016\u0005\u00115\u0002\u0003\u0002C\u0018\toi!\u0001\"\r\u000b\t\u0005EH1\u0007\u0006\u0004\tk)\u0016a\u00018j_&!A\u0011\bC\u0019\u0005\u001d\u0019\u0005.\u0019:tKRD\u0011\u0002\"\u0010\u0005\u0002\u0001\u0006I\u0001\"\f\u0002\u000bU#h\r\u000f\u0011\t\u0015\u0011\u0005C\u0011\u0001b\u0001\n\u0003!\u0019%A\u0006DQ\u0006\u00148/\u001a;Vi\u001aDTC\u0001C#!\r\u0011FqI\u0005\u0003?NC\u0011\u0002b\u0013\u0005\u0002\u0001\u0006I\u0001\"\u0012\u0002\u0019\rC\u0017M]:fiV#h\r\u000f\u0011\t\u0015\u0011=C\u0011\u0001b\u0001\n\u0003!\u0019%A\bD_:$XM\u001c;UsB,'j]8o\u0011%!\u0019\u0006\"\u0001!\u0002\u0013!)%\u0001\tD_:$XM\u001c;UsB,'j]8oA!QAq\u000bC\u0001\u0005\u0004%\t\u0001b\u0011\u0002)\r{g\u000e^3oiRK\b/\u001a&t_:\u0004\u0016\r^2i\u0011%!Y\u0006\"\u0001!\u0002\u0013!)%A\u000bD_:$XM\u001c;UsB,'j]8o!\u0006$8\r\u001b\u0011\t\u0015\u0011}C\u0011\u0001b\u0001\n\u0003!\u0019%A\u000bD_:$XM\u001c;UsB,'*\u0019<bg\u000e\u0014\u0018\u000e\u001d;\t\u0013\u0011\rD\u0011\u0001Q\u0001\n\u0011\u0015\u0013AF\"p]R,g\u000e\u001e+za\u0016T\u0015M^1tGJL\u0007\u000f\u001e\u0011\t\u0015\u0011\u001dD\u0011\u0001b\u0001\n\u0003!\u0019%\u0001\nD_:$XM\u001c;UsB,wk^<G_Jl\u0007\"\u0003C6\t\u0003\u0001\u000b\u0011\u0002C#\u0003M\u0019uN\u001c;f]R$\u0016\u0010]3Xo^4uN]7!\u0011)!y\u0007\"\u0001C\u0002\u0013%A\u0011O\u0001\u000f\u0011R$\b\u000fR1uK\u001a{'/\\1u+\t!\u0019\b\u0005\u0003\u0005v\u0011}TB\u0001C<\u0015\u0011!I\bb\u001f\u0002\r\u0019|'/\\1u\u0015\r!i(V\u0001\u0005i&lW-\u0003\u0003\u0005\u0002\u0012]$!\u0005#bi\u0016$\u0016.\\3G_Jl\u0017\r\u001e;fe\"IAQ\u0011C\u0001A\u0003%A1O\u0001\u0010\u0011R$\b\u000fR1uK\u001a{'/\\1uA!AA\u0011\u0012C\u0001\t\u0003!Y)\u0001\biiR\u0004H)\u0019;f\r>\u0014X.\u0019;\u0015\u0007i#i\t\u0003\u0005\u0003B\u0011\u001d\u0005\u0019\u0001B)\u0001")
public abstract class Message {
    private Buf _content = Buf$.MODULE$.Empty();
    private Version _version = Version$.MODULE$.Http11();
    private boolean _chunked = false;
    private CookieMap cookies;
    private volatile boolean bitmap$0;

    public static String httpDateFormat(Date date) {
        return Message$.MODULE$.httpDateFormat(date);
    }

    public static String ContentTypeWwwForm() {
        return Message$.MODULE$.ContentTypeWwwForm();
    }

    public static String ContentTypeJavascript() {
        return Message$.MODULE$.ContentTypeJavascript();
    }

    public static String ContentTypeJsonPatch() {
        return Message$.MODULE$.ContentTypeJsonPatch();
    }

    public static String ContentTypeJson() {
        return Message$.MODULE$.ContentTypeJson();
    }

    public static String CharsetUtf8() {
        return Message$.MODULE$.CharsetUtf8();
    }

    private CookieMap cookies$lzycompute() {
        Message message = this;
        synchronized (message) {
            if (!this.bitmap$0) {
                this.cookies = new CookieMap(this);
                this.bitmap$0 = true;
            }
            return this.cookies;
        }
    }

    public abstract com.twitter.io.Reader<Buf> reader();

    public abstract com.twitter.io.Writer<Buf> writer();

    public abstract boolean isRequest();

    public boolean isResponse() {
        return !this.isRequest();
    }

    public Buf content() {
        return this._content;
    }

    public void content_$eq(Buf content) throws IllegalStateException {
        if (!content.isEmpty() && this.isChunked()) {
            throw new IllegalStateException("Cannot set content on Chunked message");
        }
        this._content = content;
    }

    public final Message content(Buf content) throws IllegalStateException {
        this.content_$eq(content);
        return this;
    }

    public Version version() {
        return this._version;
    }

    public void version_$eq(Version version) {
        this._version = version;
    }

    public final Message version(Version version) {
        this.version_$eq(version);
        return this;
    }

    public boolean isChunked() {
        return this._chunked;
    }

    public void setChunked(boolean chunked) {
        this._chunked = chunked;
        if (chunked) {
            this.clearContent();
        }
    }

    public abstract HeaderMap headerMap();

    public CookieMap cookies() {
        return this.bitmap$0 ? this.cookies : this.cookies$lzycompute();
    }

    public Iterator<Cookie> getCookies() {
        return (Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(this.cookies().valuesIterator()).asJava();
    }

    public void addCookie(Cookie cookie) {
        this.cookies().$plus$eq(cookie);
    }

    public void removeCookie(String name) {
        this.cookies().$minus$eq(name);
    }

    public Seq<String> accept() {
        Option<String> option;
        block4: {
            Seq seq;
            block3: {
                block2: {
                    option = this.headerMap().get("Accept");
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String s = (String)some.x();
                    seq = Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])s.split(",")).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String x$1) {
                            return x$1.trim();
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(String x$2) {
                            return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
                        }
                    }));
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                seq = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
            return seq;
        }
        throw new MatchError(option);
    }

    public void accept_$eq(String value) {
        this.headerMap().set("Accept", value);
    }

    public void accept_$eq(Iterable<String> values) {
        this.accept_$eq(values.mkString(", "));
    }

    public Seq<String> acceptMediaTypes() {
        return (Seq)((GenericTraversableTemplate)this.accept().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply(String x$3) {
                return Predef$.MODULE$.refArrayOps((Object[])x$3.split(";", 2)).headOption().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String x$4) {
                        return x$4.trim().toLowerCase();
                    }
                }).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(String x$5) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$5)).nonEmpty();
                    }
                });
            }
        }, Seq$.MODULE$.canBuildFrom())).flatten((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<String> apply(Option<String> xo) {
                return Option$.MODULE$.option2Iterable(xo);
            }
        });
    }

    public Option<String> allow() {
        return this.headerMap().get("Allow");
    }

    public void allow_$eq(String value) {
        this.headerMap().set("Allow", value);
    }

    public void allow_$eq(Iterable<Method> values) {
        this.allow_$eq(values.mkString(",").toUpperCase());
    }

    public Option<String> authorization() {
        return this.headerMap().get("Authorization");
    }

    public void authorization_$eq(String value) {
        this.headerMap().set("Authorization", value);
    }

    public Option<String> cacheControl() {
        return this.headerMap().get("Cache-Control");
    }

    public void cacheControl_$eq(String value) {
        this.headerMap().set("Cache-Control", value);
    }

    public void cacheControl_$eq(Duration maxAge) {
        this.cacheControl_$eq(new StringBuilder().append((Object)"max-age=").append((Object)((Object)BoxesRunTime.boxToInteger((int)maxAge.inSeconds())).toString()).append((Object)", must-revalidate").toString());
    }

    public Option<String> charset() {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            None$ none$;
            Object object = new Object();
            try {
                this.contentType().foreach((Function1)new Serializable(this, object){
                    public static final long serialVersionUID = 0L;
                    public final Object nonLocalReturnKey1$1;

                    public final void apply(String contentType) {
                        IndexedSeq<String> parts = StringUtil$.MODULE$.split(contentType, ';');
                        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), parts.length() - 1).foreach$mVc$sp((Function1)new Serializable(this, parts){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$charset$1 $outer;
                            private final IndexedSeq parts$1;

                            public final void apply(int i) {
                                this.apply$mcVI$sp(i);
                            }

                            public void apply$mcVI$sp(int i) {
                                String part = ((String)this.parts$1.apply(i)).trim();
                                if (part.startsWith("charset=")) {
                                    int equalsIndex = part.indexOf(61);
                                    String charset2 = part.substring(equalsIndex + 1);
                                    throw new NonLocalReturnControl(this.$outer.nonLocalReturnKey1$1, (Object)new Some((Object)charset2));
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.parts$1 = parts$1;
                            }
                        });
                    }
                    {
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                none$ = None$.MODULE$;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                none$ = (Option)nonLocalReturnControl2.value();
            }
            return none$;
        }
        throw nonLocalReturnControl2;
    }

    public void charset_$eq(String value) {
        String contentType = (String)this.contentType().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        IndexedSeq<String> parts = StringUtil$.MODULE$.split(contentType, ';');
        if (parts.isEmpty()) {
            this.contentType_$eq(new StringBuilder().append((Object)";charset=").append((Object)value).toString());
            return;
        }
        StringBuilder builder = new StringBuilder((String)parts.apply(0));
        if (parts.exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$6) {
                return x$6.trim().startsWith("charset=");
            }
        })) {
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), parts.length() - 1).foreach((Function1)new Serializable(this, value, parts, builder){
                public static final long serialVersionUID = 0L;
                private final String value$1;
                private final IndexedSeq parts$2;
                private final StringBuilder builder$1;

                public final StringBuilder apply(int i) {
                    StringBuilder stringBuilder;
                    String part = (String)this.parts$2.apply(i);
                    if (part.trim().startsWith("charset=")) {
                        this.builder$1.append(";charset=");
                        stringBuilder = this.builder$1.append(this.value$1);
                    } else {
                        this.builder$1.append(";");
                        stringBuilder = this.builder$1.append(part);
                    }
                    return stringBuilder;
                }
                {
                    this.value$1 = value$1;
                    this.parts$2 = parts$2;
                    this.builder$1 = builder$1;
                }
            });
        } else {
            builder.append(";charset=");
            builder.append(value);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), parts.length() - 1).foreach((Function1)new Serializable(this, parts, builder){
                public static final long serialVersionUID = 0L;
                private final IndexedSeq parts$2;
                private final StringBuilder builder$1;

                public final StringBuilder apply(int i) {
                    this.builder$1.append(";");
                    return this.builder$1.append((String)this.parts$2.apply(i));
                }
                {
                    this.parts$2 = parts$2;
                    this.builder$1 = builder$1;
                }
            });
        }
        this.contentType_$eq(builder.toString());
    }

    public Option<Object> contentLength() {
        return this.headerMap().get("Content-Length").map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(String x$7) {
                return new StringOps(Predef$.MODULE$.augmentString(x$7)).toLong();
            }
        });
    }

    public final long contentLengthOrElse(long l) {
        Option<Object> option;
        block4: {
            long l2;
            block3: {
                block2: {
                    long len;
                    option = this.contentLength();
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    l2 = len = BoxesRunTime.unboxToLong((Object)some.x());
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                l2 = l;
            }
            return l2;
        }
        throw new MatchError(option);
    }

    public void contentLength_$eq(long value) {
        this.headerMap().set("Content-Length", ((Object)BoxesRunTime.boxToLong((long)value)).toString());
    }

    public final Message contentLength(long value) {
        this.contentLength_$eq(value);
        return this;
    }

    public Option<String> contentType() {
        return this.headerMap().get("Content-Type");
    }

    public void contentType_$eq(String value) {
        this.headerMap().set("Content-Type", value);
    }

    public void setContentType(String mediaType2, String charset2) {
        this.headerMap().set("Content-Type", new StringBuilder().append((Object)mediaType2).append((Object)";charset=").append((Object)charset2).toString());
    }

    public String setContentType$default$2() {
        return "utf-8";
    }

    public void setContentTypeJson() {
        this.headerMap().set("Content-Type", Message$.MODULE$.ContentTypeJson());
    }

    public Option<String> date() {
        return this.headerMap().get("Date");
    }

    public void date_$eq(String value) {
        this.headerMap().set("Date", value);
    }

    public void date_$eq(Date value) {
        this.date_$eq(Message$.MODULE$.httpDateFormat(value));
    }

    public Option<String> expires() {
        return this.headerMap().get("Expires");
    }

    public void expires_$eq(String value) {
        this.headerMap().set("Expires", value);
    }

    public void expires_$eq(Date value) {
        this.expires_$eq(Message$.MODULE$.httpDateFormat(value));
    }

    public Option<String> host() {
        return this.headerMap().get("Host");
    }

    public void host_$eq(String value) {
        this.headerMap().set("Host", value);
    }

    public final Message host(String value) {
        this.host_$eq(value);
        return this;
    }

    public Option<String> lastModified() {
        return this.headerMap().get("Last-Modified");
    }

    public void lastModified_$eq(String value) {
        this.headerMap().set("Last-Modified", value);
    }

    public void lastModified_$eq(Date value) {
        this.lastModified_$eq(Message$.MODULE$.httpDateFormat(value));
    }

    public Option<String> location() {
        return this.headerMap().get("Location");
    }

    public void location_$eq(String value) {
        this.headerMap().set("Location", value);
    }

    public Option<String> mediaType() {
        return this.contentType().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply(String contentType) {
                String string;
                int n = contentType.indexOf(";");
                switch (n) {
                    default: {
                        string = contentType.substring(0, n);
                        break;
                    }
                    case -1: {
                        string = contentType;
                    }
                }
                String beforeSemi = string;
                String mediaType2 = beforeSemi.trim();
                return new StringOps(Predef$.MODULE$.augmentString(mediaType2)).nonEmpty() ? new Some((Object)mediaType2.toLowerCase()) : None$.MODULE$;
            }
        });
    }

    public void mediaType_$eq(String value) {
        Option<String> option;
        block7: {
            block6: {
                block5: {
                    BoxedUnit boxedUnit;
                    option = this.contentType();
                    if (!(option instanceof Some)) break block5;
                    Some some = (Some)option;
                    String contentType = (String)some.x();
                    IndexedSeq<String> parts = StringUtil$.MODULE$.split(contentType, ';', 2);
                    if (parts.length() == 2) {
                        this.contentType_$eq(new StringBuilder().append((Object)value).append((Object)";").append(parts.apply(1)).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        this.contentType_$eq(value);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    break block6;
                }
                if (!None$.MODULE$.equals(option)) break block7;
                this.contentType_$eq(value);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(option);
    }

    public Option<String> referer() {
        return this.headerMap().get("Referer");
    }

    public void referer_$eq(String value) {
        this.headerMap().set("Referer", value);
    }

    public Option<String> retryAfter() {
        return this.headerMap().get("Retry-After");
    }

    public void retryAfter_$eq(String value) {
        this.headerMap().set("Retry-After", value);
    }

    public void retryAfter_$eq(long value) {
        this.retryAfter_$eq(((Object)BoxesRunTime.boxToLong((long)value)).toString());
    }

    public Option<String> server() {
        return this.headerMap().get("Server");
    }

    public void server_$eq(String value) {
        this.headerMap().set("Server", value);
    }

    public Option<String> userAgent() {
        return this.headerMap().get("User-Agent");
    }

    public void userAgent_$eq(String value) {
        this.headerMap().set("User-Agent", value);
    }

    public Option<String> wwwAuthenticate() {
        return this.headerMap().get("Www-Authenticate");
    }

    public void wwwAuthenticate_$eq(String value) {
        this.headerMap().set("Www-Authenticate", value);
    }

    public Option<String> xForwardedFor() {
        return this.headerMap().get("X-Forwarded-For");
    }

    public void xForwardedFor_$eq(String value) {
        this.headerMap().set("X-Forwarded-For", value);
    }

    public boolean isXmlHttpRequest() {
        return this.headerMap().get("X-Requested-With").exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$8) {
                return x$8.toLowerCase().contains("xmlhttprequest");
            }
        });
    }

    public final int length() {
        return this.content().length();
    }

    public final int getLength() {
        return this.length();
    }

    public String contentString() {
        Charset charset2;
        try {
            charset2 = Charset.forName((String)this.charset().getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "UTF-8";
                }
            }));
        }
        catch (Throwable throwable) {
            charset2 = Message$.MODULE$.Utf8();
        }
        Charset encoding = charset2;
        return Buf$.MODULE$.decodeString(this.content(), encoding);
    }

    public String getContentString() {
        return this.contentString();
    }

    public void contentString_$eq(String value) {
        String string = value;
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.clearContent();
        } else {
            this.content_$eq(Buf.Utf8$.MODULE$.apply(value));
        }
    }

    public final void setContentString(String value) {
        this.contentString_$eq(value);
    }

    /*
     * WARNING - void declaration
     */
    public <T> T withInputStream(Function1<InputStream, T> f) {
        Object object;
        InputStream inputStream = this.getInputStream();
        try {
            object = f.apply((Object)inputStream);
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.close();
            throw throwable;
        }
        inputStream.close();
        return (T)object;
    }

    public final InputStream getInputStream() {
        return new BufInputStream(this.content());
    }

    public final <T> T withReader(Function1<Reader, T> f) {
        return this.withInputStream((Function1<InputStream, T>)new Serializable(this, f){
            public static final long serialVersionUID = 0L;
            private final Function1 f$1;

            public final T apply(InputStream inputStream) {
                InputStreamReader reader = new InputStreamReader(inputStream);
                return (T)this.f$1.apply((Object)reader);
            }
            {
                this.f$1 = f$1;
            }
        });
    }

    public final Reader getReader() {
        return new InputStreamReader(this.getInputStream());
    }

    public final void write(String string) throws IllegalStateException {
        this.write(Buf.Utf8$.MODULE$.apply(string));
    }

    public final void write(Buf buf) throws IllegalStateException {
        if (this.isChunked()) {
            throw new IllegalStateException("Cannot write buffers to a chunked message!");
        }
        this.content_$eq(this.content().concat(buf));
    }

    public final void write(byte[] bytes) throws IllegalStateException {
        this.write(Buf.ByteArray$.Shared$.MODULE$.apply(bytes));
    }

    /*
     * WARNING - void declaration
     */
    public final <T> T withOutputStream(Function1<OutputStream, T> f) throws IllegalStateException {
        Object object;
        BufOutputStream outputStream = new BufOutputStream(1024);
        try {
            Object result = f.apply((Object)outputStream);
            this.write(outputStream.contentsAsBuf());
            object = result;
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.close();
            throw throwable;
        }
        outputStream.close();
        return (T)object;
    }

    public final <T> T withWriter(Function1<Writer, T> f) throws IllegalStateException {
        return this.withOutputStream((Function1<OutputStream, T>)new Serializable(this, f){
            public static final long serialVersionUID = 0L;
            private final Function1 f$2;

            /*
             * WARNING - void declaration
             */
            public final T apply(OutputStream outputStream) {
                Object object;
                OutputStreamWriter writer = new OutputStreamWriter(outputStream, Message$.MODULE$.Utf8());
                try {
                    object = this.f$2.apply((Object)writer);
                }
                catch (Throwable throwable) {
                    void var2_2;
                    var2_2.close();
                    throw throwable;
                }
                writer.close();
                return (T)object;
            }
            {
                this.f$2 = f$2;
            }
        });
    }

    public final void clearContent() {
        this.content_$eq(Buf$.MODULE$.Empty());
    }

    public Future<BoxedUnit> close() {
        return ((Closable)this.writer()).close();
    }

    public final Message keepAlive(boolean keepAlive) {
        Version version = this.version();
        Version version2 = Version$.MODULE$.Http10();
        Version version3 = version;
        Object object = !(version2 != null ? !((Object)version2).equals(version3) : version3 != null) ? (keepAlive ? this.headerMap().set("Connection", "keep-alive") : this.headerMap().remove("Connection")) : (keepAlive ? this.headerMap().remove("Connection") : this.headerMap().set("Connection", "close"));
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean keepAlive() {
        String value;
        boolean bl = false;
        Some some = null;
        Option<String> option = this.headerMap().get("Connection");
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            String value2 = (String)some.x();
            if (value2.equalsIgnoreCase("close")) {
                return false;
            }
        }
        if (bl && (value = (String)some.x()).equalsIgnoreCase("keep-alive")) {
            return true;
        }
        Version version = this.version();
        Version version2 = Version$.MODULE$.Http11();
        if (version != null) {
            if (!((Object)version).equals(version2)) return false;
            return true;
        }
        if (version2 == null) return true;
        return false;
    }

    public static final class BufOutputStream
    extends ByteArrayOutputStream {
        public Buf contentsAsBuf() {
            return Buf.ByteArray$.Owned$.MODULE$.apply(this.buf, 0, this.count);
        }

        public BufOutputStream(int initialSize) {
            super(initialSize);
        }
    }
}

