/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.codec;

import com.twitter.finagle.Dentry;
import com.twitter.finagle.Dtab;
import com.twitter.finagle.Dtab$;
import com.twitter.finagle.Failure;
import com.twitter.finagle.Failure$;
import com.twitter.finagle.NameTree;
import com.twitter.finagle.NameTree$;
import com.twitter.finagle.Path;
import com.twitter.finagle.http.Message;
import com.twitter.util.Return;
import com.twitter.util.Throw;
import com.twitter.util.Try;
import com.twitter.util.Try$;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqView;
import scala.collection.SeqView$;
import scala.collection.TraversableViewLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

public final class HttpDtab$ {
    public static final HttpDtab$ MODULE$;
    private final String com$twitter$finagle$http$codec$HttpDtab$$Header;
    private final String Prefix;
    private final int Maxsize;
    private final Base64.Encoder Base64Encoder;
    private final Base64.Decoder Base64Decoder;
    private final Failure unmatchedFailure;
    private final Return<Dtab> EmptyReturn;

    static {
        new HttpDtab$();
    }

    public String com$twitter$finagle$http$codec$HttpDtab$$Header() {
        return this.com$twitter$finagle$http$codec$HttpDtab$$Header;
    }

    private String Prefix() {
        return this.Prefix;
    }

    private int Maxsize() {
        return this.Maxsize;
    }

    private Base64.Encoder Base64Encoder() {
        return this.Base64Encoder;
    }

    private Base64.Decoder Base64Decoder() {
        return this.Base64Decoder;
    }

    private String b64Encode(String v) {
        byte[] encoded = this.Base64Encoder().encode(v.getBytes(StandardCharsets.UTF_8));
        return new String(encoded, StandardCharsets.US_ASCII);
    }

    private Try<String> b64Decode(String v) {
        Return return_;
        try {
            byte[] decoded = this.Base64Decoder().decode(v);
            return_ = new Return((Object)new String(decoded, StandardCharsets.UTF_8));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable t = (Throwable)option.get();
            Throw throw_ = new Throw(t);
            return_ = throw_;
        }
        return return_;
    }

    private Failure unmatchedFailure() {
        return this.unmatchedFailure;
    }

    private Failure decodingFailure(String value) {
        return Failure$.MODULE$.apply(new StringBuilder().append((Object)"Value not b64-encoded: ").append((Object)value).toString());
    }

    public Failure com$twitter$finagle$http$codec$HttpDtab$$prefixFailure(String prefix, IllegalArgumentException cause) {
        return Failure$.MODULE$.apply(new StringBuilder().append((Object)"Invalid prefix: ").append((Object)prefix).toString(), (Throwable)cause);
    }

    public Failure com$twitter$finagle$http$codec$HttpDtab$$nameFailure(String name, IllegalArgumentException cause) {
        return Failure$.MODULE$.apply(new StringBuilder().append((Object)"Invalid name: ").append((Object)name).toString(), (Throwable)cause);
    }

    private Try<Dentry.Prefix> decodePrefix(String b64pfx) {
        Try<String> try_;
        block5: {
            Throw throw_;
            block3: {
                block4: {
                    Throw throw_2;
                    boolean bl;
                    block2: {
                        bl = false;
                        throw_2 = null;
                        try_ = this.b64Decode(b64pfx);
                        if (!(try_ instanceof Throw)) break block2;
                        bl = true;
                        throw_2 = (Throw)try_;
                        if (!(throw_2.e() instanceof IllegalArgumentException)) break block2;
                        throw_ = new Throw((Throwable)this.decodingFailure(b64pfx));
                        break block3;
                    }
                    if (!bl) break block4;
                    Throwable e = throw_2.e();
                    throw_ = new Throw(e);
                    break block3;
                }
                if (!(try_ instanceof Return)) break block5;
                Return return_ = (Return)try_;
                String pfxStr = (String)return_.r();
                throw_ = Try$.MODULE$.apply((Function0)new Serializable(pfxStr){
                    public static final long serialVersionUID = 0L;
                    private final String pfxStr$1;

                    public final Dentry.Prefix apply() {
                        return Dentry.Prefix$.MODULE$.read(this.pfxStr$1);
                    }
                    {
                        this.pfxStr$1 = pfxStr$1;
                    }
                }).rescue((PartialFunction)new Serializable(pfxStr){
                    public static final long serialVersionUID = 0L;
                    private final String pfxStr$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 instanceof IllegalArgumentException) {
                            IllegalArgumentException illegalArgumentException = (IllegalArgumentException)A1;
                            object = new Throw((Throwable)HttpDtab$.MODULE$.com$twitter$finagle$http$codec$HttpDtab$$prefixFailure(this.pfxStr$1, illegalArgumentException));
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        boolean bl = throwable instanceof IllegalArgumentException;
                        return bl;
                    }
                    {
                        this.pfxStr$1 = pfxStr$1;
                    }
                });
            }
            return throw_;
        }
        throw new MatchError(try_);
    }

    public Try<NameTree<Path>> com$twitter$finagle$http$codec$HttpDtab$$decodeName(String b64name) {
        Try<String> try_;
        block5: {
            Throw throw_;
            block3: {
                block4: {
                    Throw throw_2;
                    boolean bl;
                    block2: {
                        bl = false;
                        throw_2 = null;
                        try_ = this.b64Decode(b64name);
                        if (!(try_ instanceof Throw)) break block2;
                        bl = true;
                        throw_2 = (Throw)try_;
                        if (!(throw_2.e() instanceof IllegalArgumentException)) break block2;
                        throw_ = new Throw((Throwable)this.decodingFailure(b64name));
                        break block3;
                    }
                    if (!bl) break block4;
                    Throwable e = throw_2.e();
                    throw_ = new Throw(e);
                    break block3;
                }
                if (!(try_ instanceof Return)) break block5;
                Return return_ = (Return)try_;
                String nameStr = (String)return_.r();
                throw_ = Try$.MODULE$.apply((Function0)new Serializable(nameStr){
                    public static final long serialVersionUID = 0L;
                    private final String nameStr$1;

                    public final NameTree<Path> apply() {
                        return NameTree$.MODULE$.read(this.nameStr$1);
                    }
                    {
                        this.nameStr$1 = nameStr$1;
                    }
                }).rescue((PartialFunction)new Serializable(nameStr){
                    public static final long serialVersionUID = 0L;
                    private final String nameStr$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x2;
                        if (A1 instanceof IllegalArgumentException) {
                            IllegalArgumentException illegalArgumentException = (IllegalArgumentException)A1;
                            object = new Throw((Throwable)HttpDtab$.MODULE$.com$twitter$finagle$http$codec$HttpDtab$$nameFailure(this.nameStr$1, illegalArgumentException));
                        } else {
                            object = function1.apply(x2);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Throwable x2) {
                        Throwable throwable = x2;
                        boolean bl = throwable instanceof IllegalArgumentException;
                        return bl;
                    }
                    {
                        this.nameStr$1 = nameStr$1;
                    }
                });
            }
            return throw_;
        }
        throw new MatchError(try_);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean validHeaderPair(String aKey, String bKey) {
        if (aKey.length() != bKey.length()) return false;
        if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(aKey), aKey.length() - 1) != 'a') return false;
        if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(bKey), bKey.length() - 1) != 'b') return false;
        String string = aKey.substring(0, aKey.length() - 1);
        String string2 = bKey.substring(0, bKey.length() - 1);
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    private boolean isDtabHeader(Tuple2<String, String> hdr) {
        return ((String)hdr._1()).equalsIgnoreCase(this.com$twitter$finagle$http$codec$HttpDtab$$Header()) || ((String)hdr._1()).regionMatches(true, 0, this.Prefix(), 0, this.Prefix().length());
    }

    private Return<Dtab> EmptyReturn() {
        return this.EmptyReturn;
    }

    public Seq<Tuple2<String, String>> strip(Message msg) {
        ArrayBuffer headerArr = null;
        Iterator headerIt = msg.headerMap().iterator();
        while (headerIt.hasNext()) {
            BoxedUnit boxedUnit;
            Tuple2 header = (Tuple2)headerIt.next();
            if (this.isDtabHeader((Tuple2<String, String>)header)) {
                if (headerArr == null) {
                    headerArr = new ArrayBuffer();
                }
                headerArr.$plus$eq((Object)header);
                boxedUnit = msg.headerMap().$minus$eq(header._1());
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        return headerArr == null ? Nil$.MODULE$ : headerArr;
    }

    public void clear(Message msg) {
        Iterator headerIt = msg.headerMap().iterator();
        while (headerIt.hasNext()) {
            Tuple2 header = (Tuple2)headerIt.next();
            Object object = this.isDtabHeader((Tuple2<String, String>)header) ? msg.headerMap().$minus$eq(header._1()) : BoxedUnit.UNIT;
        }
    }

    public void write(Dtab dtab, Message msg) {
        if (dtab.isEmpty()) {
            return;
        }
        if (dtab.size() >= this.Maxsize()) {
            throw new IllegalArgumentException("Dtabs with length greater than 100 are not serializable with HTTP");
        }
        msg.headerMap().set(this.com$twitter$finagle$http$codec$HttpDtab$$Header(), dtab.show());
    }

    public Try<Dtab> read(Message msg) {
        return this.readXDtabPairs(msg).flatMap((Function1)new Serializable(msg){
            public static final long serialVersionUID = 0L;
            private final Message msg$1;

            public final Try<Dtab> apply(Dtab dtab0) {
                return HttpDtab$.MODULE$.com$twitter$finagle$http$codec$HttpDtab$$readDtabLocal(this.msg$1).map((Function1)new Serializable(this, dtab0){
                    public static final long serialVersionUID = 0L;
                    private final Dtab dtab0$1;

                    public final Dtab apply(Dtab dtab1) {
                        return this.dtab0$1.$plus$plus(dtab1);
                    }
                    {
                        this.dtab0$1 = dtab0$1;
                    }
                });
            }
            {
                this.msg$1 = msg$1;
            }
        });
    }

    public Try<Dtab> com$twitter$finagle$http$codec$HttpDtab$$readDtabLocal(Message msg) {
        return msg.headerMap().contains(this.com$twitter$finagle$http$codec$HttpDtab$$Header()) ? Try$.MODULE$.apply((Function0)new Serializable(msg){
            public static final long serialVersionUID = 0L;
            private final Message msg$3;

            public final Dtab apply() {
                Seq<String> headers = this.msg$3.headerMap().getAll(HttpDtab$.MODULE$.com$twitter$finagle$http$codec$HttpDtab$$Header());
                SeqView dentries = (SeqView)((TraversableViewLike)headers.view().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<String> apply(String x$1) {
                        return Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(x$1)).split(','));
                    }
                }, SeqView$.MODULE$.canBuildFrom())).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Dtab apply(String x$2) {
                        return Dtab$.MODULE$.read(x$2);
                    }
                }, SeqView$.MODULE$.canBuildFrom());
                return new Dtab((IndexedSeq)dentries.toIndexedSeq());
            }
            {
                this.msg$3 = msg$3;
            }
        }) : this.EmptyReturn();
    }

    private Try<Dtab> readXDtabPairs(Message msg) {
        ArrayBuffer keys = null;
        Iterator headers = msg.headerMap().iterator();
        while (headers.hasNext()) {
            BoxedUnit boxedUnit;
            String key = ((String)((Tuple2)headers.next())._1()).toLowerCase();
            if (key.startsWith(this.Prefix())) {
                if (keys == null) {
                    keys = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                }
                boxedUnit = keys.$plus$eq((Object)key);
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        if (keys == null) {
            return this.EmptyReturn();
        }
        if (keys.size() % 2 != 0) {
            return new Throw((Throwable)this.unmatchedFailure());
        }
        keys = (ArrayBuffer)keys.sorted((Ordering)Ordering.String$.MODULE$);
        int n = keys.size() / 2;
        Dentry[] dentries = new Dentry[n];
        for (int i = 0; i < n; ++i) {
            String dest;
            int j = i * 2;
            String prefix = (String)keys.apply(j);
            if (this.validHeaderPair(prefix, dest = (String)keys.apply(j + 1))) {
                Try tryDentry = this.decodePrefix((String)msg.headerMap().apply(prefix)).flatMap((Function1)new Serializable(msg, dest){
                    public static final long serialVersionUID = 0L;
                    private final Message msg$2;
                    private final String dest$1;

                    public final Try<Dentry> apply(Dentry.Prefix pfx) {
                        return HttpDtab$.MODULE$.com$twitter$finagle$http$codec$HttpDtab$$decodeName((String)this.msg$2.headerMap().apply(this.dest$1)).map((Function1)new Serializable(this, pfx){
                            public static final long serialVersionUID = 0L;
                            private final Dentry.Prefix pfx$1;

                            public final Dentry apply(NameTree<Path> name) {
                                return new Dentry(this.pfx$1, name);
                            }
                            {
                                this.pfx$1 = pfx$1;
                            }
                        });
                    }
                    {
                        this.msg$2 = msg$2;
                        this.dest$1 = dest$1;
                    }
                });
                Try try_ = tryDentry;
                if (try_ instanceof Return) {
                    Dentry dentry;
                    Dentry dentry2;
                    Return return_ = (Return)try_;
                    dentries[i] = dentry2 = (dentry = (Dentry)return_.r());
                    continue;
                }
                if (try_ instanceof Throw) {
                    Throw throw_ = (Throw)try_;
                    Throwable e = throw_.e();
                    return new Throw(e);
                }
                throw new MatchError((Object)try_);
            }
            return new Throw((Throwable)this.unmatchedFailure());
        }
        return new Return((Object)new Dtab((IndexedSeq)Predef$.MODULE$.wrapRefArray((Object[])dentries)));
    }

    private HttpDtab$() {
        MODULE$ = this;
        this.com$twitter$finagle$http$codec$HttpDtab$$Header = "dtab-local";
        this.Prefix = "x-dtab-";
        this.Maxsize = 100;
        this.Base64Encoder = Base64.getEncoder();
        this.Base64Decoder = Base64.getDecoder();
        this.unmatchedFailure = Failure$.MODULE$.apply("Unmatched X-Dtab headers");
        this.EmptyReturn = new Return((Object)Dtab$.MODULE$.empty());
    }
}

