/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.examples;

import com.twitter.elephantbird.mapreduce.input.LzoTextInputFormat;
import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.mapreduce.lib.reduce.LongSumReducer;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LzoWordCount
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(LzoWordCount.class);

    private LzoWordCount() {
    }

    public int run(String[] args) throws Exception {
        if (args.length != 2) {
            System.out.println("Usage: hadoop jar path/to/this.jar " + ((Object)((Object)this)).getClass() + " <input dir> <output dir>");
            System.exit(1);
        }
        Job job = new Job(this.getConf());
        job.setJobName("LZO Word Count");
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(LongWritable.class);
        job.setJarByClass(((Object)((Object)this)).getClass());
        job.setMapperClass(LzoWordCountMapper.class);
        job.setCombinerClass(LongSumReducer.class);
        job.setReducerClass(LongSumReducer.class);
        job.setInputFormatClass(LzoTextInputFormat.class);
        job.setOutputFormatClass(TextOutputFormat.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(args[0])});
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(args[1]));
        return job.waitForCompletion(true) ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        int exitCode = ToolRunner.run((Tool)new LzoWordCount(), (String[])args);
        System.exit(exitCode);
    }

    public static class LzoWordCountMapper
    extends Mapper<LongWritable, Text, Text, LongWritable> {
        private final LongWritable one_ = new LongWritable(1L);
        private final Text word_ = new Text();

        protected void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            String line = value.toString();
            StringTokenizer tokenizer = new StringTokenizer(line);
            while (tokenizer.hasMoreTokens()) {
                this.word_.set(tokenizer.nextToken());
                context.write((Object)this.word_, (Object)this.one_);
            }
        }
    }
}

