/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.examples;

import com.twitter.elephantbird.examples.proto.Examples;
import com.twitter.elephantbird.mapreduce.input.MultiInputFormat;
import com.twitter.elephantbird.mapreduce.io.ProtobufConverter;
import com.twitter.elephantbird.mapreduce.io.ProtobufWritable;
import com.twitter.elephantbird.mapreduce.output.LzoProtobufB64LineOutputFormat;
import com.twitter.elephantbird.mapreduce.output.LzoProtobufBlockOutputFormat;
import com.twitter.elephantbird.util.HadoopCompat;
import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;

public class ProtobufMRExample {
    private ProtobufMRExample() {
    }

    public int runTextToLzo(String[] args, Configuration conf) throws Exception {
        Job job = new Job(conf);
        job.setJobName("Protobuf Example : Text to LzoB64Line");
        job.setJarByClass(this.getClass());
        job.setMapperClass(TextMapper.class);
        job.setNumReduceTasks(0);
        job.setInputFormatClass(TextInputFormat.class);
        if (conf.get("proto.test.format", "B64Line").equals("Block")) {
            LzoProtobufBlockOutputFormat.setClassConf(Examples.Age.class, (Configuration)HadoopCompat.getConfiguration((JobContext)job));
            job.setOutputFormatClass(LzoProtobufBlockOutputFormat.class);
        } else {
            LzoProtobufB64LineOutputFormat.setClassConf(Examples.Age.class, (Configuration)HadoopCompat.getConfiguration((JobContext)job));
            job.setOutputFormatClass(LzoProtobufB64LineOutputFormat.class);
        }
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(args[0])});
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(args[1]));
        return job.waitForCompletion(true) ? 0 : 1;
    }

    int runLzoToText(String[] args, Configuration conf) throws Exception {
        Job job = new Job(conf);
        job.setJobName("Protobuf Example : LzoB64Line to Text");
        job.setJarByClass(this.getClass());
        job.setMapperClass(LzoMapper.class);
        job.setNumReduceTasks(0);
        MultiInputFormat.setInputFormatClass(Examples.Age.class, (Job)job);
        job.setOutputFormatClass(TextOutputFormat.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(args[0])});
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(args[1]));
        return job.waitForCompletion(true) ? 0 : 1;
    }

    int runSorter(String[] args, Configuration conf) throws Exception {
        Job job = new Job(conf);
        job.setJobName("Protobuf Example : ProtobufWritable as Map output class");
        job.setJarByClass(this.getClass());
        job.setMapperClass(SortMapper.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(ProtobufWritable.class);
        job.setReducerClass(SortReducer.class);
        job.setNumReduceTasks(1);
        job.setInputFormatClass(TextInputFormat.class);
        job.setOutputFormatClass(TextOutputFormat.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(args[0])});
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(args[1]));
        return job.waitForCompletion(true) ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        String test;
        Configuration conf = new Configuration();
        args = new GenericOptionsParser(conf, args).getRemainingArgs();
        ProtobufMRExample runner = new ProtobufMRExample();
        if (args.length != 2) {
            System.out.println("Usage: hadoop jar path/to/this.jar " + runner.getClass() + " <input dir> <output dir>");
            System.exit(1);
        }
        if ((test = conf.get("proto.test", "lzoIn")).equals("lzoIn")) {
            System.exit(runner.runLzoToText(args, conf));
        }
        if (test.equals("lzoOut")) {
            System.exit(runner.runTextToLzo(args, conf));
        }
        if (test.equals("sort")) {
            System.exit(runner.runSorter(args, conf));
        }
    }

    public static class SortReducer
    extends Reducer<Text, ProtobufWritable<Examples.Age>, Text, Text> {
        ProtobufConverter<Examples.Age> converter = ProtobufConverter.newInstance(Examples.Age.class);

        protected void reduce(Text key, Iterable<ProtobufWritable<Examples.Age>> values, Reducer.Context context) throws IOException, InterruptedException {
            for (ProtobufWritable<Examples.Age> value : values) {
                value.setConverter(this.converter);
                context.write(null, (Object)new Text(((Examples.Age)value.get()).getName() + "\t" + ((Examples.Age)value.get()).getAge()));
            }
        }
    }

    public static class SortMapper
    extends Mapper<LongWritable, Text, Text, ProtobufWritable<Examples.Age>> {
        ProtobufWritable<Examples.Age> protoWritable = ProtobufWritable.newInstance(Examples.Age.class);

        protected void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            String name;
            StringTokenizer line = new StringTokenizer(value.toString(), "\t\r\n");
            if (line.hasMoreTokens() && (name = line.nextToken()) != null && line.hasMoreTokens()) {
                this.protoWritable.set((Object)Examples.Age.newBuilder().setName(name).setAge(Integer.parseInt(line.nextToken())).build());
                context.write((Object)new Text(name), this.protoWritable);
            }
        }
    }

    public static class LzoMapper
    extends Mapper<LongWritable, ProtobufWritable<Examples.Age>, Text, Text> {
        protected void map(LongWritable key, ProtobufWritable<Examples.Age> value, Mapper.Context context) throws IOException, InterruptedException {
            Examples.Age age = (Examples.Age)value.get();
            context.write(null, (Object)new Text(age.getName() + "\t" + age.getAge()));
        }
    }

    public static class TextMapper
    extends Mapper<LongWritable, Text, NullWritable, ProtobufWritable<Examples.Age>> {
        ProtobufWritable<Examples.Age> protoWritable = ProtobufWritable.newInstance(Examples.Age.class);

        protected void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            String name;
            StringTokenizer line = new StringTokenizer(value.toString(), "\t\r\n");
            if (line.hasMoreTokens() && (name = line.nextToken()) != null && line.hasMoreTokens()) {
                this.protoWritable.set((Object)Examples.Age.newBuilder().setName(name).setAge(Integer.parseInt(line.nextToken())).build());
                context.write(null, this.protoWritable);
            }
        }
    }
}

